/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntitySmallFireball;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityBlaze
extends EntityMob {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private int field_40152_d;

    public EntityBlaze(World par1World) {
        super(par1World);
        this.texture = "/mob/fire.png";
        this.isImmuneToFire = true;
        this.attackStrength = 6;
        this.experienceValue = 10;
    }

    @Override
    public int getMaxHealth() {
        return 20;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
    }

    @Override
    protected String getLivingSound() {
        return "mob.blaze.breathe";
    }

    @Override
    protected String getHurtSound() {
        return "mob.blaze.hit";
    }

    @Override
    protected String getDeathSound() {
        return "mob.blaze.death";
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
    }

    @Override
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    @Override
    public float getBrightness(float par1) {
        return 1.0f;
    }

    @Override
    public void onLivingUpdate() {
        if (!this.worldObj.isRemote) {
            if (this.isWet()) {
                this.attackEntityFrom(DamageSource.drown, 1);
            }
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = 0.5f + (float)this.rand.nextGaussian() * 3.0f;
            }
            if (this.getEntityToAttack() != null && this.getEntityToAttack().posY + (double)this.getEntityToAttack().getEyeHeight() > this.posY + (double)this.getEyeHeight() + (double)this.heightOffset) {
                this.motionY += ((double)0.3f - this.motionY) * (double)0.3f;
            }
        }
        if (this.rand.nextInt(24) == 0) {
            this.worldObj.playSoundEffect(this.posX + 0.5, this.posY + 0.5, this.posZ + 0.5, "fire.fire", 1.0f + this.rand.nextFloat(), this.rand.nextFloat() * 0.7f + 0.3f);
        }
        if (!this.onGround && this.motionY < 0.0) {
            this.motionY *= 0.6;
        }
        for (int i = 0; i < 2; ++i) {
            this.worldObj.spawnParticle("largesmoke", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, 0.0, 0.0, 0.0);
        }
        super.onLivingUpdate();
    }

    @Override
    protected void attackEntity(Entity par1Entity, float par2) {
        if (this.attackTime <= 0 && par2 < 2.0f && par1Entity.boundingBox.maxY > this.boundingBox.minY && par1Entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            this.attackEntityAsMob(par1Entity);
        } else if (par2 < 30.0f) {
            double d = par1Entity.posX - this.posX;
            double d1 = par1Entity.boundingBox.minY + (double)(par1Entity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d2 = par1Entity.posZ - this.posZ;
            if (this.attackTime == 0) {
                ++this.field_40152_d;
                if (this.field_40152_d == 1) {
                    this.attackTime = 60;
                    this.func_40150_a(true);
                } else if (this.field_40152_d <= 4) {
                    this.attackTime = 6;
                } else {
                    this.attackTime = 100;
                    this.field_40152_d = 0;
                    this.func_40150_a(false);
                }
                if (this.field_40152_d > 1) {
                    float f = MathHelper.sqrt_float(par2) * 0.5f;
                    this.worldObj.playAuxSFXAtEntity(null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                    for (int i = 0; i < 1; ++i) {
                        EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.worldObj, this, d + this.rand.nextGaussian() * (double)f, d1, d2 + this.rand.nextGaussian() * (double)f);
                        entitysmallfireball.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
                        this.worldObj.spawnEntityInWorld(entitysmallfireball);
                    }
                }
            }
            this.rotationYaw = (float)(Math.atan2(d2, d) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    protected void fall(float f) {
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    @Override
    protected int getDropItemId() {
        return Item.blazeRod.shiftedIndex;
    }

    @Override
    public boolean isBurning() {
        return this.func_40151_ac();
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        if (par1) {
            int i = this.rand.nextInt(2 + par2);
            for (int j = 0; j < i; ++j) {
                this.dropItem(Item.blazeRod.shiftedIndex, 1);
            }
        }
    }

    public boolean func_40151_ac() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void func_40150_a(boolean par1) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        byte0 = par1 ? (byte)(byte0 | 1) : (byte)(byte0 & 0xFE);
        this.dataWatcher.updateObject(16, byte0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }
}

