/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAgeable;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public abstract class EntityAnimal
extends EntityAgeable {
    private int inLove;
    private int breeding = 0;

    public EntityAnimal(World par1World) {
        super(par1World);
    }

    @Override
    protected void updateAITick() {
        if (this.getGrowingAge() != 0) {
            this.inLove = 0;
        }
        super.updateAITick();
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.getGrowingAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            String s = "heart";
            if (this.inLove % 10 == 0) {
                double d = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.worldObj.spawnParticle(s, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            }
        } else {
            this.breeding = 0;
        }
    }

    @Override
    protected void attackEntity(Entity par1Entity, float par2) {
        if (par1Entity instanceof EntityPlayer) {
            EntityPlayer entityplayer;
            if (par2 < 3.0f) {
                double d = par1Entity.posX - this.posX;
                double d1 = par1Entity.posZ - this.posZ;
                this.rotationYaw = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
                this.hasAttacked = true;
            }
            if ((entityplayer = (EntityPlayer)par1Entity).getCurrentEquippedItem() == null || !this.isWheat(entityplayer.getCurrentEquippedItem())) {
                this.entityToAttack = null;
            }
        } else if (par1Entity instanceof EntityAnimal) {
            EntityAnimal entityanimal = (EntityAnimal)par1Entity;
            if (this.getGrowingAge() > 0 && entityanimal.getGrowingAge() < 0) {
                if ((double)par2 < 2.5) {
                    this.hasAttacked = true;
                }
            } else if (this.inLove > 0 && entityanimal.inLove > 0) {
                if (entityanimal.entityToAttack == null) {
                    entityanimal.entityToAttack = this;
                }
                if (entityanimal.entityToAttack == this && (double)par2 < 3.5) {
                    ++entityanimal.inLove;
                    ++this.inLove;
                    ++this.breeding;
                    if (this.breeding % 4 == 0) {
                        this.worldObj.spawnParticle("heart", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, 0.0, 0.0, 0.0);
                    }
                    if (this.breeding == 60) {
                        this.procreate((EntityAnimal)par1Entity);
                    }
                } else {
                    this.breeding = 0;
                }
            } else {
                this.breeding = 0;
                this.entityToAttack = null;
            }
        }
    }

    private void procreate(EntityAnimal par1EntityAnimal) {
        EntityAnimal entityanimal = this.spawnBabyAnimal(par1EntityAnimal);
        if (entityanimal != null) {
            this.setGrowingAge(6000);
            par1EntityAnimal.setGrowingAge(6000);
            this.inLove = 0;
            this.breeding = 0;
            this.entityToAttack = null;
            par1EntityAnimal.entityToAttack = null;
            par1EntityAnimal.breeding = 0;
            par1EntityAnimal.inLove = 0;
            entityanimal.setGrowingAge(-24000);
            entityanimal.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            for (int i = 0; i < 7; ++i) {
                double d = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.worldObj.spawnParticle("heart", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            }
            this.worldObj.spawnEntityInWorld(entityanimal);
        }
    }

    public abstract EntityAnimal spawnBabyAnimal(EntityAnimal var1);

    @Override
    protected void attackBlockedEntity(Entity entity, float f) {
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        this.fleeingTick = 60;
        this.entityToAttack = null;
        this.inLove = 0;
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    public float getBlockPathWeight(int par1, int par2, int par3) {
        if (this.worldObj.getBlockId(par1, par2 - 1, par3) == Block.grass.blockID) {
            return 10.0f;
        }
        return this.worldObj.getLightBrightness(par1, par2, par3) - 0.5f;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("InLove", this.inLove);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.inLove = par1NBTTagCompound.getInteger("InLove");
    }

    @Override
    protected Entity findPlayerToAttack() {
        block5: {
            float f;
            block6: {
                block4: {
                    if (this.fleeingTick > 0) {
                        return null;
                    }
                    f = 8.0f;
                    if (this.inLove <= 0) break block4;
                    List list = this.worldObj.getEntitiesWithinAABB(this.getClass(), this.boundingBox.expand(f, f, f));
                    for (int i = 0; i < list.size(); ++i) {
                        EntityAnimal entityanimal = (EntityAnimal)list.get(i);
                        if (entityanimal == this || entityanimal.inLove <= 0) continue;
                        return entityanimal;
                    }
                    break block5;
                }
                if (this.getGrowingAge() != 0) break block6;
                List list1 = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, this.boundingBox.expand(f, f, f));
                for (int j = 0; j < list1.size(); ++j) {
                    EntityPlayer entityplayer = (EntityPlayer)list1.get(j);
                    if (entityplayer.getCurrentEquippedItem() == null || !this.isWheat(entityplayer.getCurrentEquippedItem())) continue;
                    return entityplayer;
                }
                break block5;
            }
            if (this.getGrowingAge() <= 0) break block5;
            List list2 = this.worldObj.getEntitiesWithinAABB(this.getClass(), this.boundingBox.expand(f, f, f));
            for (int k = 0; k < list2.size(); ++k) {
                EntityAnimal entityanimal1 = (EntityAnimal)list2.get(k);
                if (entityanimal1 == this || entityanimal1.getGrowingAge() >= 0) continue;
                return entityanimal1;
            }
        }
        return null;
    }

    @Override
    public boolean getCanSpawnHere() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        return this.worldObj.getBlockId(i, (j = MathHelper.floor_double(this.boundingBox.minY)) - 1, k = MathHelper.floor_double(this.posZ)) == Block.grass.blockID && this.worldObj.getFullBlockLightValue(i, j, k) > 8 && super.getCanSpawnHere();
    }

    @Override
    public int getTalkInterval() {
        return 120;
    }

    @Override
    protected boolean canDespawn() {
        return false;
    }

    @Override
    protected int getExperiencePoints(EntityPlayer par1EntityPlayer) {
        return 1 + this.worldObj.rand.nextInt(3);
    }

    public boolean isWheat(ItemStack par1ItemStack) {
        return par1ItemStack.itemID == Item.wheat.shiftedIndex;
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        if (itemstack != null && this.isWheat(itemstack) && this.getGrowingAge() == 0) {
            if (!par1EntityPlayer.capabilities.isCreativeMode) {
                --itemstack.stackSize;
                if (itemstack.stackSize <= 0) {
                    par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, null);
                }
            }
            this.inLove = 600;
            this.entityToAttack = null;
            for (int i = 0; i < 7; ++i) {
                double d = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.worldObj.spawnParticle("heart", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            }
            return true;
        }
        return super.interact(par1EntityPlayer);
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetInLove() {
        this.inLove = 0;
    }

    public boolean func_48135_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (par1EntityAnimal.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && par1EntityAnimal.isInLove();
    }
}

