/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;

public class EntityAITempt
extends EntityAIBase {
    private EntityCreature temptedEntity;
    private float field_48275_b;
    private double field_48276_c;
    private double field_48273_d;
    private double field_48274_e;
    private double field_48271_f;
    private double field_48272_g;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter = 0;
    private boolean field_48280_j;
    private int breedingFood;
    private boolean scaredByPlayerMovement;
    private boolean field_48279_m;

    public EntityAITempt(EntityCreature par1EntityCreature, float par2, int par3, boolean par4) {
        this.temptedEntity = par1EntityCreature;
        this.field_48275_b = par2;
        this.breedingFood = par3;
        this.scaredByPlayerMovement = par4;
        this.setMutexBits(3);
    }

    @Override
    public boolean shouldExecute() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.worldObj.getClosestPlayerToEntity(this.temptedEntity, 10.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        ItemStack itemstack = this.temptingPlayer.getCurrentEquippedItem();
        if (itemstack == null) {
            return false;
        }
        return itemstack.itemID == this.breedingFood;
    }

    @Override
    public boolean continueExecuting() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.getDistanceSqToEntity(this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.getDistanceSq(this.field_48276_c, this.field_48273_d, this.field_48274_e) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.temptingPlayer.rotationPitch - this.field_48271_f) > 5.0 || Math.abs((double)this.temptingPlayer.rotationYaw - this.field_48272_g) > 5.0) {
                    return false;
                }
            } else {
                this.field_48276_c = this.temptingPlayer.posX;
                this.field_48273_d = this.temptingPlayer.posY;
                this.field_48274_e = this.temptingPlayer.posZ;
            }
            this.field_48271_f = this.temptingPlayer.rotationPitch;
            this.field_48272_g = this.temptingPlayer.rotationYaw;
        }
        return this.shouldExecute();
    }

    @Override
    public void startExecuting() {
        this.field_48276_c = this.temptingPlayer.posX;
        this.field_48273_d = this.temptingPlayer.posY;
        this.field_48274_e = this.temptingPlayer.posZ;
        this.field_48280_j = true;
        this.field_48279_m = this.temptedEntity.getNavigator().getAvoidsWater();
        this.temptedEntity.getNavigator().setAvoidsWater(false);
    }

    @Override
    public void resetTask() {
        this.temptingPlayer = null;
        this.temptedEntity.getNavigator().clearPathEntity();
        this.delayTemptCounter = 100;
        this.field_48280_j = false;
        this.temptedEntity.getNavigator().setAvoidsWater(this.field_48279_m);
    }

    @Override
    public void updateTask() {
        this.temptedEntity.getLookHelper().setLookPositionWithEntity(this.temptingPlayer, 30.0f, this.temptedEntity.getVerticalFaceSpeed());
        if (this.temptedEntity.getDistanceSqToEntity(this.temptingPlayer) < 6.25) {
            this.temptedEntity.getNavigator().clearPathEntity();
        } else {
            this.temptedEntity.getNavigator().func_48667_a(this.temptingPlayer, this.field_48275_b);
        }
    }

    public boolean func_48270_h() {
        return this.field_48280_j;
    }
}

