/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityVillager;
import net.minecraft.src.RandomPositionGenerator;
import net.minecraft.src.Vec3D;

public class EntityAIPlay
extends EntityAIBase {
    private EntityVillager villagerObj;
    private EntityLiving targetVillager;
    private float field_48358_c;
    private int field_48356_d;

    public EntityAIPlay(EntityVillager par1EntityVillager, float par2) {
        this.villagerObj = par1EntityVillager;
        this.field_48358_c = par2;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        Vec3D vec3d;
        if (this.villagerObj.getGrowingAge() >= 0) {
            return false;
        }
        if (this.villagerObj.getRNG().nextInt(400) != 0) {
            return false;
        }
        List list = this.villagerObj.worldObj.getEntitiesWithinAABB(EntityVillager.class, this.villagerObj.boundingBox.expand(6.0, 3.0, 6.0));
        double d = Double.MAX_VALUE;
        for (Entity entity : list) {
            double d1;
            EntityVillager entityvillager;
            if (entity == this.villagerObj || (entityvillager = (EntityVillager)entity).getIsPlayingFlag() || entityvillager.getGrowingAge() >= 0 || !((d1 = entityvillager.getDistanceSqToEntity(this.villagerObj)) <= d)) continue;
            d = d1;
            this.targetVillager = entityvillager;
        }
        return this.targetVillager != null || (vec3d = RandomPositionGenerator.func_48622_a(this.villagerObj, 16, 3)) != null;
    }

    @Override
    public boolean continueExecuting() {
        return this.field_48356_d > 0;
    }

    @Override
    public void startExecuting() {
        if (this.targetVillager != null) {
            this.villagerObj.setIsPlayingFlag(true);
        }
        this.field_48356_d = 1000;
    }

    @Override
    public void resetTask() {
        this.villagerObj.setIsPlayingFlag(false);
        this.targetVillager = null;
    }

    @Override
    public void updateTask() {
        --this.field_48356_d;
        if (this.targetVillager != null) {
            if (this.villagerObj.getDistanceSqToEntity(this.targetVillager) > 4.0) {
                this.villagerObj.getNavigator().func_48667_a(this.targetVillager, this.field_48358_c);
            }
        } else if (this.villagerObj.getNavigator().noPath()) {
            Vec3D vec3d = RandomPositionGenerator.func_48622_a(this.villagerObj, 16, 3);
            if (vec3d == null) {
                return;
            }
            this.villagerObj.getNavigator().tryMoveToXYZ(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord, this.field_48358_c);
        }
    }
}

