/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.RandomPositionGenerator;
import net.minecraft.src.Vec3D;

public class EntityAIMoveTowardsTarget
extends EntityAIBase {
    private EntityCreature theEntity;
    private EntityLiving targetEntity;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private float field_48330_f;
    private float field_48331_g;

    public EntityAIMoveTowardsTarget(EntityCreature par1EntityCreature, float par2, float par3) {
        this.theEntity = par1EntityCreature;
        this.field_48330_f = par2;
        this.field_48331_g = par3;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        this.targetEntity = this.theEntity.getAttackTarget();
        if (this.targetEntity == null) {
            return false;
        }
        if (this.targetEntity.getDistanceSqToEntity(this.theEntity) > (double)(this.field_48331_g * this.field_48331_g)) {
            return false;
        }
        Vec3D vec3d = RandomPositionGenerator.func_48620_a(this.theEntity, 16, 7, Vec3D.createVector(this.targetEntity.posX, this.targetEntity.posY, this.targetEntity.posZ));
        if (vec3d == null) {
            return false;
        }
        this.movePosX = vec3d.xCoord;
        this.movePosY = vec3d.yCoord;
        this.movePosZ = vec3d.zCoord;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        return !this.theEntity.getNavigator().noPath() && this.targetEntity.isEntityAlive() && this.targetEntity.getDistanceSqToEntity(this.theEntity) < (double)(this.field_48331_g * this.field_48331_g);
    }

    @Override
    public void resetTask() {
        this.targetEntity = null;
    }

    @Override
    public void startExecuting() {
        this.theEntity.getNavigator().tryMoveToXYZ(this.movePosX, this.movePosY, this.movePosZ, this.field_48330_f);
    }
}

