/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.RandomPositionGenerator;
import net.minecraft.src.Vec3D;
import net.minecraft.src.Village;
import net.minecraft.src.VillageDoorInfo;

public class EntityAIMoveThroughVillage
extends EntityAIBase {
    private EntityCreature theEntity;
    private float field_48290_b;
    private PathEntity field_48291_c;
    private VillageDoorInfo doorInfo;
    private boolean field_48289_e;
    private List doorList = new ArrayList();

    public EntityAIMoveThroughVillage(EntityCreature par1EntityCreature, float par2, boolean par3) {
        this.theEntity = par1EntityCreature;
        this.field_48290_b = par2;
        this.field_48289_e = par3;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        this.func_48286_h();
        if (this.field_48289_e && this.theEntity.worldObj.isDaytime()) {
            return false;
        }
        Village village = this.theEntity.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double(this.theEntity.posX), MathHelper.floor_double(this.theEntity.posY), MathHelper.floor_double(this.theEntity.posZ), 0);
        if (village == null) {
            return false;
        }
        this.doorInfo = this.func_48284_a(village);
        if (this.doorInfo == null) {
            return false;
        }
        boolean flag = this.theEntity.getNavigator().getCanBreakDoors();
        this.theEntity.getNavigator().setBreakDoors(false);
        this.field_48291_c = this.theEntity.getNavigator().getPathToXYZ(this.doorInfo.posX, this.doorInfo.posY, this.doorInfo.posZ);
        this.theEntity.getNavigator().setBreakDoors(flag);
        if (this.field_48291_c != null) {
            return true;
        }
        Vec3D vec3d = RandomPositionGenerator.func_48620_a(this.theEntity, 10, 7, Vec3D.createVector(this.doorInfo.posX, this.doorInfo.posY, this.doorInfo.posZ));
        if (vec3d == null) {
            return false;
        }
        this.theEntity.getNavigator().setBreakDoors(false);
        this.field_48291_c = this.theEntity.getNavigator().getPathToXYZ(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
        this.theEntity.getNavigator().setBreakDoors(flag);
        return this.field_48291_c != null;
    }

    @Override
    public boolean continueExecuting() {
        if (this.theEntity.getNavigator().noPath()) {
            return false;
        }
        float f = this.theEntity.width + 4.0f;
        return this.theEntity.getDistanceSq(this.doorInfo.posX, this.doorInfo.posY, this.doorInfo.posZ) > (double)(f * f);
    }

    @Override
    public void startExecuting() {
        this.theEntity.getNavigator().setPath(this.field_48291_c, this.field_48290_b);
    }

    @Override
    public void resetTask() {
        if (this.theEntity.getNavigator().noPath() || this.theEntity.getDistanceSq(this.doorInfo.posX, this.doorInfo.posY, this.doorInfo.posZ) < 16.0) {
            this.doorList.add(this.doorInfo);
        }
    }

    private VillageDoorInfo func_48284_a(Village par1Village) {
        VillageDoorInfo villagedoorinfo = null;
        int i = Integer.MAX_VALUE;
        List list = par1Village.getVillageDoorInfoList();
        for (VillageDoorInfo villagedoorinfo1 : list) {
            int j = villagedoorinfo1.getDistanceSquared(MathHelper.floor_double(this.theEntity.posX), MathHelper.floor_double(this.theEntity.posY), MathHelper.floor_double(this.theEntity.posZ));
            if (j >= i || this.func_48285_a(villagedoorinfo1)) continue;
            villagedoorinfo = villagedoorinfo1;
            i = j;
        }
        return villagedoorinfo;
    }

    private boolean func_48285_a(VillageDoorInfo par1VillageDoorInfo) {
        for (VillageDoorInfo villagedoorinfo : this.doorList) {
            if (par1VillageDoorInfo.posX != villagedoorinfo.posX || par1VillageDoorInfo.posY != villagedoorinfo.posY || par1VillageDoorInfo.posZ != villagedoorinfo.posZ) continue;
            return true;
        }
        return false;
    }

    private void func_48286_h() {
        if (this.doorList.size() > 15) {
            this.doorList.remove(0);
        }
    }
}

