/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RandomPositionGenerator;
import net.minecraft.src.Vec3D;
import net.minecraft.src.Village;
import net.minecraft.src.VillageDoorInfo;

public class EntityAIMoveIndoors
extends EntityAIBase {
    private EntityCreature entityObj;
    private VillageDoorInfo doorInfo;
    private int insidePosX = -1;
    private int insidePosZ = -1;

    public EntityAIMoveIndoors(EntityCreature par1EntityCreature) {
        this.entityObj = par1EntityCreature;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        if (this.entityObj.worldObj.isDaytime() && !this.entityObj.worldObj.isRaining() || this.entityObj.worldObj.worldProvider.hasNoSky) {
            return false;
        }
        if (this.entityObj.getRNG().nextInt(50) != 0) {
            return false;
        }
        if (this.insidePosX != -1 && this.entityObj.getDistanceSq(this.insidePosX, this.entityObj.posY, this.insidePosZ) < 4.0) {
            return false;
        }
        Village village = this.entityObj.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double(this.entityObj.posX), MathHelper.floor_double(this.entityObj.posY), MathHelper.floor_double(this.entityObj.posZ), 14);
        if (village == null) {
            return false;
        }
        this.doorInfo = village.findNearestDoorUnrestricted(MathHelper.floor_double(this.entityObj.posX), MathHelper.floor_double(this.entityObj.posY), MathHelper.floor_double(this.entityObj.posZ));
        return this.doorInfo != null;
    }

    @Override
    public boolean continueExecuting() {
        return !this.entityObj.getNavigator().noPath();
    }

    @Override
    public void startExecuting() {
        this.insidePosX = -1;
        if (this.entityObj.getDistanceSq(this.doorInfo.getInsidePosX(), this.doorInfo.posY, this.doorInfo.getInsidePosZ()) > 256.0) {
            Vec3D vec3d = RandomPositionGenerator.func_48620_a(this.entityObj, 14, 3, Vec3D.createVector((double)this.doorInfo.getInsidePosX() + 0.5, this.doorInfo.getInsidePosY(), (double)this.doorInfo.getInsidePosZ() + 0.5));
            if (vec3d != null) {
                this.entityObj.getNavigator().tryMoveToXYZ(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord, 0.3f);
            }
        } else {
            this.entityObj.getNavigator().tryMoveToXYZ((double)this.doorInfo.getInsidePosX() + 0.5, this.doorInfo.getInsidePosY(), (double)this.doorInfo.getInsidePosZ() + 0.5, 0.3f);
        }
    }

    @Override
    public void resetTask() {
        this.insidePosX = this.doorInfo.getInsidePosX();
        this.insidePosZ = this.doorInfo.getInsidePosZ();
        this.doorInfo = null;
    }
}

