/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityTameable;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathNavigate;
import net.minecraft.src.World;

public class EntityAIFollowOwner
extends EntityAIBase {
    private EntityTameable thePet;
    private EntityLiving theOwner;
    World theWorld;
    private float field_48303_f;
    private PathNavigate petPathfinder;
    private int field_48310_h;
    float maxDist;
    float minDist;
    private boolean field_48311_i;

    public EntityAIFollowOwner(EntityTameable par1EntityTameable, float par2, float par3, float par4) {
        this.thePet = par1EntityTameable;
        this.theWorld = par1EntityTameable.worldObj;
        this.field_48303_f = par2;
        this.petPathfinder = par1EntityTameable.getNavigator();
        this.minDist = par3;
        this.maxDist = par4;
        this.setMutexBits(3);
    }

    @Override
    public boolean shouldExecute() {
        EntityLiving entityliving = this.thePet.getOwner();
        if (entityliving == null) {
            return false;
        }
        if (this.thePet.isSitting()) {
            return false;
        }
        if (this.thePet.getDistanceSqToEntity(entityliving) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.theOwner = entityliving;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        return !this.petPathfinder.noPath() && this.thePet.getDistanceSqToEntity(this.theOwner) > (double)(this.maxDist * this.maxDist) && !this.thePet.isSitting();
    }

    @Override
    public void startExecuting() {
        this.field_48310_h = 0;
        this.field_48311_i = this.thePet.getNavigator().getAvoidsWater();
        this.thePet.getNavigator().setAvoidsWater(false);
    }

    @Override
    public void resetTask() {
        this.theOwner = null;
        this.petPathfinder.clearPathEntity();
        this.thePet.getNavigator().setAvoidsWater(this.field_48311_i);
    }

    @Override
    public void updateTask() {
        this.thePet.getLookHelper().setLookPositionWithEntity(this.theOwner, 10.0f, this.thePet.getVerticalFaceSpeed());
        if (this.thePet.isSitting()) {
            return;
        }
        if (--this.field_48310_h > 0) {
            return;
        }
        this.field_48310_h = 10;
        if (this.petPathfinder.func_48667_a(this.theOwner, this.field_48303_f)) {
            return;
        }
        if (this.thePet.getDistanceSqToEntity(this.theOwner) < 144.0) {
            return;
        }
        int i = MathHelper.floor_double(this.theOwner.posX) - 2;
        int j = MathHelper.floor_double(this.theOwner.posZ) - 2;
        int k = MathHelper.floor_double(this.theOwner.boundingBox.minY);
        for (int l = 0; l <= 4; ++l) {
            for (int i1 = 0; i1 <= 4; ++i1) {
                if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.theWorld.isBlockNormalCube(i + l, k - 1, j + i1) || this.theWorld.isBlockNormalCube(i + l, k, j + i1) || this.theWorld.isBlockNormalCube(i + l, k + 1, j + i1)) continue;
                this.thePet.setLocationAndAngles((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.thePet.rotationYaw, this.thePet.rotationPitch);
                this.petPathfinder.clearPathEntity();
                return;
            }
        }
    }
}

