/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class EntityAIEatGrass
extends EntityAIBase {
    private EntityLiving theEntity;
    private World theWorld;
    int eatGrassTick = 0;

    public EntityAIEatGrass(EntityLiving par1EntityLiving) {
        this.theEntity = par1EntityLiving;
        this.theWorld = par1EntityLiving.worldObj;
        this.setMutexBits(7);
    }

    @Override
    public boolean shouldExecute() {
        int k;
        int j;
        if (this.theEntity.getRNG().nextInt(this.theEntity.isChild() ? 50 : 1000) != 0) {
            return false;
        }
        int i = MathHelper.floor_double(this.theEntity.posX);
        if (this.theWorld.getBlockId(i, j = MathHelper.floor_double(this.theEntity.posY), k = MathHelper.floor_double(this.theEntity.posZ)) == Block.tallGrass.blockID && this.theWorld.getBlockMetadata(i, j, k) == 1) {
            return true;
        }
        return this.theWorld.getBlockId(i, j - 1, k) == Block.grass.blockID;
    }

    @Override
    public void startExecuting() {
        this.eatGrassTick = 40;
        this.theWorld.setEntityState(this.theEntity, (byte)10);
        this.theEntity.getNavigator().clearPathEntity();
    }

    @Override
    public void resetTask() {
        this.eatGrassTick = 0;
    }

    @Override
    public boolean continueExecuting() {
        return this.eatGrassTick > 0;
    }

    public int func_48396_h() {
        return this.eatGrassTick;
    }

    @Override
    public void updateTask() {
        int k;
        int j;
        this.eatGrassTick = Math.max(0, this.eatGrassTick - 1);
        if (this.eatGrassTick != 4) {
            return;
        }
        int i = MathHelper.floor_double(this.theEntity.posX);
        if (this.theWorld.getBlockId(i, j = MathHelper.floor_double(this.theEntity.posY), k = MathHelper.floor_double(this.theEntity.posZ)) == Block.tallGrass.blockID) {
            this.theWorld.playAuxSFX(2001, i, j, k, Block.tallGrass.blockID + 4096);
            this.theWorld.setBlockWithNotify(i, j, k, 0);
            this.theEntity.eatGrassBonus();
        } else if (this.theWorld.getBlockId(i, j - 1, k) == Block.grass.blockID) {
            this.theWorld.playAuxSFX(2001, i, j - 1, k, Block.grass.blockID);
            this.theWorld.setBlockWithNotify(i, j - 1, k, Block.dirt.blockID);
            this.theEntity.eatGrassBonus();
        }
    }
}

