/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityTameable;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathNavigate;
import net.minecraft.src.RandomPositionGenerator;
import net.minecraft.src.Vec3D;

public class EntityAIAvoidEntity
extends EntityAIBase {
    private EntityCreature theEntity;
    private float field_48242_b;
    private float field_48243_c;
    private Entity field_48240_d;
    private float field_48241_e;
    private PathEntity field_48238_f;
    private PathNavigate entityPathNavigate;
    private Class targetEntityClass;

    public EntityAIAvoidEntity(EntityCreature par1EntityCreature, Class par2Class, float par3, float par4, float par5) {
        this.theEntity = par1EntityCreature;
        this.targetEntityClass = par2Class;
        this.field_48241_e = par3;
        this.field_48242_b = par4;
        this.field_48243_c = par5;
        this.entityPathNavigate = par1EntityCreature.getNavigator();
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        if (this.targetEntityClass == EntityPlayer.class) {
            if (this.theEntity instanceof EntityTameable && ((EntityTameable)this.theEntity).isTamed()) {
                return false;
            }
            this.field_48240_d = this.theEntity.worldObj.getClosestPlayerToEntity(this.theEntity, this.field_48241_e);
            if (this.field_48240_d == null) {
                return false;
            }
        } else {
            List list = this.theEntity.worldObj.getEntitiesWithinAABB(this.targetEntityClass, this.theEntity.boundingBox.expand(this.field_48241_e, 3.0, this.field_48241_e));
            if (list.size() == 0) {
                return false;
            }
            this.field_48240_d = (Entity)list.get(0);
        }
        if (!this.theEntity.getEntitySenses().canSee(this.field_48240_d)) {
            return false;
        }
        Vec3D vec3d = RandomPositionGenerator.func_48623_b(this.theEntity, 16, 7, Vec3D.createVector(this.field_48240_d.posX, this.field_48240_d.posY, this.field_48240_d.posZ));
        if (vec3d == null) {
            return false;
        }
        if (this.field_48240_d.getDistanceSq(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord) < this.field_48240_d.getDistanceSqToEntity(this.theEntity)) {
            return false;
        }
        this.field_48238_f = this.entityPathNavigate.getPathToXYZ(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
        if (this.field_48238_f == null) {
            return false;
        }
        return this.field_48238_f.func_48639_a(vec3d);
    }

    @Override
    public boolean continueExecuting() {
        return !this.entityPathNavigate.noPath();
    }

    @Override
    public void startExecuting() {
        this.entityPathNavigate.setPath(this.field_48238_f, this.field_48242_b);
    }

    @Override
    public void resetTask() {
        this.field_48240_d = null;
    }

    @Override
    public void updateTask() {
        if (this.theEntity.getDistanceSqToEntity(this.field_48240_d) < 49.0) {
            this.theEntity.getNavigator().setSpeed(this.field_48243_c);
        } else {
            this.theEntity.getNavigator().setSpeed(this.field_48242_b);
        }
    }
}

