/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.World;

public class EntityAIAttackOnCollide
extends EntityAIBase {
    World worldObj;
    EntityLiving attacker;
    EntityLiving entityTarget;
    int field_46091_d = 0;
    float field_48266_e;
    boolean field_48264_f;
    PathEntity field_48265_g;
    Class classTarget;
    private int field_48269_i;

    public EntityAIAttackOnCollide(EntityLiving par1EntityLiving, Class par2Class, float par3, boolean par4) {
        this(par1EntityLiving, par3, par4);
        this.classTarget = par2Class;
    }

    public EntityAIAttackOnCollide(EntityLiving par1EntityLiving, float par2, boolean par3) {
        this.attacker = par1EntityLiving;
        this.worldObj = par1EntityLiving.worldObj;
        this.field_48266_e = par2;
        this.field_48264_f = par3;
        this.setMutexBits(3);
    }

    @Override
    public boolean shouldExecute() {
        EntityLiving entityliving = this.attacker.getAttackTarget();
        if (entityliving == null) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(entityliving.getClass())) {
            return false;
        }
        this.entityTarget = entityliving;
        this.field_48265_g = this.attacker.getNavigator().func_48679_a(this.entityTarget);
        return this.field_48265_g != null;
    }

    @Override
    public boolean continueExecuting() {
        EntityLiving entityliving = this.attacker.getAttackTarget();
        if (entityliving == null) {
            return false;
        }
        if (!this.entityTarget.isEntityAlive()) {
            return false;
        }
        if (!this.field_48264_f) {
            return !this.attacker.getNavigator().noPath();
        }
        return this.attacker.isWithinHomeDistance(MathHelper.floor_double(this.entityTarget.posX), MathHelper.floor_double(this.entityTarget.posY), MathHelper.floor_double(this.entityTarget.posZ));
    }

    @Override
    public void startExecuting() {
        this.attacker.getNavigator().setPath(this.field_48265_g, this.field_48266_e);
        this.field_48269_i = 0;
    }

    @Override
    public void resetTask() {
        this.entityTarget = null;
        this.attacker.getNavigator().clearPathEntity();
    }

    @Override
    public void updateTask() {
        this.attacker.getLookHelper().setLookPositionWithEntity(this.entityTarget, 30.0f, 30.0f);
        if ((this.field_48264_f || this.attacker.getEntitySenses().canSee(this.entityTarget)) && --this.field_48269_i <= 0) {
            this.field_48269_i = 4 + this.attacker.getRNG().nextInt(7);
            this.attacker.getNavigator().func_48667_a(this.entityTarget, this.field_48266_e);
        }
        this.field_46091_d = Math.max(this.field_46091_d - 1, 0);
        double d = this.attacker.width * 2.0f * (this.attacker.width * 2.0f);
        if (this.attacker.getDistanceSq(this.entityTarget.posX, this.entityTarget.boundingBox.minY, this.entityTarget.posZ) > d) {
            return;
        }
        if (this.field_46091_d > 0) {
            return;
        }
        this.field_46091_d = 20;
        this.attacker.attackEntityAsMob(this.entityTarget);
    }
}

