/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIBase;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class EntityAIArrowAttack
extends EntityAIBase {
    World worldObj;
    EntityLiving entityHost;
    EntityLiving attackTarget;
    int rangedAttackTime = 0;
    float field_48370_e;
    int field_48367_f = 0;
    int rangedAttackID;
    int maxRangedAttackTime;

    public EntityAIArrowAttack(EntityLiving par1EntityLiving, float par2, int par3, int par4) {
        this.entityHost = par1EntityLiving;
        this.worldObj = par1EntityLiving.worldObj;
        this.field_48370_e = par2;
        this.rangedAttackID = par3;
        this.maxRangedAttackTime = par4;
        this.setMutexBits(3);
    }

    @Override
    public boolean shouldExecute() {
        EntityLiving entityliving = this.entityHost.getAttackTarget();
        if (entityliving == null) {
            return false;
        }
        this.attackTarget = entityliving;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        return this.shouldExecute() || !this.entityHost.getNavigator().noPath();
    }

    @Override
    public void resetTask() {
        this.attackTarget = null;
    }

    @Override
    public void updateTask() {
        double d = 100.0;
        double d1 = this.entityHost.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ);
        boolean flag = this.entityHost.getEntitySenses().canSee(this.attackTarget);
        this.field_48367_f = flag ? ++this.field_48367_f : 0;
        if (d1 > d || this.field_48367_f < 20) {
            this.entityHost.getNavigator().func_48667_a(this.attackTarget, this.field_48370_e);
        } else {
            this.entityHost.getNavigator().clearPathEntity();
        }
        this.entityHost.getLookHelper().setLookPositionWithEntity(this.attackTarget, 30.0f, 30.0f);
        this.rangedAttackTime = Math.max(this.rangedAttackTime - 1, 0);
        if (this.rangedAttackTime > 0) {
            return;
        }
        if (d1 > d || !flag) {
            return;
        }
        this.doRangedAttack();
        this.rangedAttackTime = this.maxRangedAttackTime;
    }

    private void doRangedAttack() {
        if (this.rangedAttackID == 1) {
            EntityArrow entityarrow = new EntityArrow(this.worldObj, this.entityHost, this.attackTarget, 1.6f, 12.0f);
            this.worldObj.playSoundAtEntity(this.entityHost, "random.bow", 1.0f, 1.0f / (this.entityHost.getRNG().nextFloat() * 0.4f + 0.8f));
            this.worldObj.spawnEntityInWorld(entityarrow);
        } else if (this.rangedAttackID == 2) {
            EntitySnowball entitysnowball = new EntitySnowball(this.worldObj, this.entityHost);
            double d = this.attackTarget.posX - this.entityHost.posX;
            double d1 = this.attackTarget.posY + (double)this.attackTarget.getEyeHeight() - (double)1.1f - entitysnowball.posY;
            double d2 = this.attackTarget.posZ - this.entityHost.posZ;
            float f = MathHelper.sqrt_double(d * d + d2 * d2) * 0.2f;
            entitysnowball.setThrowableHeading(d, d1 + (double)f, d2, 1.6f, 12.0f);
            this.worldObj.playSoundAtEntity(this.entityHost, "random.bow", 1.0f, 1.0f / (this.entityHost.getRNG().nextFloat() * 0.4f + 0.8f));
            this.worldObj.spawnEntityInWorld(entitysnowball);
        }
    }
}

