/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.DamageSource;
import net.minecraft.src.Enchantment;
import net.minecraft.src.EnumEnchantmentType;

public class EnchantmentProtection
extends Enchantment {
    private static final String[] protectionName = new String[]{"all", "fire", "fall", "explosion", "projectile"};
    private static final int[] baseEnchantability = new int[]{1, 10, 5, 5, 3};
    private static final int[] levelEnchantability = new int[]{16, 8, 6, 8, 6};
    private static final int[] thresholdEnchantability = new int[]{20, 12, 10, 12, 15};
    public final int protectionType;

    public EnchantmentProtection(int par1, int par2, int par3) {
        super(par1, par2, EnumEnchantmentType.armor);
        this.protectionType = par3;
        if (par3 == 2) {
            this.type = EnumEnchantmentType.armor_feet;
        }
    }

    @Override
    public int getMinEnchantability(int par1) {
        return baseEnchantability[this.protectionType] + (par1 - 1) * levelEnchantability[this.protectionType];
    }

    @Override
    public int getMaxEnchantability(int par1) {
        return this.getMinEnchantability(par1) + thresholdEnchantability[this.protectionType];
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int calcModifierDamage(int par1, DamageSource par2DamageSource) {
        if (par2DamageSource.canHarmInCreative()) {
            return 0;
        }
        int i = (6 + par1 * par1) / 2;
        if (this.protectionType == 0) {
            return i;
        }
        if (this.protectionType == 1 && par2DamageSource.fireDamage()) {
            return i;
        }
        if (this.protectionType == 2 && par2DamageSource == DamageSource.fall) {
            return i * 2;
        }
        if (this.protectionType == 3 && par2DamageSource == DamageSource.explosion) {
            return i;
        }
        if (this.protectionType == 4 && par2DamageSource.isProjectile()) {
            return i;
        }
        return 0;
    }

    @Override
    public String getName() {
        return "enchantment.protect." + protectionName[this.protectionType];
    }

    @Override
    public boolean canApplyTogether(Enchantment par1Enchantment) {
        if (par1Enchantment instanceof EnchantmentProtection) {
            EnchantmentProtection enchantmentprotection = (EnchantmentProtection)par1Enchantment;
            if (enchantmentprotection.protectionType == this.protectionType) {
                return false;
            }
            return this.protectionType == 2 || enchantmentprotection.protectionType == 2;
        }
        return super.canApplyTogether(par1Enchantment);
    }
}

