/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagCompound;

public class CompressedStreamTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound readCompressed(InputStream par0InputStream) throws IOException {
        DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(par0InputStream)));
        try {
            NBTTagCompound nbttagcompound;
            NBTTagCompound nBTTagCompound = nbttagcompound = CompressedStreamTools.read(datainputstream);
            return nBTTagCompound;
        }
        finally {
            datainputstream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompressed(NBTTagCompound par0NBTTagCompound, OutputStream par1OutputStream) throws IOException {
        DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(par1OutputStream));
        try {
            CompressedStreamTools.write(par0NBTTagCompound, dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound decompress(byte[] par0ArrayOfByte) throws IOException {
        DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(par0ArrayOfByte))));
        try {
            NBTTagCompound nbttagcompound;
            NBTTagCompound nBTTagCompound = nbttagcompound = CompressedStreamTools.read(datainputstream);
            return nBTTagCompound;
        }
        finally {
            datainputstream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(NBTTagCompound par0NBTTagCompound) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));
        try {
            CompressedStreamTools.write(par0NBTTagCompound, dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static void safeWrite(NBTTagCompound par0NBTTagCompound, File par1File) throws IOException {
        File file = new File(par1File.getAbsolutePath() + "_tmp");
        if (file.exists()) {
            file.delete();
        }
        CompressedStreamTools.write(par0NBTTagCompound, file);
        if (par1File.exists()) {
            par1File.delete();
        }
        if (par1File.exists()) {
            throw new IOException("Failed to delete " + par1File);
        }
        file.renameTo(par1File);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(NBTTagCompound par0NBTTagCompound, File par1File) throws IOException {
        DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(par1File));
        try {
            CompressedStreamTools.write(par0NBTTagCompound, dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound read(File par0File) throws IOException {
        if (!par0File.exists()) {
            return null;
        }
        DataInputStream datainputstream = new DataInputStream(new FileInputStream(par0File));
        try {
            NBTTagCompound nbttagcompound;
            NBTTagCompound nBTTagCompound = nbttagcompound = CompressedStreamTools.read(datainputstream);
            return nBTTagCompound;
        }
        finally {
            datainputstream.close();
        }
    }

    public static NBTTagCompound read(DataInput par0DataInput) throws IOException {
        NBTBase nbtbase = NBTBase.readNamedTag(par0DataInput);
        if (nbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(NBTTagCompound par0NBTTagCompound, DataOutput par1DataOutput) throws IOException {
        NBTBase.writeNamedTag(par0NBTTagCompound, par1DataOutput);
    }
}

