/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.ComponentVillageStartPiece;
import net.minecraft.src.EntityVillager;
import net.minecraft.src.StructureBoundingBox;
import net.minecraft.src.StructureComponent;
import net.minecraft.src.StructureVillagePieces;
import net.minecraft.src.World;

abstract class ComponentVillage
extends StructureComponent {
    private int villagersSpawned;

    protected ComponentVillage(int par1) {
        super(par1);
    }

    protected StructureComponent getNextComponentNN(ComponentVillageStartPiece par1ComponentVillageStartPiece, List par2List, Random par3Random, int par4, int par5) {
        switch (this.coordBaseMode) {
            case 2: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.minX - 1, this.boundingBox.minY + par4, this.boundingBox.minZ + par5, 1, this.getComponentType());
            }
            case 0: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.minX - 1, this.boundingBox.minY + par4, this.boundingBox.minZ + par5, 1, this.getComponentType());
            }
            case 1: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.minX + par5, this.boundingBox.minY + par4, this.boundingBox.minZ - 1, 2, this.getComponentType());
            }
            case 3: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.minX + par5, this.boundingBox.minY + par4, this.boundingBox.minZ - 1, 2, this.getComponentType());
            }
        }
        return null;
    }

    protected StructureComponent getNextComponentPP(ComponentVillageStartPiece par1ComponentVillageStartPiece, List par2List, Random par3Random, int par4, int par5) {
        switch (this.coordBaseMode) {
            case 2: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.maxX + 1, this.boundingBox.minY + par4, this.boundingBox.minZ + par5, 3, this.getComponentType());
            }
            case 0: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.maxX + 1, this.boundingBox.minY + par4, this.boundingBox.minZ + par5, 3, this.getComponentType());
            }
            case 1: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.minX + par5, this.boundingBox.minY + par4, this.boundingBox.maxZ + 1, 0, this.getComponentType());
            }
            case 3: {
                return StructureVillagePieces.getNextStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.boundingBox.minX + par5, this.boundingBox.minY + par4, this.boundingBox.maxZ + 1, 0, this.getComponentType());
            }
        }
        return null;
    }

    protected int getAverageGroundLevel(World par1World, StructureBoundingBox par2StructureBoundingBox) {
        int i = 0;
        int j = 0;
        for (int k = this.boundingBox.minZ; k <= this.boundingBox.maxZ; ++k) {
            for (int l = this.boundingBox.minX; l <= this.boundingBox.maxX; ++l) {
                if (!par2StructureBoundingBox.isVecInside(l, 64, k)) continue;
                i += Math.max(par1World.getTopSolidOrLiquidBlock(l, k), par1World.worldProvider.getAverageGroundLevel());
                ++j;
            }
        }
        if (j == 0) {
            return -1;
        }
        return i / j;
    }

    protected static boolean canVillageGoDeeper(StructureBoundingBox par0StructureBoundingBox) {
        return par0StructureBoundingBox != null && par0StructureBoundingBox.minY > 10;
    }

    protected void spawnVillagers(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6) {
        int l;
        int k;
        int j;
        if (this.villagersSpawned >= par6) {
            return;
        }
        for (int i = this.villagersSpawned; i < par6 && par2StructureBoundingBox.isVecInside(j = this.getXWithOffset(par3 + i, par5), k = this.getYWithOffset(par4), l = this.getZWithOffset(par3 + i, par5)); ++i) {
            ++this.villagersSpawned;
            EntityVillager entityvillager = new EntityVillager(par1World, this.getVillagerType(i));
            entityvillager.setLocationAndAngles((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
            par1World.spawnEntityInWorld(entityvillager);
        }
    }

    protected int getVillagerType(int par1) {
        return 0;
    }
}

