/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.StructureBoundingBox;
import net.minecraft.src.StructureComponent;
import net.minecraft.src.StructureMineshaftPieces;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.World;

public class ComponentMineshaftCorridor
extends StructureComponent {
    private final boolean hasRails;
    private final boolean hasSpiders;
    private boolean spawnerPlaced;
    private int sectionCount;

    public ComponentMineshaftCorridor(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
        super(par1);
        this.coordBaseMode = par4;
        this.boundingBox = par3StructureBoundingBox;
        this.hasRails = par2Random.nextInt(3) == 0;
        this.hasSpiders = !this.hasRails && par2Random.nextInt(23) == 0;
        this.sectionCount = this.coordBaseMode == 2 || this.coordBaseMode == 0 ? par3StructureBoundingBox.getZSize() / 5 : par3StructureBoundingBox.getXSize() / 5;
    }

    public static StructureBoundingBox findValidPlacement(List par0List, Random par1Random, int par2, int par3, int par4, int par5) {
        int i;
        StructureBoundingBox structureboundingbox = new StructureBoundingBox(par2, par3, par4, par2, par3 + 2, par4);
        for (i = par1Random.nextInt(3) + 2; i > 0; --i) {
            int j = i * 5;
            switch (par5) {
                case 2: {
                    structureboundingbox.maxX = par2 + 2;
                    structureboundingbox.minZ = par4 - (j - 1);
                    break;
                }
                case 0: {
                    structureboundingbox.maxX = par2 + 2;
                    structureboundingbox.maxZ = par4 + (j - 1);
                    break;
                }
                case 1: {
                    structureboundingbox.minX = par2 - (j - 1);
                    structureboundingbox.maxZ = par4 + 2;
                    break;
                }
                case 3: {
                    structureboundingbox.maxX = par2 + (j - 1);
                    structureboundingbox.maxZ = par4 + 2;
                }
            }
            if (StructureComponent.findIntersecting(par0List, structureboundingbox) == null) break;
        }
        if (i > 0) {
            return structureboundingbox;
        }
        return null;
    }

    @Override
    public void buildComponent(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
        block24: {
            int i = this.getComponentType();
            int j = par3Random.nextInt(4);
            switch (this.coordBaseMode) {
                case 2: {
                    if (j <= 1) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.minZ - 1, this.coordBaseMode, i);
                        break;
                    }
                    if (j == 2) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.minZ, 1, i);
                        break;
                    }
                    StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.minZ, 3, i);
                    break;
                }
                case 0: {
                    if (j <= 1) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.maxZ + 1, this.coordBaseMode, i);
                        break;
                    }
                    if (j == 2) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.maxZ - 3, 1, i);
                        break;
                    }
                    StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.maxZ - 3, 3, i);
                    break;
                }
                case 1: {
                    if (j <= 1) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.minZ, this.coordBaseMode, i);
                        break;
                    }
                    if (j == 2) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.minZ - 1, 2, i);
                        break;
                    }
                    StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.maxZ + 1, 0, i);
                    break;
                }
                case 3: {
                    if (j <= 1) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.minZ, this.coordBaseMode, i);
                        break;
                    }
                    if (j == 2) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.maxX - 3, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.minZ - 1, 2, i);
                        break;
                    }
                    StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.maxX - 3, this.boundingBox.minY - 1 + par3Random.nextInt(3), this.boundingBox.maxZ + 1, 0, i);
                }
            }
            if (i >= 8) break block24;
            if (this.coordBaseMode == 2 || this.coordBaseMode == 0) {
                int k = this.boundingBox.minZ + 3;
                while (k + 3 <= this.boundingBox.maxZ) {
                    int i1 = par3Random.nextInt(5);
                    if (i1 == 0) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.minX - 1, this.boundingBox.minY, k, 1, i + 1);
                    } else if (i1 == 1) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, this.boundingBox.maxX + 1, this.boundingBox.minY, k, 3, i + 1);
                    }
                    k += 5;
                }
            } else {
                int l = this.boundingBox.minX + 3;
                while (l + 3 <= this.boundingBox.maxX) {
                    int j1 = par3Random.nextInt(5);
                    if (j1 == 0) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, l, this.boundingBox.minY, this.boundingBox.minZ - 1, 2, i + 1);
                    } else if (j1 == 1) {
                        StructureMineshaftPieces.getNextComponent(par1StructureComponent, par2List, par3Random, l, this.boundingBox.minY, this.boundingBox.maxZ + 1, 0, i + 1);
                    }
                    l += 5;
                }
            }
        }
    }

    @Override
    public boolean addComponentParts(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
        if (this.isLiquidInStructureBoundingBox(par1World, par3StructureBoundingBox)) {
            return false;
        }
        int i = this.sectionCount * 5 - 1;
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 0, 0, 0, 2, 1, i, 0, 0, false);
        this.randomlyFillWithBlocks(par1World, par3StructureBoundingBox, par2Random, 0.8f, 0, 2, 0, 2, 2, i, 0, 0, false);
        if (this.hasSpiders) {
            this.randomlyFillWithBlocks(par1World, par3StructureBoundingBox, par2Random, 0.6f, 0, 0, 0, 2, 1, i, Block.web.blockID, 0, false);
        }
        for (int j = 0; j < this.sectionCount; ++j) {
            int i1 = 2 + j * 5;
            this.fillWithBlocks(par1World, par3StructureBoundingBox, 0, 0, i1, 0, 1, i1, Block.fence.blockID, 0, false);
            this.fillWithBlocks(par1World, par3StructureBoundingBox, 2, 0, i1, 2, 1, i1, Block.fence.blockID, 0, false);
            if (par2Random.nextInt(4) != 0) {
                this.fillWithBlocks(par1World, par3StructureBoundingBox, 0, 2, i1, 2, 2, i1, Block.planks.blockID, 0, false);
            } else {
                this.fillWithBlocks(par1World, par3StructureBoundingBox, 0, 2, i1, 0, 2, i1, Block.planks.blockID, 0, false);
                this.fillWithBlocks(par1World, par3StructureBoundingBox, 2, 2, i1, 2, 2, i1, Block.planks.blockID, 0, false);
            }
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.1f, 0, 2, i1 - 1, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.1f, 2, 2, i1 - 1, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.1f, 0, 2, i1 + 1, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.1f, 2, 2, i1 + 1, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.05f, 0, 2, i1 - 2, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.05f, 2, 2, i1 - 2, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.05f, 0, 2, i1 + 2, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.05f, 2, 2, i1 + 2, Block.web.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.05f, 1, 2, i1 - 1, Block.torchWood.blockID, 0);
            this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.05f, 1, 2, i1 + 1, Block.torchWood.blockID, 0);
            if (par2Random.nextInt(100) == 0) {
                this.createTreasureChestAtCurrentPosition(par1World, par3StructureBoundingBox, par2Random, 2, 0, i1 - 1, StructureMineshaftPieces.getTreasurePieces(), 3 + par2Random.nextInt(4));
            }
            if (par2Random.nextInt(100) == 0) {
                this.createTreasureChestAtCurrentPosition(par1World, par3StructureBoundingBox, par2Random, 0, 0, i1 + 1, StructureMineshaftPieces.getTreasurePieces(), 3 + par2Random.nextInt(4));
            }
            if (!this.hasSpiders || this.spawnerPlaced) continue;
            int l1 = this.getYWithOffset(0);
            int j2 = i1 - 1 + par2Random.nextInt(3);
            int k2 = this.getXWithOffset(1, j2);
            if (!par3StructureBoundingBox.isVecInside(k2, l1, j2 = this.getZWithOffset(1, j2))) continue;
            this.spawnerPlaced = true;
            par1World.setBlockWithNotify(k2, l1, j2, Block.mobSpawner.blockID);
            TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)par1World.getBlockTileEntity(k2, l1, j2);
            if (tileentitymobspawner == null) continue;
            tileentitymobspawner.setMobID("CaveSpider");
        }
        for (int k = 0; k <= 2; ++k) {
            for (int j1 = 0; j1 <= i; ++j1) {
                int i2 = this.getBlockIdAtCurrentPosition(par1World, k, -1, j1, par3StructureBoundingBox);
                if (i2 != 0) continue;
                this.placeBlockAtCurrentPosition(par1World, Block.planks.blockID, 0, k, -1, j1, par3StructureBoundingBox);
            }
        }
        if (this.hasRails) {
            for (int l = 0; l <= i; ++l) {
                int k1 = this.getBlockIdAtCurrentPosition(par1World, 1, -1, l, par3StructureBoundingBox);
                if (k1 <= 0 || !Block.opaqueCubeLookup[k1]) continue;
                this.randomlyPlaceBlock(par1World, par3StructureBoundingBox, par2Random, 0.7f, 1, 0, l, Block.rail.blockID, this.getMetadataWithOffset(Block.rail.blockID, 0));
            }
        }
        return true;
    }
}

