/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.util.List;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.World;

public class ChunkProviderLoadOrGenerate
implements IChunkProvider {
    private Chunk blankChunk;
    private IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private Chunk[] chunks;
    private World worldObj;
    int lastQueriedChunkXPos;
    int lastQueriedChunkZPosition;
    private Chunk lastQueriedChunk;
    private int curChunkX;
    private int curChunkY;

    public void setCurrentChunkOver(int par1, int par2) {
        this.curChunkX = par1;
        this.curChunkY = par2;
    }

    public boolean canChunkExist(int par1, int par2) {
        int byte0 = 15;
        return par1 >= this.curChunkX - byte0 && par2 >= this.curChunkY - byte0 && par1 <= this.curChunkX + byte0 && par2 <= this.curChunkY + byte0;
    }

    @Override
    public boolean chunkExists(int par1, int par2) {
        if (!this.canChunkExist(par1, par2)) {
            return false;
        }
        if (par1 == this.lastQueriedChunkXPos && par2 == this.lastQueriedChunkZPosition && this.lastQueriedChunk != null) {
            return true;
        }
        int i = par1 & 0x1F;
        int j = par2 & 0x1F;
        int k = i + j * 32;
        return this.chunks[k] != null && (this.chunks[k] == this.blankChunk || this.chunks[k].isAtLocation(par1, par2));
    }

    @Override
    public Chunk loadChunk(int par1, int par2) {
        return this.provideChunk(par1, par2);
    }

    @Override
    public Chunk provideChunk(int par1, int par2) {
        if (par1 == this.lastQueriedChunkXPos && par2 == this.lastQueriedChunkZPosition && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.worldObj.findingSpawnPoint && !this.canChunkExist(par1, par2)) {
            return this.blankChunk;
        }
        int i = par1 & 0x1F;
        int j = par2 & 0x1F;
        int k = i + j * 32;
        if (!this.chunkExists(par1, par2)) {
            Chunk chunk;
            if (this.chunks[k] != null) {
                this.chunks[k].onChunkUnload();
                this.saveChunk(this.chunks[k]);
                this.saveExtraChunkData(this.chunks[k]);
            }
            if ((chunk = this.func_542_c(par1, par2)) == null) {
                if (this.chunkProvider == null) {
                    chunk = this.blankChunk;
                } else {
                    chunk = this.chunkProvider.provideChunk(par1, par2);
                    chunk.removeUnknownBlocks();
                }
            }
            this.chunks[k] = chunk;
            chunk.func_4143_d();
            if (this.chunks[k] != null) {
                this.chunks[k].onChunkLoad();
            }
            this.chunks[k].populateChunk(this, this, par1, par2);
        }
        this.lastQueriedChunkXPos = par1;
        this.lastQueriedChunkZPosition = par2;
        this.lastQueriedChunk = this.chunks[k];
        return this.chunks[k];
    }

    private Chunk func_542_c(int par1, int par2) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, par1, par2);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.blankChunk;
        }
    }

    private void saveExtraChunkData(Chunk par1Chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            this.chunkLoader.saveExtraChunkData(this.worldObj, par1Chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveChunk(Chunk par1Chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            par1Chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.chunkLoader.saveChunk(this.worldObj, par1Chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void populate(IChunkProvider par1IChunkProvider, int par2, int par3) {
        Chunk chunk = this.provideChunk(par2, par3);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(par1IChunkProvider, par2, par3);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean par1, IProgressUpdate par2IProgressUpdate) {
        int i = 0;
        int j = 0;
        if (par2IProgressUpdate != null) {
            for (int k = 0; k < this.chunks.length; ++k) {
                if (this.chunks[k] == null || !this.chunks[k].needsSaving(par1)) continue;
                ++j;
            }
        }
        int l = 0;
        for (int i1 = 0; i1 < this.chunks.length; ++i1) {
            if (this.chunks[i1] == null) continue;
            if (par1) {
                this.saveExtraChunkData(this.chunks[i1]);
            }
            if (!this.chunks[i1].needsSaving(par1)) continue;
            this.saveChunk(this.chunks[i1]);
            this.chunks[i1].isModified = false;
            if (++i == 2 && !par1) {
                return false;
            }
            if (par2IProgressUpdate == null || ++l % 10 != 0) continue;
            par2IProgressUpdate.setLoadingProgress(l * 100 / j);
        }
        if (par1) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        if (this.chunkLoader != null) {
            this.chunkLoader.chunkTick();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "ChunkCache: " + this.chunks.length;
    }

    @Override
    public List getPossibleCreatures(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        return this.chunkProvider.getPossibleCreatures(par1EnumCreatureType, par2, par3, par4);
    }

    @Override
    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int par4, int par5) {
        return this.chunkProvider.findClosestStructure(par1World, par2Str, par3, par4, par5);
    }
}

