/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCavesHell;
import net.minecraft.src.MapGenNetherBridge;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenFire;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenGlowStone1;
import net.minecraft.src.WorldGenGlowStone2;
import net.minecraft.src.WorldGenHellLava;

public class ChunkProviderHell
implements IChunkProvider {
    private Random hellRNG;
    private NoiseGeneratorOctaves netherNoiseGen1;
    private NoiseGeneratorOctaves netherNoiseGen2;
    private NoiseGeneratorOctaves netherNoiseGen3;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves netherNoiseGen6;
    public NoiseGeneratorOctaves netherNoiseGen7;
    private World worldObj;
    private double[] field_4163_o;
    public MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] netherrackExclusivityNoise = new double[256];
    private MapGenBase netherCaveGenerator = new MapGenCavesHell();
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;

    public ChunkProviderHell(World par1World, long par2) {
        this.worldObj = par1World;
        this.hellRNG = new Random(par2);
        this.netherNoiseGen1 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen2 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen3 = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherNoiseGen6 = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.netherNoiseGen7 = new NoiseGeneratorOctaves(this.hellRNG, 16);
    }

    public void generateNetherTerrain(int par1, int par2, byte[] par3ArrayOfByte) {
        int byte0 = 4;
        int byte1 = 32;
        int i = byte0 + 1;
        int byte2 = 17;
        int j = byte0 + 1;
        this.field_4163_o = this.func_4057_a(this.field_4163_o, par1 * byte0, 0, par2 * byte0, i, byte2, j);
        for (int k = 0; k < byte0; ++k) {
            for (int l = 0; l < byte0; ++l) {
                for (int i1 = 0; i1 < 16; ++i1) {
                    double d = 0.125;
                    double d1 = this.field_4163_o[((k + 0) * j + (l + 0)) * byte2 + (i1 + 0)];
                    double d2 = this.field_4163_o[((k + 0) * j + (l + 1)) * byte2 + (i1 + 0)];
                    double d3 = this.field_4163_o[((k + 1) * j + (l + 0)) * byte2 + (i1 + 0)];
                    double d4 = this.field_4163_o[((k + 1) * j + (l + 1)) * byte2 + (i1 + 0)];
                    double d5 = (this.field_4163_o[((k + 0) * j + (l + 0)) * byte2 + (i1 + 1)] - d1) * d;
                    double d6 = (this.field_4163_o[((k + 0) * j + (l + 1)) * byte2 + (i1 + 1)] - d2) * d;
                    double d7 = (this.field_4163_o[((k + 1) * j + (l + 0)) * byte2 + (i1 + 1)] - d3) * d;
                    double d8 = (this.field_4163_o[((k + 1) * j + (l + 1)) * byte2 + (i1 + 1)] - d4) * d;
                    for (int j1 = 0; j1 < 8; ++j1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k1 = 0; k1 < 4; ++k1) {
                            int l1 = k1 + k * 4 << 11 | 0 + l * 4 << 7 | i1 * 8 + j1;
                            int c = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                int j2 = 0;
                                if (i1 * 8 + j1 < byte1) {
                                    j2 = Block.lavaStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    j2 = Block.netherrack.blockID;
                                }
                                par3ArrayOfByte[l1] = (byte)j2;
                                l1 += c;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_4058_b(int par1, int par2, byte[] par3ArrayOfByte) {
        int byte0 = 64;
        double d = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.generateNoiseOctaves(this.slowsandNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d, d, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.generateNoiseOctaves(this.gravelNoise, par1 * 16, 109, par2 * 16, 16, 1, 16, d, 1.0, d);
        this.netherrackExclusivityNoise = this.netherrackExculsivityNoiseGen.generateNoiseOctaves(this.netherrackExclusivityNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                boolean flag = this.slowsandNoise[i + j * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[i + j * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                int k = (int)(this.netherrackExclusivityNoise[i + j * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int l = -1;
                byte byte1 = (byte)Block.netherrack.blockID;
                byte byte2 = (byte)Block.netherrack.blockID;
                for (int i1 = 127; i1 >= 0; --i1) {
                    int j1 = (j * 16 + i) * 128 + i1;
                    if (i1 >= 127 - this.hellRNG.nextInt(5)) {
                        par3ArrayOfByte[j1] = (byte)Block.bedrock.blockID;
                        continue;
                    }
                    if (i1 <= 0 + this.hellRNG.nextInt(5)) {
                        par3ArrayOfByte[j1] = (byte)Block.bedrock.blockID;
                        continue;
                    }
                    byte byte3 = par3ArrayOfByte[j1];
                    if (byte3 == 0) {
                        l = -1;
                        continue;
                    }
                    if (byte3 != Block.netherrack.blockID) continue;
                    if (l == -1) {
                        if (k <= 0) {
                            byte1 = 0;
                            byte2 = (byte)Block.netherrack.blockID;
                        } else if (i1 >= byte0 - 4 && i1 <= byte0 + 1) {
                            byte1 = (byte)Block.netherrack.blockID;
                            byte2 = (byte)Block.netherrack.blockID;
                            if (flag1) {
                                byte1 = (byte)Block.gravel.blockID;
                            }
                            if (flag1) {
                                byte2 = (byte)Block.netherrack.blockID;
                            }
                            if (flag) {
                                byte1 = (byte)Block.slowSand.blockID;
                            }
                            if (flag) {
                                byte2 = (byte)Block.slowSand.blockID;
                            }
                        }
                        if (i1 < byte0 && byte1 == 0) {
                            byte1 = (byte)Block.lavaStill.blockID;
                        }
                        l = k;
                        if (i1 >= byte0 - 1) {
                            par3ArrayOfByte[j1] = byte1;
                            continue;
                        }
                        par3ArrayOfByte[j1] = byte2;
                        continue;
                    }
                    if (l <= 0) continue;
                    --l;
                    par3ArrayOfByte[j1] = byte2;
                }
            }
        }
    }

    @Override
    public Chunk loadChunk(int par1, int par2) {
        return this.provideChunk(par1, par2);
    }

    @Override
    public Chunk provideChunk(int par1, int par2) {
        this.hellRNG.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        byte[] abyte0 = new byte[32768];
        this.generateNetherTerrain(par1, par2, abyte0);
        this.func_4058_b(par1, par2, abyte0);
        this.netherCaveGenerator.generate(this, this.worldObj, par1, par2, abyte0);
        this.genNetherBridge.generate(this, this.worldObj, par1, par2, abyte0);
        Chunk chunk = new Chunk(this.worldObj, abyte0, par1, par2);
        BiomeGenBase[] abiomegenbase = this.worldObj.getWorldChunkManager().loadBlockGeneratorData(null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte1 = chunk.getBiomeArray();
        for (int i = 0; i < abyte1.length; ++i) {
            abyte1[i] = (byte)abiomegenbase[i].biomeID;
        }
        chunk.resetRelightChecks();
        return chunk;
    }

    private double[] func_4057_a(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        double d = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.netherNoiseGen6.generateNoiseOctaves(this.noiseData4, par2, par3, par4, par5, 1, par7, 1.0, 0.0, 1.0);
        this.noiseData5 = this.netherNoiseGen7.generateNoiseOctaves(this.noiseData5, par2, par3, par4, par5, 1, par7, 100.0, 0.0, 100.0);
        this.noiseData1 = this.netherNoiseGen3.generateNoiseOctaves(this.noiseData1, par2, par3, par4, par5, par6, par7, d / 80.0, d1 / 60.0, d / 80.0);
        this.noiseData2 = this.netherNoiseGen1.generateNoiseOctaves(this.noiseData2, par2, par3, par4, par5, par6, par7, d, d1, d);
        this.noiseData3 = this.netherNoiseGen2.generateNoiseOctaves(this.noiseData3, par2, par3, par4, par5, par6, par7, d, d1, d);
        int i = 0;
        int j = 0;
        double[] ad = new double[par6];
        for (int k = 0; k < par6; ++k) {
            ad[k] = Math.cos((double)k * Math.PI * 6.0 / (double)par6) * 2.0;
            double d2 = k;
            if (k > par6 / 2) {
                d2 = par6 - 1 - k;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = k;
            ad[n] = ad[n] - d2 * d2 * d2 * 10.0;
        }
        for (int l = 0; l < par5; ++l) {
            for (int i1 = 0; i1 < par7; ++i1) {
                double d3 = (this.noiseData4[j] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[j] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)par6 / 16.0;
                ++j;
                for (int j1 = 0; j1 < par6; ++j1) {
                    double d6 = 0.0;
                    double d7 = ad[j1];
                    double d8 = this.noiseData2[i] / 512.0;
                    double d9 = this.noiseData3[i] / 512.0;
                    double d10 = (this.noiseData1[i] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (j1 > par6 - 4) {
                        double d11 = (float)(j1 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)j1 < d4) {
                        double d12 = (d4 - (double)j1) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    par1ArrayOfDouble[i] = d6;
                    ++i;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    @Override
    public boolean chunkExists(int par1, int par2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockSand.fallInstantly = true;
        int i = par2 * 16;
        int j = par3 * 16;
        this.genNetherBridge.generateStructuresInChunk(this.worldObj, this.hellRNG, par2, par3);
        for (int k = 0; k < 8; ++k) {
            int i1 = i + this.hellRNG.nextInt(16) + 8;
            int k2 = this.hellRNG.nextInt(120) + 4;
            int i4 = j + this.hellRNG.nextInt(16) + 8;
            new WorldGenHellLava(Block.lavaMoving.blockID).generate(this.worldObj, this.hellRNG, i1, k2, i4);
        }
        int l = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1) + 1;
        for (int j1 = 0; j1 < l; ++j1) {
            int l2 = i + this.hellRNG.nextInt(16) + 8;
            int j4 = this.hellRNG.nextInt(120) + 4;
            int k5 = j + this.hellRNG.nextInt(16) + 8;
            new WorldGenFire().generate(this.worldObj, this.hellRNG, l2, j4, k5);
        }
        l = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        for (int k1 = 0; k1 < l; ++k1) {
            int i3 = i + this.hellRNG.nextInt(16) + 8;
            int k4 = this.hellRNG.nextInt(120) + 4;
            int l5 = j + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone1().generate(this.worldObj, this.hellRNG, i3, k4, l5);
        }
        for (int l1 = 0; l1 < 10; ++l1) {
            int j3 = i + this.hellRNG.nextInt(16) + 8;
            int l4 = this.hellRNG.nextInt(128);
            int i6 = j + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone2().generate(this.worldObj, this.hellRNG, j3, l4, i6);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int i2 = i + this.hellRNG.nextInt(16) + 8;
            int k3 = this.hellRNG.nextInt(128);
            int i5 = j + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.hellRNG, i2, k3, i5);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int j2 = i + this.hellRNG.nextInt(16) + 8;
            int l3 = this.hellRNG.nextInt(128);
            int j5 = j + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.hellRNG, j2, l3, j5);
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "HellRandomLevelSource";
    }

    @Override
    public List getPossibleCreatures(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        if (par1EnumCreatureType == EnumCreatureType.monster && this.genNetherBridge.func_40483_a(par2, par3, par4)) {
            return this.genNetherBridge.getSpawnList();
        }
        BiomeGenBase biomegenbase = this.worldObj.getBiomeGenForCoords(par2, par4);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.getSpawnableList(par1EnumCreatureType);
    }

    @Override
    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int i, int j) {
        return null;
    }
}

