/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCaves;
import net.minecraft.src.MapGenMineshaft;
import net.minecraft.src.MapGenRavine;
import net.minecraft.src.MapGenStronghold;
import net.minecraft.src.MapGenVillage;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.SpawnerAnimals;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenDungeons;
import net.minecraft.src.WorldGenLakes;

public class ChunkProviderGenerate
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private double[] noiseArray;
    private double[] stoneNoise = new double[256];
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage(0);
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] field_35388_l;
    int[][] field_914_i = new int[32][32];

    public ChunkProviderGenerate(World par1World, long par2, boolean par4) {
        this.worldObj = par1World;
        this.mapFeaturesEnabled = par4;
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(int par1, int par2, byte[] par3ArrayOfByte) {
        int byte0 = 4;
        int byte1 = 16;
        int byte2 = 63;
        int i = byte0 + 1;
        int byte3 = 17;
        int j = byte0 + 1;
        this.biomesForGeneration = this.worldObj.getWorldChunkManager().getBiomesForGeneration(this.biomesForGeneration, par1 * 4 - 2, par2 * 4 - 2, i + 5, j + 5);
        this.noiseArray = this.initializeNoiseField(this.noiseArray, par1 * byte0, 0, par2 * byte0, i, byte3, j);
        for (int k = 0; k < byte0; ++k) {
            for (int l = 0; l < byte0; ++l) {
                for (int i1 = 0; i1 < byte1; ++i1) {
                    double d = 0.125;
                    double d1 = this.noiseArray[((k + 0) * j + (l + 0)) * byte3 + (i1 + 0)];
                    double d2 = this.noiseArray[((k + 0) * j + (l + 1)) * byte3 + (i1 + 0)];
                    double d3 = this.noiseArray[((k + 1) * j + (l + 0)) * byte3 + (i1 + 0)];
                    double d4 = this.noiseArray[((k + 1) * j + (l + 1)) * byte3 + (i1 + 0)];
                    double d5 = (this.noiseArray[((k + 0) * j + (l + 0)) * byte3 + (i1 + 1)] - d1) * d;
                    double d6 = (this.noiseArray[((k + 0) * j + (l + 1)) * byte3 + (i1 + 1)] - d2) * d;
                    double d7 = (this.noiseArray[((k + 1) * j + (l + 0)) * byte3 + (i1 + 1)] - d3) * d;
                    double d8 = (this.noiseArray[((k + 1) * j + (l + 1)) * byte3 + (i1 + 1)] - d4) * d;
                    for (int j1 = 0; j1 < 8; ++j1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k1 = 0; k1 < 4; ++k1) {
                            int l1 = k1 + k * 4 << 11 | 0 + l * 4 << 7 | i1 * 8 + j1;
                            int c = 128;
                            l1 -= c;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            d15 -= d16;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                double d17;
                                d15 += d16;
                                par3ArrayOfByte[l1 += c] = d17 > 0.0 ? (byte)Block.stone.blockID : (i1 * 8 + j1 < byte2 ? (byte)Block.waterStill.blockID : (byte)0);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, byte[] par3ArrayOfByte, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int byte0 = 63;
        double d = 0.03125;
        this.stoneNoise = this.noiseGen4.generateNoiseOctaves(this.stoneNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BiomeGenBase biomegenbase = par4ArrayOfBiomeGenBase[j + i * 16];
                float f = biomegenbase.getFloatTemperature();
                int k = (int)(this.stoneNoise[i + j * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int l = -1;
                byte byte1 = biomegenbase.topBlock;
                byte byte2 = biomegenbase.fillerBlock;
                for (int i1 = 127; i1 >= 0; --i1) {
                    int j1 = (j * 16 + i) * 128 + i1;
                    if (i1 <= 0 + this.rand.nextInt(5)) {
                        par3ArrayOfByte[j1] = (byte)Block.bedrock.blockID;
                        continue;
                    }
                    byte byte3 = par3ArrayOfByte[j1];
                    if (byte3 == 0) {
                        l = -1;
                        continue;
                    }
                    if (byte3 != Block.stone.blockID) continue;
                    if (l == -1) {
                        if (k <= 0) {
                            byte1 = 0;
                            byte2 = (byte)Block.stone.blockID;
                        } else if (i1 >= byte0 - 4 && i1 <= byte0 + 1) {
                            byte1 = biomegenbase.topBlock;
                            byte2 = biomegenbase.fillerBlock;
                        }
                        if (i1 < byte0 && byte1 == 0) {
                            byte1 = f < 0.15f ? (byte)Block.ice.blockID : (byte)Block.waterStill.blockID;
                        }
                        l = k;
                        if (i1 >= byte0 - 1) {
                            par3ArrayOfByte[j1] = byte1;
                            continue;
                        }
                        par3ArrayOfByte[j1] = byte2;
                        continue;
                    }
                    if (l <= 0) continue;
                    par3ArrayOfByte[j1] = byte2;
                    if (--l != 0 || byte2 != Block.sand.blockID) continue;
                    l = this.rand.nextInt(4);
                    byte2 = (byte)Block.sandStone.blockID;
                }
            }
        }
    }

    @Override
    public Chunk loadChunk(int par1, int par2) {
        return this.provideChunk(par1, par2);
    }

    @Override
    public Chunk provideChunk(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        byte[] abyte0 = new byte[32768];
        this.generateTerrain(par1, par2, abyte0);
        this.biomesForGeneration = this.worldObj.getWorldChunkManager().loadBlockGeneratorData(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.replaceBlocksForBiome(par1, par2, abyte0, this.biomesForGeneration);
        this.caveGenerator.generate(this, this.worldObj, par1, par2, abyte0);
        this.ravineGenerator.generate(this, this.worldObj, par1, par2, abyte0);
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.generate(this, this.worldObj, par1, par2, abyte0);
            this.villageGenerator.generate(this, this.worldObj, par1, par2, abyte0);
            this.strongholdGenerator.generate(this, this.worldObj, par1, par2, abyte0);
        }
        Chunk chunk = new Chunk(this.worldObj, abyte0, par1, par2);
        byte[] abyte1 = chunk.getBiomeArray();
        for (int i = 0; i < abyte1.length; ++i) {
            abyte1[i] = (byte)this.biomesForGeneration[i].biomeID;
        }
        chunk.generateSkylightMap();
        return chunk;
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        if (this.field_35388_l == null) {
            this.field_35388_l = new float[25];
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    float f;
                    this.field_35388_l[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.sqrt_float((float)(i * i + j * j) + 0.2f);
                }
            }
        }
        double d = 684.412;
        double d1 = 684.412;
        this.noise5 = this.noiseGen5.generateNoiseOctaves(this.noise5, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.generateNoiseOctaves(this.noise6, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.generateNoiseOctaves(this.noise3, par2, par3, par4, par5, par6, par7, d / 80.0, d1 / 160.0, d / 80.0);
        this.noise1 = this.noiseGen1.generateNoiseOctaves(this.noise1, par2, par3, par4, par5, par6, par7, d, d1, d);
        this.noise2 = this.noiseGen2.generateNoiseOctaves(this.noise2, par2, par3, par4, par5, par6, par7, d, d1, d);
        par4 = 0;
        par2 = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < par5; ++i1) {
            for (int j1 = 0; j1 < par7; ++j1) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int byte0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[i1 + 2 + (j1 + 2) * (par5 + 5)];
                for (int k1 = -byte0; k1 <= byte0; ++k1) {
                    for (int l1 = -byte0; l1 <= byte0; ++l1) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[i1 + k1 + 2 + (j1 + l1 + 2) * (par5 + 5)];
                        float f4 = this.field_35388_l[k1 + 2 + (l1 + 2) * 5] / (biomegenbase1.minHeight + 2.0f);
                        if (biomegenbase1.minHeight > biomegenbase.minHeight) {
                            f4 /= 2.0f;
                        }
                        f1 += biomegenbase1.maxHeight * f4;
                        f2 += biomegenbase1.minHeight * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = this.noise6[l] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++l;
                for (int i2 = 0; i2 < par6; ++i2) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)par6 / 16.0;
                    double d5 = (double)par6 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)i2 - d5) * 12.0 * 128.0 / 128.0 / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noise1[k] / 512.0;
                    double d9 = this.noise2[k] / 512.0;
                    double d10 = (this.noise3[k] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (i2 > par6 - 4) {
                        double d11 = (float)(i2 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1ArrayOfDouble[k] = d6;
                    ++k;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    @Override
    public boolean chunkExists(int par1, int par2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockSand.fallInstantly = true;
        int i = par2 * 16;
        int j = par3 * 16;
        BiomeGenBase biomegenbase = this.worldObj.getBiomeGenForCoords(i + 16, j + 16);
        this.rand.setSeed(this.worldObj.getSeed());
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * l + (long)par3 * l1 ^ this.worldObj.getSeed());
        boolean flag = false;
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.generateStructuresInChunk(this.worldObj, this.rand, par2, par3);
            flag = this.villageGenerator.generateStructuresInChunk(this.worldObj, this.rand, par2, par3);
            this.strongholdGenerator.generateStructuresInChunk(this.worldObj, this.rand, par2, par3);
        }
        if (!flag && this.rand.nextInt(4) == 0) {
            int k = i + this.rand.nextInt(16) + 8;
            int i2 = this.rand.nextInt(128);
            int i3 = j + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Block.waterStill.blockID).generate(this.worldObj, this.rand, k, i2, i3);
        }
        if (!flag && this.rand.nextInt(8) == 0) {
            int i1 = i + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            int j3 = j + this.rand.nextInt(16) + 8;
            if (j2 < 63 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Block.lavaStill.blockID).generate(this.worldObj, this.rand, i1, j2, j3);
            }
        }
        for (int j1 = 0; j1 < 8; ++j1) {
            int i4;
            int k3;
            int k2 = i + this.rand.nextInt(16) + 8;
            if (new WorldGenDungeons().generate(this.worldObj, this.rand, k2, k3 = this.rand.nextInt(128), i4 = j + this.rand.nextInt(16) + 8)) continue;
        }
        biomegenbase.decorate(this.worldObj, this.rand, i, j);
        SpawnerAnimals.performWorldGenSpawning(this.worldObj, biomegenbase, i + 8, j + 8, 16, 16, this.rand);
        i += 8;
        j += 8;
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                int l3 = this.worldObj.getPrecipitationHeight(i + k1, j + l2);
                if (this.worldObj.isBlockFreezable(k1 + i, l3 - 1, l2 + j)) {
                    this.worldObj.setBlockWithNotify(k1 + i, l3 - 1, l2 + j, Block.ice.blockID);
                }
                if (!this.worldObj.canSnowAt(k1 + i, l3, l2 + j)) continue;
                this.worldObj.setBlockWithNotify(k1 + i, l3, l2 + j, Block.snow.blockID);
            }
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }

    @Override
    public List getPossibleCreatures(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.getBiomeGenForCoords(par2, par4);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.getSpawnableList(par1EnumCreatureType);
    }

    @Override
    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int par4, int par5) {
        if ("Stronghold".equals(par2Str) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.getNearestInstance(par1World, par3, par4, par5);
        }
        return null;
    }
}

