/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;

public class ChunkProviderEnd
implements IChunkProvider {
    private Random endRNG;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    public NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    private World endWorld;
    private double[] densities;
    private BiomeGenBase[] biomesForGeneration;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    int[][] field_40395_h = new int[32][32];

    public ChunkProviderEnd(World par1World, long par2) {
        this.endWorld = par1World;
        this.endRNG = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.endRNG, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.endRNG, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.endRNG, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.endRNG, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.endRNG, 16);
    }

    public void func_40380_a(int par1, int par2, byte[] par3ArrayOfByte, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int byte0 = 2;
        int i = byte0 + 1;
        int byte1 = 33;
        int j = byte0 + 1;
        this.densities = this.func_40379_a(this.densities, par1 * byte0, 0, par2 * byte0, i, byte1, j);
        for (int k = 0; k < byte0; ++k) {
            for (int l = 0; l < byte0; ++l) {
                for (int i1 = 0; i1 < 32; ++i1) {
                    double d = 0.25;
                    double d1 = this.densities[((k + 0) * j + (l + 0)) * byte1 + (i1 + 0)];
                    double d2 = this.densities[((k + 0) * j + (l + 1)) * byte1 + (i1 + 0)];
                    double d3 = this.densities[((k + 1) * j + (l + 0)) * byte1 + (i1 + 0)];
                    double d4 = this.densities[((k + 1) * j + (l + 1)) * byte1 + (i1 + 0)];
                    double d5 = (this.densities[((k + 0) * j + (l + 0)) * byte1 + (i1 + 1)] - d1) * d;
                    double d6 = (this.densities[((k + 0) * j + (l + 1)) * byte1 + (i1 + 1)] - d2) * d;
                    double d7 = (this.densities[((k + 1) * j + (l + 0)) * byte1 + (i1 + 1)] - d3) * d;
                    double d8 = (this.densities[((k + 1) * j + (l + 1)) * byte1 + (i1 + 1)] - d4) * d;
                    for (int j1 = 0; j1 < 4; ++j1) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k1 = 0; k1 < 8; ++k1) {
                            int l1 = k1 + k * 8 << 11 | 0 + l * 8 << 7 | i1 * 4 + j1;
                            int c = 128;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int i2 = 0; i2 < 8; ++i2) {
                                int j2 = 0;
                                if (d15 > 0.0) {
                                    j2 = Block.whiteStone.blockID;
                                }
                                par3ArrayOfByte[l1] = (byte)j2;
                                l1 += c;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_40381_b(int par1, int par2, byte[] par3ArrayOfByte, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int k = 1;
                int l = -1;
                byte byte0 = (byte)Block.whiteStone.blockID;
                byte byte1 = (byte)Block.whiteStone.blockID;
                for (int i1 = 127; i1 >= 0; --i1) {
                    int j1 = (j * 16 + i) * 128 + i1;
                    byte byte2 = par3ArrayOfByte[j1];
                    if (byte2 == 0) {
                        l = -1;
                        continue;
                    }
                    if (byte2 != Block.stone.blockID) continue;
                    if (l == -1) {
                        if (k <= 0) {
                            byte0 = 0;
                            byte1 = (byte)Block.whiteStone.blockID;
                        }
                        l = k;
                        if (i1 >= 0) {
                            par3ArrayOfByte[j1] = byte0;
                            continue;
                        }
                        par3ArrayOfByte[j1] = byte1;
                        continue;
                    }
                    if (l <= 0) continue;
                    --l;
                    par3ArrayOfByte[j1] = byte1;
                }
            }
        }
    }

    @Override
    public Chunk loadChunk(int par1, int par2) {
        return this.provideChunk(par1, par2);
    }

    @Override
    public Chunk provideChunk(int par1, int par2) {
        this.endRNG.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        byte[] abyte0 = new byte[32768];
        this.biomesForGeneration = this.endWorld.getWorldChunkManager().loadBlockGeneratorData(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.func_40380_a(par1, par2, abyte0, this.biomesForGeneration);
        this.func_40381_b(par1, par2, abyte0, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.endWorld, abyte0, par1, par2);
        byte[] abyte1 = chunk.getBiomeArray();
        for (int i = 0; i < abyte1.length; ++i) {
            abyte1[i] = (byte)this.biomesForGeneration[i].biomeID;
        }
        chunk.generateSkylightMap();
        return chunk;
    }

    private double[] func_40379_a(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        double d = 684.412;
        double d1 = 684.412;
        this.noiseData4 = this.noiseGen4.generateNoiseOctaves(this.noiseData4, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        this.noiseData5 = this.noiseGen5.generateNoiseOctaves(this.noiseData5, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.generateNoiseOctaves(this.noiseData1, par2, par3, par4, par5, par6, par7, (d *= 2.0) / 80.0, d1 / 160.0, d / 80.0);
        this.noiseData2 = this.noiseGen1.generateNoiseOctaves(this.noiseData2, par2, par3, par4, par5, par6, par7, d, d1, d);
        this.noiseData3 = this.noiseGen2.generateNoiseOctaves(this.noiseData3, par2, par3, par4, par5, par6, par7, d, d1, d);
        int i = 0;
        int j = 0;
        for (int k = 0; k < par5; ++k) {
            for (int l = 0; l < par7; ++l) {
                double d3;
                double d2 = (this.noiseData4[j] + 256.0) / 512.0;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if ((d3 = this.noiseData5[j] / 8000.0) < 0.0) {
                    d3 = -d3 * 0.3;
                }
                d3 = d3 * 3.0 - 2.0;
                float f = (float)(k + par2 - 0) / 1.0f;
                float f1 = (float)(l + par4 - 0) / 1.0f;
                float f2 = 100.0f - MathHelper.sqrt_float(f * f + f1 * f1) * 8.0f;
                if (f2 > 80.0f) {
                    f2 = 80.0f;
                }
                if (f2 < -100.0f) {
                    f2 = -100.0f;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d3 /= 8.0;
                d3 = 0.0;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                d2 += 0.5;
                d3 = d3 * (double)par6 / 16.0;
                ++j;
                double d4 = (double)par6 / 2.0;
                for (int i1 = 0; i1 < par6; ++i1) {
                    double d5 = 0.0;
                    double d6 = ((double)i1 - d4) * 8.0 / d2;
                    if (d6 < 0.0) {
                        d6 *= -1.0;
                    }
                    double d7 = this.noiseData2[i] / 512.0;
                    double d8 = this.noiseData3[i] / 512.0;
                    double d9 = (this.noiseData1[i] / 10.0 + 1.0) / 2.0;
                    d5 = d9 < 0.0 ? d7 : (d9 > 1.0 ? d8 : d7 + (d8 - d7) * d9);
                    d5 -= 8.0;
                    d5 += (double)f2;
                    int j1 = 2;
                    if (i1 > par6 / 2 - j1) {
                        double d10 = (float)(i1 - (par6 / 2 - j1)) / 64.0f;
                        if (d10 < 0.0) {
                            d10 = 0.0;
                        }
                        if (d10 > 1.0) {
                            d10 = 1.0;
                        }
                        d5 = d5 * (1.0 - d10) + -3000.0 * d10;
                    }
                    if (i1 < (j1 = 8)) {
                        double d11 = (float)(j1 - i1) / ((float)j1 - 1.0f);
                        d5 = d5 * (1.0 - d11) + -30.0 * d11;
                    }
                    par1ArrayOfDouble[i] = d5;
                    ++i;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    @Override
    public boolean chunkExists(int par1, int par2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockSand.fallInstantly = true;
        int i = par2 * 16;
        int j = par3 * 16;
        BiomeGenBase biomegenbase = this.endWorld.getBiomeGenForCoords(i + 16, j + 16);
        biomegenbase.decorate(this.endWorld, this.endWorld.rand, i, j);
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }

    @Override
    public List getPossibleCreatures(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.endWorld.getBiomeGenForCoords(par2, par4);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.getSpawnableList(par1EnumCreatureType);
    }

    @Override
    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int i, int j) {
        return null;
    }
}

