/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.LongHashMap;
import net.minecraft.src.World;

public class ChunkProviderClient
implements IChunkProvider {
    private Chunk blankChunk;
    private LongHashMap chunkMapping = new LongHashMap();
    private List field_889_c = new ArrayList();
    private World worldObj;

    public ChunkProviderClient(World par1World) {
        this.blankChunk = new EmptyChunk(par1World, 0, 0);
        this.worldObj = par1World;
    }

    @Override
    public boolean chunkExists(int par1, int par2) {
        return true;
    }

    public void func_539_c(int par1, int par2) {
        Chunk chunk = this.provideChunk(par1, par2);
        if (!chunk.isEmpty()) {
            chunk.onChunkUnload();
        }
        this.chunkMapping.remove(ChunkCoordIntPair.chunkXZ2Int(par1, par2));
        this.field_889_c.remove(chunk);
    }

    @Override
    public Chunk loadChunk(int par1, int par2) {
        Chunk chunk = new Chunk(this.worldObj, par1, par2);
        this.chunkMapping.add(ChunkCoordIntPair.chunkXZ2Int(par1, par2), chunk);
        chunk.isChunkLoaded = true;
        return chunk;
    }

    @Override
    public Chunk provideChunk(int par1, int par2) {
        Chunk chunk = (Chunk)this.chunkMapping.getValueByKey(ChunkCoordIntPair.chunkXZ2Int(par1, par2));
        if (chunk == null) {
            return this.blankChunk;
        }
        return chunk;
    }

    @Override
    public boolean saveChunks(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i, int j) {
    }

    @Override
    public String makeString() {
        return "MultiplayerChunkCache: " + this.chunkMapping.getNumHashElements();
    }

    @Override
    public List getPossibleCreatures(EnumCreatureType par1EnumCreatureType, int par2, int par3, int i) {
        return null;
    }

    @Override
    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int i, int j) {
        return null;
    }
}

