/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.LongHashMap;
import net.minecraft.src.ModLoader;
import net.minecraft.src.World;

public class ChunkProvider
implements IChunkProvider {
    private Set droppedChunksSet = new HashSet();
    private Chunk emptyChunk;
    private IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private LongHashMap chunkMap = new LongHashMap();
    private List chunkList = new ArrayList();
    private World worldObj;
    private int field_35392_h;

    public ChunkProvider(World par1World, IChunkLoader par2IChunkLoader, IChunkProvider par3IChunkProvider) {
        this.emptyChunk = new EmptyChunk(par1World, 0, 0);
        this.worldObj = par1World;
        this.chunkLoader = par2IChunkLoader;
        this.chunkProvider = par3IChunkProvider;
    }

    @Override
    public boolean chunkExists(int par1, int par2) {
        return this.chunkMap.containsItem(ChunkCoordIntPair.chunkXZ2Int(par1, par2));
    }

    public void dropChunk(int par1, int par2) {
        ChunkCoordinates chunkcoordinates = this.worldObj.getSpawnPoint();
        int i = par1 * 16 + 8 - chunkcoordinates.posX;
        int j = par2 * 16 + 8 - chunkcoordinates.posZ;
        int c = 128;
        if (i < -c || i > c || j < -c || j > c) {
            this.droppedChunksSet.add(ChunkCoordIntPair.chunkXZ2Int(par1, par2));
        }
    }

    @Override
    public Chunk loadChunk(int par1, int par2) {
        long l = ChunkCoordIntPair.chunkXZ2Int(par1, par2);
        this.droppedChunksSet.remove(l);
        Chunk chunk = (Chunk)this.chunkMap.getValueByKey(l);
        if (chunk == null) {
            int i = 1875004;
            if (par1 < -i || par2 < -i || par1 >= i || par2 >= i) {
                return this.emptyChunk;
            }
            chunk = this.loadChunkFromFile(par1, par2);
            if (chunk == null) {
                chunk = this.chunkProvider == null ? this.emptyChunk : this.chunkProvider.provideChunk(par1, par2);
            }
            this.chunkMap.add(l, chunk);
            this.chunkList.add(chunk);
            if (chunk != null) {
                chunk.func_4143_d();
                chunk.onChunkLoad();
            }
            chunk.populateChunk(this, this, par1, par2);
        }
        return chunk;
    }

    @Override
    public Chunk provideChunk(int par1, int par2) {
        Chunk chunk = (Chunk)this.chunkMap.getValueByKey(ChunkCoordIntPair.chunkXZ2Int(par1, par2));
        return chunk != null ? chunk : this.loadChunk(par1, par2);
    }

    private Chunk loadChunkFromFile(int par1, int par2) {
        if (this.chunkLoader == null) {
            return null;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, par1, par2);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void saveChunkExtraData(Chunk par1Chunk) {
        if (this.chunkLoader != null) {
            try {
                this.chunkLoader.saveExtraChunkData(this.worldObj, par1Chunk);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void saveChunkData(Chunk par1Chunk) {
        if (this.chunkLoader != null) {
            try {
                par1Chunk.lastSaveTime = this.worldObj.getWorldTime();
                this.chunkLoader.saveChunk(this.worldObj, par1Chunk);
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    @Override
    public void populate(IChunkProvider par1IChunkProvider, int par2, int par3) {
        Chunk chunk = this.provideChunk(par2, par3);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(par1IChunkProvider, par2, par3);
                ModLoader.populateChunk(this.chunkProvider, par2, par3, this.worldObj);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean par1, IProgressUpdate par2IProgressUpdate) {
        int i = 0;
        for (int j = 0; j < this.chunkList.size(); ++j) {
            Chunk chunk = (Chunk)this.chunkList.get(j);
            if (par1) {
                this.saveChunkExtraData(chunk);
            }
            if (!chunk.needsSaving(par1)) continue;
            this.saveChunkData(chunk);
            chunk.isModified = false;
            if (++i != 24 || par1) continue;
            return false;
        }
        if (par1) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        for (int i = 0; i < 100; ++i) {
            if (this.droppedChunksSet.isEmpty()) continue;
            Long long1 = (Long)this.droppedChunksSet.iterator().next();
            Chunk chunk1 = (Chunk)this.chunkMap.getValueByKey(long1);
            chunk1.onChunkUnload();
            this.saveChunkData(chunk1);
            this.saveChunkExtraData(chunk1);
            this.droppedChunksSet.remove(long1);
            this.chunkMap.remove(long1);
            this.chunkList.remove(chunk1);
        }
        for (int j = 0; j < 10; ++j) {
            if (this.field_35392_h >= this.chunkList.size()) {
                this.field_35392_h = 0;
                break;
            }
            Chunk chunk = (Chunk)this.chunkList.get(this.field_35392_h++);
            EntityPlayer entityplayer = this.worldObj.func_48456_a((double)(chunk.xPosition << 4) + 8.0, (double)(chunk.zPosition << 4) + 8.0, 288.0);
            if (entityplayer != null) continue;
            this.dropChunk(chunk.xPosition, chunk.zPosition);
        }
        if (this.chunkLoader != null) {
            this.chunkLoader.chunkTick();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "ServerChunkCache: " + this.chunkMap.getNumHashElements() + " Drop: " + this.droppedChunksSet.size();
    }

    @Override
    public List getPossibleCreatures(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        return this.chunkProvider.getPossibleCreatures(par1EnumCreatureType, par2, par3, par4);
    }

    @Override
    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int par4, int par5) {
        return this.chunkProvider.findClosestStructure(par1World, par2Str, par3, par4, par5);
    }
}

