/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.EnumSkyBlock;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class ChunkCache
implements IBlockAccess {
    private int chunkX;
    private int chunkZ;
    private Chunk[][] chunkArray;
    private boolean field_48467_d;
    private World worldObj;

    public ChunkCache(World par1World, int par2, int par3, int par4, int par5, int par6, int par7) {
        this.worldObj = par1World;
        this.chunkX = par2 >> 4;
        this.chunkZ = par4 >> 4;
        int i = par5 >> 4;
        int j = par7 >> 4;
        this.chunkArray = new Chunk[i - this.chunkX + 1][j - this.chunkZ + 1];
        this.field_48467_d = true;
        for (int k = this.chunkX; k <= i; ++k) {
            for (int l = this.chunkZ; l <= j; ++l) {
                Chunk chunk = par1World.getChunkFromChunkCoords(k, l);
                if (chunk == null) continue;
                this.chunkArray[k - this.chunkX][l - this.chunkZ] = chunk;
                if (chunk.getAreLevelsEmpty(par3, par6)) continue;
                this.field_48467_d = false;
            }
        }
    }

    @Override
    public boolean func_48452_a() {
        return this.field_48467_d;
    }

    @Override
    public int getBlockId(int par1, int par2, int par3) {
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            return 0;
        }
        int i = (par1 >> 4) - this.chunkX;
        int j = (par3 >> 4) - this.chunkZ;
        if (i < 0 || i >= this.chunkArray.length || j < 0 || j >= this.chunkArray[i].length) {
            return 0;
        }
        Chunk chunk = this.chunkArray[i][j];
        if (chunk == null) {
            return 0;
        }
        return chunk.getBlockID(par1 & 0xF, par2, par3 & 0xF);
    }

    @Override
    public TileEntity getBlockTileEntity(int par1, int par2, int par3) {
        int i = (par1 >> 4) - this.chunkX;
        int j = (par3 >> 4) - this.chunkZ;
        return this.chunkArray[i][j].getChunkBlockTileEntity(par1 & 0xF, par2, par3 & 0xF);
    }

    @Override
    public float getBrightness(int par1, int par2, int par3, int par4) {
        int i = this.getLightValue(par1, par2, par3);
        if (i < par4) {
            i = par4;
        }
        return this.worldObj.worldProvider.lightBrightnessTable[i];
    }

    @Override
    public int getLightBrightnessForSkyBlocks(int par1, int par2, int par3, int par4) {
        int i = this.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, par1, par2, par3);
        int j = this.getSkyBlockTypeBrightness(EnumSkyBlock.Block, par1, par2, par3);
        if (j < par4) {
            j = par4;
        }
        return i << 20 | j << 4;
    }

    @Override
    public float getLightBrightness(int par1, int par2, int par3) {
        return this.worldObj.worldProvider.lightBrightnessTable[this.getLightValue(par1, par2, par3)];
    }

    public int getLightValue(int par1, int par2, int par3) {
        return this.getLightValueExt(par1, par2, par3, true);
    }

    public int getLightValueExt(int par1, int par2, int par3, boolean par4) {
        int i;
        if (par1 < -30000000 || par3 < -30000000 || par1 >= 30000000 || par3 > 30000000) {
            return 15;
        }
        if (par4 && ((i = this.getBlockId(par1, par2, par3)) == Block.stairSingle.blockID || i == Block.tilledField.blockID || i == Block.stairCompactPlanks.blockID || i == Block.stairCompactCobblestone.blockID)) {
            int l = this.getLightValueExt(par1, par2 + 1, par3, false);
            int j1 = this.getLightValueExt(par1 + 1, par2, par3, false);
            int k1 = this.getLightValueExt(par1 - 1, par2, par3, false);
            int l1 = this.getLightValueExt(par1, par2, par3 + 1, false);
            int i2 = this.getLightValueExt(par1, par2, par3 - 1, false);
            if (j1 > l) {
                l = j1;
            }
            if (k1 > l) {
                l = k1;
            }
            if (l1 > l) {
                l = l1;
            }
            if (i2 > l) {
                l = i2;
            }
            return l;
        }
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            int j = 15 - this.worldObj.skylightSubtracted;
            if (j < 0) {
                j = 0;
            }
            return j;
        }
        int k = (par1 >> 4) - this.chunkX;
        int i1 = (par3 >> 4) - this.chunkZ;
        return this.chunkArray[k][i1].getBlockLightValue(par1 & 0xF, par2, par3 & 0xF, this.worldObj.skylightSubtracted);
    }

    @Override
    public int getBlockMetadata(int par1, int par2, int par3) {
        if (par2 < 0) {
            return 0;
        }
        if (par2 >= 256) {
            return 0;
        }
        int i = (par1 >> 4) - this.chunkX;
        int j = (par3 >> 4) - this.chunkZ;
        return this.chunkArray[i][j].getBlockMetadata(par1 & 0xF, par2, par3 & 0xF);
    }

    @Override
    public Material getBlockMaterial(int par1, int par2, int par3) {
        int i = this.getBlockId(par1, par2, par3);
        if (i == 0) {
            return Material.air;
        }
        return Block.blocksList[i].blockMaterial;
    }

    @Override
    public BiomeGenBase getBiomeGenForCoords(int par1, int par2) {
        return this.worldObj.getBiomeGenForCoords(par1, par2);
    }

    @Override
    public boolean isBlockOpaqueCube(int par1, int par2, int par3) {
        Block block = Block.blocksList[this.getBlockId(par1, par2, par3)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    @Override
    public boolean isBlockNormalCube(int par1, int par2, int par3) {
        Block block = Block.blocksList[this.getBlockId(par1, par2, par3)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.blocksMovement() && block.renderAsNormalBlock();
    }

    @Override
    public boolean isAirBlock(int par1, int par2, int par3) {
        Block block = Block.blocksList[this.getBlockId(par1, par2, par3)];
        return block == null;
    }

    public int getSkyBlockTypeBrightness(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            par3 = 255;
        }
        if (par3 < 0 || par3 >= 256 || par2 < -30000000 || par4 < -30000000 || par2 >= 30000000 || par4 > 30000000) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        if (Block.useNeighborBrightness[this.getBlockId(par2, par3, par4)]) {
            int i = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2, par3 + 1, par4);
            int k = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2 + 1, par3, par4);
            int i1 = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2 - 1, par3, par4);
            int j1 = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2, par3, par4 + 1);
            int k1 = this.getSpecialBlockBrightness(par1EnumSkyBlock, par2, par3, par4 - 1);
            if (k > i) {
                i = k;
            }
            if (i1 > i) {
                i = i1;
            }
            if (j1 > i) {
                i = j1;
            }
            if (k1 > i) {
                i = k1;
            }
            return i;
        }
        int j = (par2 >> 4) - this.chunkX;
        int l = (par4 >> 4) - this.chunkZ;
        return this.chunkArray[j][l].getSavedLightValue(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
    }

    public int getSpecialBlockBrightness(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            par3 = 255;
        }
        if (par3 < 0 || par3 >= 256 || par2 < -30000000 || par4 < -30000000 || par2 >= 30000000 || par4 > 30000000) {
            return par1EnumSkyBlock.defaultLightValue;
        }
        int i = (par2 >> 4) - this.chunkX;
        int j = (par4 >> 4) - this.chunkZ;
        return this.chunkArray[i][j].getSavedLightValue(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
    }

    @Override
    public int getHeight() {
        return 256;
    }
}

