/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.Direction;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockVine
extends Block {
    public BlockVine(int par1) {
        super(par1, 143, Material.vine);
        this.setTickRandomly(true);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public int getRenderType() {
        return 20;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        boolean flag;
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = flag = i > 0;
        if ((i & 2) != 0) {
            f3 = Math.max(f3, 0.0625f);
            f = 0.0f;
            f1 = 0.0f;
            f4 = 1.0f;
            f2 = 0.0f;
            f5 = 1.0f;
            flag = true;
        }
        if ((i & 8) != 0) {
            f = Math.min(f, 0.9375f);
            f3 = 1.0f;
            f1 = 0.0f;
            f4 = 1.0f;
            f2 = 0.0f;
            f5 = 1.0f;
            flag = true;
        }
        if ((i & 4) != 0) {
            f5 = Math.max(f5, 0.0625f);
            f2 = 0.0f;
            f = 0.0f;
            f3 = 1.0f;
            f1 = 0.0f;
            f4 = 1.0f;
            flag = true;
        }
        if ((i & 1) != 0) {
            f2 = Math.min(f2, 0.9375f);
            f5 = 1.0f;
            f = 0.0f;
            f3 = 1.0f;
            f1 = 0.0f;
            f4 = 1.0f;
            flag = true;
        }
        if (!flag && this.canBePlacedOn(par1IBlockAccess.getBlockId(par2, par3 + 1, par4))) {
            f1 = Math.min(f1, 0.9375f);
            f4 = 1.0f;
            f = 0.0f;
            f3 = 1.0f;
            f2 = 0.0f;
            f5 = 1.0f;
        }
        this.setBlockBounds(f, f1, f2, f3, f4, f5);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int par4, int par5) {
        switch (par5) {
            default: {
                return false;
            }
            case 1: {
                return this.canBePlacedOn(par1World.getBlockId(par2, par3 + 1, par4));
            }
            case 2: {
                return this.canBePlacedOn(par1World.getBlockId(par2, par3, par4 + 1));
            }
            case 3: {
                return this.canBePlacedOn(par1World.getBlockId(par2, par3, par4 - 1));
            }
            case 5: {
                return this.canBePlacedOn(par1World.getBlockId(par2 - 1, par3, par4));
            }
            case 4: 
        }
        return this.canBePlacedOn(par1World.getBlockId(par2 + 1, par3, par4));
    }

    private boolean canBePlacedOn(int par1) {
        if (par1 == 0) {
            return false;
        }
        Block block = Block.blocksList[par1];
        return block.renderAsNormalBlock() && block.blockMaterial.blocksMovement();
    }

    private boolean canVineStay(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = i;
        if (j > 0) {
            for (int k = 0; k <= 3; ++k) {
                int l = 1 << k;
                if ((i & l) == 0 || this.canBePlacedOn(par1World.getBlockId(par2 + Direction.offsetX[k], par3, par4 + Direction.offsetZ[k])) || par1World.getBlockId(par2, par3 + 1, par4) == this.blockID && (par1World.getBlockMetadata(par2, par3 + 1, par4) & l) != 0) continue;
                j &= ~l;
            }
        }
        if (j == 0 && !this.canBePlacedOn(par1World.getBlockId(par2, par3 + 1, par4))) {
            return false;
        }
        if (j != i) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, j);
        }
        return true;
    }

    @Override
    public int getBlockColor() {
        return ColorizerFoliage.getFoliageColorBasic();
    }

    @Override
    public int getRenderColor(int par1) {
        return ColorizerFoliage.getFoliageColorBasic();
    }

    @Override
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.getBiomeGenForCoords(par2, par4).getBiomeFoliageColor();
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (!par1World.isRemote && !this.canVineStay(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.isRemote && par1World.rand.nextInt(4) == 0) {
            int j;
            int byte0 = 4;
            int i = 5;
            boolean flag = false;
            block0: for (j = par2 - byte0; j <= par2 + byte0; ++j) {
                for (int k = par4 - byte0; k <= par4 + byte0; ++k) {
                    for (int i1 = par3 - 1; i1 <= par3 + 1; ++i1) {
                        if (par1World.getBlockId(j, i1, k) != this.blockID || --i > 0) continue;
                        flag = true;
                        break block0;
                    }
                }
            }
            j = par1World.getBlockMetadata(par2, par3, par4);
            int l = par1World.rand.nextInt(6);
            int j1 = Direction.vineGrowth[l];
            if (l == 1 && par3 < 255 && par1World.isAirBlock(par2, par3 + 1, par4)) {
                if (flag) {
                    return;
                }
                int k1 = par1World.rand.nextInt(16) & j;
                if (k1 > 0) {
                    for (int j2 = 0; j2 <= 3; ++j2) {
                        if (this.canBePlacedOn(par1World.getBlockId(par2 + Direction.offsetX[j2], par3 + 1, par4 + Direction.offsetZ[j2]))) continue;
                        k1 &= ~(1 << j2);
                    }
                    if (k1 > 0) {
                        par1World.setBlockAndMetadataWithNotify(par2, par3 + 1, par4, this.blockID, k1);
                    }
                }
            } else if (l >= 2 && l <= 5 && (j & 1 << j1) == 0) {
                if (flag) {
                    return;
                }
                int l1 = par1World.getBlockId(par2 + Direction.offsetX[j1], par3, par4 + Direction.offsetZ[j1]);
                if (l1 == 0 || Block.blocksList[l1] == null) {
                    int k2 = j1 + 1 & 3;
                    int j3 = j1 + 3 & 3;
                    if ((j & 1 << k2) != 0 && this.canBePlacedOn(par1World.getBlockId(par2 + Direction.offsetX[j1] + Direction.offsetX[k2], par3, par4 + Direction.offsetZ[j1] + Direction.offsetZ[k2]))) {
                        par1World.setBlockAndMetadataWithNotify(par2 + Direction.offsetX[j1], par3, par4 + Direction.offsetZ[j1], this.blockID, 1 << k2);
                    } else if ((j & 1 << j3) != 0 && this.canBePlacedOn(par1World.getBlockId(par2 + Direction.offsetX[j1] + Direction.offsetX[j3], par3, par4 + Direction.offsetZ[j1] + Direction.offsetZ[j3]))) {
                        par1World.setBlockAndMetadataWithNotify(par2 + Direction.offsetX[j1], par3, par4 + Direction.offsetZ[j1], this.blockID, 1 << j3);
                    } else if ((j & 1 << k2) != 0 && par1World.isAirBlock(par2 + Direction.offsetX[j1] + Direction.offsetX[k2], par3, par4 + Direction.offsetZ[j1] + Direction.offsetZ[k2]) && this.canBePlacedOn(par1World.getBlockId(par2 + Direction.offsetX[k2], par3, par4 + Direction.offsetZ[k2]))) {
                        par1World.setBlockAndMetadataWithNotify(par2 + Direction.offsetX[j1] + Direction.offsetX[k2], par3, par4 + Direction.offsetZ[j1] + Direction.offsetZ[k2], this.blockID, 1 << (j1 + 2 & 3));
                    } else if ((j & 1 << j3) != 0 && par1World.isAirBlock(par2 + Direction.offsetX[j1] + Direction.offsetX[j3], par3, par4 + Direction.offsetZ[j1] + Direction.offsetZ[j3]) && this.canBePlacedOn(par1World.getBlockId(par2 + Direction.offsetX[j3], par3, par4 + Direction.offsetZ[j3]))) {
                        par1World.setBlockAndMetadataWithNotify(par2 + Direction.offsetX[j1] + Direction.offsetX[j3], par3, par4 + Direction.offsetZ[j1] + Direction.offsetZ[j3], this.blockID, 1 << (j1 + 2 & 3));
                    } else if (this.canBePlacedOn(par1World.getBlockId(par2 + Direction.offsetX[j1], par3 + 1, par4 + Direction.offsetZ[j1]))) {
                        par1World.setBlockAndMetadataWithNotify(par2 + Direction.offsetX[j1], par3, par4 + Direction.offsetZ[j1], this.blockID, 0);
                    }
                } else if (Block.blocksList[l1].blockMaterial.isOpaque() && Block.blocksList[l1].renderAsNormalBlock()) {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4, j | 1 << j1);
                }
            } else if (par3 > 1) {
                int i2 = par1World.getBlockId(par2, par3 - 1, par4);
                if (i2 == 0) {
                    int l2 = par1World.rand.nextInt(16) & j;
                    if (l2 > 0) {
                        par1World.setBlockAndMetadataWithNotify(par2, par3 - 1, par4, this.blockID, l2);
                    }
                } else if (i2 == this.blockID) {
                    int i3 = par1World.rand.nextInt(16) & j;
                    int k3 = par1World.getBlockMetadata(par2, par3 - 1, par4);
                    if (k3 != (k3 | i3)) {
                        par1World.setBlockMetadataWithNotify(par2, par3 - 1, par4, k3 | i3);
                    }
                }
            }
        }
    }

    @Override
    public void onBlockPlaced(World par1World, int par2, int par3, int par4, int par5) {
        int byte0 = 0;
        switch (par5) {
            case 2: {
                byte0 = 1;
                break;
            }
            case 3: {
                byte0 = 4;
                break;
            }
            case 4: {
                byte0 = 8;
                break;
            }
            case 5: {
                byte0 = 2;
            }
        }
        if (byte0 != 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
        }
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return 0;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 0;
    }

    @Override
    public void harvestBlock(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        if (!par1World.isRemote && par2EntityPlayer.getCurrentEquippedItem() != null && par2EntityPlayer.getCurrentEquippedItem().itemID == Item.shears.shiftedIndex) {
            par2EntityPlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(par1World, par3, par4, par5, new ItemStack(Block.vine, 1, 0));
        } else {
            super.harvestBlock(par1World, par2EntityPlayer, par3, par4, par5, par6);
        }
    }
}

