/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class BlockTrapDoor
extends Block {
    protected BlockTrapDoor(int par1, Material par2Material) {
        super(par1, par2Material);
        this.blockIndexInTexture = 84;
        if (par2Material == Material.iron) {
            ++this.blockIndexInTexture;
        }
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return !BlockTrapDoor.isTrapdoorOpen(par1IBlockAccess.getBlockMetadata(par2, par3, par4));
    }

    @Override
    public int getRenderType() {
        return 0;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState(par1World, par2, par3, par4);
        return super.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState(par1World, par2, par3, par4);
        return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setBlockBoundsForBlockRender(par1IBlockAccess.getBlockMetadata(par2, par3, par4));
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f = 0.1875f;
        this.setBlockBounds(0.0f, 0.5f - f / 2.0f, 0.0f, 1.0f, 0.5f + f / 2.0f, 1.0f);
    }

    public void setBlockBoundsForBlockRender(int par1) {
        float f = 0.1875f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
        if (BlockTrapDoor.isTrapdoorOpen(par1)) {
            if ((par1 & 3) == 0) {
                this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
            }
            if ((par1 & 3) == 1) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
            }
            if ((par1 & 3) == 2) {
                this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            if ((par1 & 3) == 3) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void onBlockClicked(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.blockActivated(par1World, par2, par3, par4, par5EntityPlayer);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (this.blockMaterial == Material.iron) {
            return true;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i ^ 4);
        par1World.playAuxSFXAtEntity(par5EntityPlayer, 1003, par2, par3, par4, 0);
        return true;
    }

    public void onPoweredBlockChange(World par1World, int par2, int par3, int par4, boolean par5) {
        boolean flag;
        int i = par1World.getBlockMetadata(par2, par3, par4);
        boolean bl = flag = (i & 4) > 0;
        if (flag == par5) {
            return;
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i ^ 4);
        par1World.playAuxSFXAtEntity(null, 1003, par2, par3, par4, 0);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        boolean flag;
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = par2;
        int k = par4;
        if ((i & 3) == 0) {
            ++k;
        }
        if ((i & 3) == 1) {
            --k;
        }
        if ((i & 3) == 2) {
            ++j;
        }
        if ((i & 3) == 3) {
            --j;
        }
        if (!BlockTrapDoor.isValidSupportBlock(par1World.getBlockId(j, par3, k))) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            this.dropBlockAsItem(par1World, par2, par3, par4, i, 0);
        }
        if ((flag = par1World.isBlockIndirectlyGettingPowered(par2, par3, par4)) || par5 > 0 && Block.blocksList[par5].canProvidePower() || par5 == 0) {
            this.onPoweredBlockChange(par1World, par2, par3, par4, flag);
        }
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World par1World, int par2, int par3, int par4, Vec3D par5Vec3D, Vec3D par6Vec3D) {
        this.setBlockBoundsBasedOnState(par1World, par2, par3, par4);
        return super.collisionRayTrace(par1World, par2, par3, par4, par5Vec3D, par6Vec3D);
    }

    @Override
    public void onBlockPlaced(World par1World, int par2, int par3, int par4, int par5) {
        int byte0 = 0;
        if (par5 == 2) {
            byte0 = 0;
        }
        if (par5 == 3) {
            byte0 = 1;
        }
        if (par5 == 4) {
            byte0 = 2;
        }
        if (par5 == 5) {
            byte0 = 3;
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
    }

    @Override
    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 == 0) {
            return false;
        }
        if (par5 == 1) {
            return false;
        }
        if (par5 == 2) {
            ++par4;
        }
        if (par5 == 3) {
            --par4;
        }
        if (par5 == 4) {
            ++par2;
        }
        if (par5 == 5) {
            --par2;
        }
        return BlockTrapDoor.isValidSupportBlock(par1World.getBlockId(par2, par3, par4));
    }

    public static boolean isTrapdoorOpen(int par0) {
        return (par0 & 4) != 0;
    }

    private static boolean isValidSupportBlock(int par0) {
        if (par0 <= 0) {
            return false;
        }
        Block block = Block.blocksList[par0];
        return block != null && block.blockMaterial.isOpaque() && block.renderAsNormalBlock() || block == Block.glowStone;
    }
}

