/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockTallGrass
extends BlockFlower {
    protected BlockTallGrass(int par1, int par2) {
        super(par1, par2, Material.vine);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.8f, 0.5f + f);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par2 == 1) {
            return this.blockIndexInTexture;
        }
        if (par2 == 2) {
            return this.blockIndexInTexture + 16 + 1;
        }
        if (par2 == 0) {
            return this.blockIndexInTexture + 16;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public int getBlockColor() {
        double d = 0.5;
        double d1 = 1.0;
        return ColorizerGrass.getGrassColor(d, d1);
    }

    @Override
    public int getRenderColor(int par1) {
        if (par1 == 0) {
            return 0xFFFFFF;
        }
        return ColorizerFoliage.getFoliageColorBasic();
    }

    @Override
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if (i == 0) {
            return 0xFFFFFF;
        }
        return par1IBlockAccess.getBiomeGenForCoords(par2, par4).getBiomeGrassColor();
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        if (par2Random.nextInt(8) == 0) {
            return Item.seeds.shiftedIndex;
        }
        return -1;
    }

    @Override
    public int quantityDroppedWithBonus(int par1, Random par2Random) {
        return 1 + par2Random.nextInt(par1 * 2 + 1);
    }

    @Override
    public void harvestBlock(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        if (!par1World.isRemote && par2EntityPlayer.getCurrentEquippedItem() != null && par2EntityPlayer.getCurrentEquippedItem().itemID == Item.shears.shiftedIndex) {
            par2EntityPlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(par1World, par3, par4, par5, new ItemStack(Block.tallGrass, 1, par6));
        } else {
            super.harvestBlock(par1World, par2EntityPlayer, par3, par4, par5, par6);
        }
    }
}

