/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Facing;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockStep
extends Block {
    public static final String[] blockStepTypes = new String[]{"stone", "sand", "wood", "cobble", "brick", "smoothStoneBrick"};
    private boolean blockType;

    public BlockStep(int par1, boolean par2) {
        super(par1, 6, Material.rock);
        this.blockType = par2;
        if (!par2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else {
            BlockStep.opaqueCubeLookup[par1] = true;
        }
        this.setLightOpacity(255);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (this.blockType) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            boolean flag;
            boolean bl = flag = (par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 8) != 0;
            if (flag) {
                this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            }
        }
    }

    @Override
    public void setBlockBoundsForItemRender() {
        if (this.blockType) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
    }

    @Override
    public void getCollidingBoundingBoxes(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, ArrayList par6ArrayList) {
        this.setBlockBoundsBasedOnState(par1World, par2, par3, par4);
        super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        int i = par2 & 7;
        if (i == 0) {
            return par1 > 1 ? 5 : 6;
        }
        if (i == 1) {
            if (par1 == 0) {
                return 208;
            }
            return par1 != 1 ? 192 : 176;
        }
        if (i == 2) {
            return 4;
        }
        if (i == 3) {
            return 16;
        }
        if (i == 4) {
            return Block.brick.blockIndexInTexture;
        }
        if (i == 5) {
            return Block.stoneBrick.blockIndexInTexture;
        }
        return 6;
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        return this.getBlockTextureFromSideAndMetadata(par1, 0);
    }

    @Override
    public boolean isOpaqueCube() {
        return this.blockType;
    }

    @Override
    public void onBlockPlaced(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 == 0 && !this.blockType) {
            int i = par1World.getBlockMetadata(par2, par3, par4) & 7;
            par1World.setBlockMetadataWithNotify(par2, par3, par4, i | 8);
        }
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Block.stairSingle.blockID;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return !this.blockType ? 1 : 2;
    }

    @Override
    protected int damageDropped(int par1) {
        return par1 & 7;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return this.blockType;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        boolean flag;
        if (this.blockType) {
            super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5);
        }
        if (par5 != 1 && par5 != 0 && !super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5)) {
            return false;
        }
        int i = par2;
        int j = par3;
        int k = par4;
        boolean bl = flag = (par1IBlockAccess.getBlockMetadata(i += Facing.offsetsXForSide[Facing.faceToSide[par5]], j += Facing.offsetsYForSide[Facing.faceToSide[par5]], k += Facing.offsetsZForSide[Facing.faceToSide[par5]]) & 8) != 0;
        if (!flag) {
            if (par5 == 1) {
                return true;
            }
            if (par5 == 0 && super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5)) {
                return true;
            }
            return par1IBlockAccess.getBlockId(par2, par3, par4) != this.blockID || (par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 8) != 0;
        }
        if (par5 == 0) {
            return true;
        }
        if (par5 == 1 && super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5)) {
            return true;
        }
        return par1IBlockAccess.getBlockId(par2, par3, par4) != this.blockID || (par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 8) == 0;
    }

    @Override
    protected ItemStack createStackedBlock(int par1) {
        return new ItemStack(Block.stairSingle.blockID, 1, par1 & 7);
    }
}

