/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.EntityItem;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class BlockStem
extends BlockFlower {
    private Block fruitType;

    protected BlockStem(int par1, Block par2Block) {
        super(par1, 111);
        this.fruitType = par2Block;
        this.setTickRandomly(true);
        float f = 0.125f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int par1) {
        return par1 == Block.tilledField.blockID;
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        float f;
        super.updateTick(par1World, par2, par3, par4, par5Random);
        if (par1World.getBlockLightValue(par2, par3 + 1, par4) >= 9 && par5Random.nextInt((int)(25.0f / (f = this.getGrowthModifier(par1World, par2, par3, par4))) + 1) == 0) {
            int i = par1World.getBlockMetadata(par2, par3, par4);
            if (i < 7) {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, ++i);
            } else {
                if (par1World.getBlockId(par2 - 1, par3, par4) == this.fruitType.blockID) {
                    return;
                }
                if (par1World.getBlockId(par2 + 1, par3, par4) == this.fruitType.blockID) {
                    return;
                }
                if (par1World.getBlockId(par2, par3, par4 - 1) == this.fruitType.blockID) {
                    return;
                }
                if (par1World.getBlockId(par2, par3, par4 + 1) == this.fruitType.blockID) {
                    return;
                }
                int j = par5Random.nextInt(4);
                int k = par2;
                int l = par4;
                if (j == 0) {
                    --k;
                }
                if (j == 1) {
                    ++k;
                }
                if (j == 2) {
                    --l;
                }
                if (j == 3) {
                    ++l;
                }
                int i1 = par1World.getBlockId(k, par3 - 1, l);
                if (par1World.getBlockId(k, par3, l) == 0 && (i1 == Block.tilledField.blockID || i1 == Block.dirt.blockID || i1 == Block.grass.blockID)) {
                    par1World.setBlockWithNotify(k, par3, l, this.fruitType.blockID);
                }
            }
        }
    }

    public void fertilizeStem(World par1World, int par2, int par3, int par4) {
        par1World.setBlockMetadataWithNotify(par2, par3, par4, 7);
    }

    private float getGrowthModifier(World par1World, int par2, int par3, int par4) {
        float f = 1.0f;
        int i = par1World.getBlockId(par2, par3, par4 - 1);
        int j = par1World.getBlockId(par2, par3, par4 + 1);
        int k = par1World.getBlockId(par2 - 1, par3, par4);
        int l = par1World.getBlockId(par2 + 1, par3, par4);
        int i1 = par1World.getBlockId(par2 - 1, par3, par4 - 1);
        int j1 = par1World.getBlockId(par2 + 1, par3, par4 - 1);
        int k1 = par1World.getBlockId(par2 + 1, par3, par4 + 1);
        int l1 = par1World.getBlockId(par2 - 1, par3, par4 + 1);
        boolean flag = k == this.blockID || l == this.blockID;
        boolean flag1 = i == this.blockID || j == this.blockID;
        boolean flag2 = i1 == this.blockID || j1 == this.blockID || k1 == this.blockID || l1 == this.blockID;
        for (int i2 = par2 - 1; i2 <= par2 + 1; ++i2) {
            for (int j2 = par4 - 1; j2 <= par4 + 1; ++j2) {
                int k2 = par1World.getBlockId(i2, par3 - 1, j2);
                float f1 = 0.0f;
                if (k2 == Block.tilledField.blockID) {
                    f1 = 1.0f;
                    if (par1World.getBlockMetadata(i2, par3 - 1, j2) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i2 != par2 || j2 != par4) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    @Override
    public int getRenderColor(int par1) {
        int i = par1 * 32;
        int j = 255 - par1 * 8;
        int k = par1 * 4;
        return i << 16 | j << 8 | k;
    }

    @Override
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.getRenderColor(par1IBlockAccess.getBlockMetadata(par2, par3, par4));
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        return this.blockIndexInTexture;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f = 0.125f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.maxY = (float)(par1IBlockAccess.getBlockMetadata(par2, par3, par4) * 2 + 2) / 16.0f;
        float f = 0.125f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, (float)this.maxY, 0.5f + f);
    }

    @Override
    public int getRenderType() {
        return 19;
    }

    public int func_35296_f(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if (i < 7) {
            return -1;
        }
        if (par1IBlockAccess.getBlockId(par2 - 1, par3, par4) == this.fruitType.blockID) {
            return 0;
        }
        if (par1IBlockAccess.getBlockId(par2 + 1, par3, par4) == this.fruitType.blockID) {
            return 1;
        }
        if (par1IBlockAccess.getBlockId(par2, par3, par4 - 1) == this.fruitType.blockID) {
            return 2;
        }
        return par1IBlockAccess.getBlockId(par2, par3, par4 + 1) != this.fruitType.blockID ? -1 : 3;
    }

    @Override
    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        super.dropBlockAsItemWithChance(par1World, par2, par3, par4, par5, par6, par7);
        if (par1World.isRemote) {
            return;
        }
        Item item = null;
        if (this.fruitType == Block.pumpkin) {
            item = Item.pumpkinSeeds;
        }
        if (this.fruitType == Block.melon) {
            item = Item.melonSeeds;
        }
        for (int i = 0; i < 3; ++i) {
            if (par1World.rand.nextInt(15) > par5) continue;
            float f = 0.7f;
            float f1 = par1World.rand.nextFloat() * f + (1.0f - f) * 0.5f;
            float f2 = par1World.rand.nextFloat() * f + (1.0f - f) * 0.5f;
            float f3 = par1World.rand.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(par1World, (float)par2 + f1, (float)par3 + f2, (float)par4 + f3, new ItemStack(item));
            entityitem.delayBeforeCanPickup = 10;
            par1World.spawnEntityInWorld(entityitem);
        }
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        if (par1 != 7) {
            // empty if block
        }
        return -1;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 1;
    }
}

