/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class BlockStairs
extends Block {
    private Block modelBlock;

    protected BlockStairs(int par1, Block par2Block) {
        super(par1, par2Block.blockIndexInTexture, par2Block.blockMaterial);
        this.modelBlock = par2Block;
        this.setHardness(par2Block.blockHardness);
        this.setResistance(par2Block.blockResistance / 3.0f);
        this.setStepSound(par2Block.stepSound);
        this.setLightOpacity(255);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 10;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5);
    }

    @Override
    public void getCollidingBoundingBoxes(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, ArrayList par6ArrayList) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = i & 3;
        float f = 0.0f;
        float f1 = 0.5f;
        float f2 = 0.5f;
        float f3 = 1.0f;
        if ((i & 4) != 0) {
            f = 0.5f;
            f1 = 1.0f;
            f2 = 0.0f;
            f3 = 0.5f;
        }
        this.setBlockBounds(0.0f, f, 0.0f, 1.0f, f1, 1.0f);
        super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        if (j == 0) {
            this.setBlockBounds(0.5f, f2, 0.0f, 1.0f, f3, 1.0f);
            super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        } else if (j == 1) {
            this.setBlockBounds(0.0f, f2, 0.0f, 0.5f, f3, 1.0f);
            super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        } else if (j == 2) {
            this.setBlockBounds(0.0f, f2, 0.5f, 1.0f, f3, 1.0f);
            super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        } else if (j == 3) {
            this.setBlockBounds(0.0f, f2, 0.0f, 1.0f, f3, 0.5f);
            super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        this.modelBlock.randomDisplayTick(par1World, par2, par3, par4, par5Random);
    }

    @Override
    public void onBlockClicked(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.modelBlock.onBlockClicked(par1World, par2, par3, par4, par5EntityPlayer);
    }

    @Override
    public void onBlockDestroyedByPlayer(World par1World, int par2, int par3, int par4, int par5) {
        this.modelBlock.onBlockDestroyedByPlayer(par1World, par2, par3, par4, par5);
    }

    @Override
    public int getMixedBrightnessForBlock(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.modelBlock.getMixedBrightnessForBlock(par1IBlockAccess, par2, par3, par4);
    }

    @Override
    public float getBlockBrightness(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.modelBlock.getBlockBrightness(par1IBlockAccess, par2, par3, par4);
    }

    @Override
    public float getExplosionResistance(Entity par1Entity) {
        return this.modelBlock.getExplosionResistance(par1Entity);
    }

    @Override
    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(par1, 0);
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(par1, 0);
    }

    @Override
    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return this.modelBlock.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    @Override
    public void velocityToAddToEntity(World par1World, int par2, int par3, int par4, Entity par5Entity, Vec3D par6Vec3D) {
        this.modelBlock.velocityToAddToEntity(par1World, par2, par3, par4, par5Entity, par6Vec3D);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int par1, boolean par2) {
        return this.modelBlock.canCollideCheck(par1, par2);
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return this.modelBlock.canPlaceBlockAt(par1World, par2, par3, par4);
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        this.onNeighborBlockChange(par1World, par2, par3, par4, 0);
        this.modelBlock.onBlockAdded(par1World, par2, par3, par4);
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        this.modelBlock.onBlockRemoval(par1World, par2, par3, par4);
    }

    @Override
    public void onEntityWalking(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        this.modelBlock.onEntityWalking(par1World, par2, par3, par4, par5Entity);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        this.modelBlock.updateTick(par1World, par2, par3, par4, par5Random);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        return this.modelBlock.blockActivated(par1World, par2, par3, par4, par5EntityPlayer);
    }

    @Override
    public void onBlockDestroyedByExplosion(World par1World, int par2, int par3, int par4) {
        this.modelBlock.onBlockDestroyedByExplosion(par1World, par2, par3, par4);
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        int j = par1World.getBlockMetadata(par2, par3, par4) & 4;
        if (i == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2 | j);
        }
        if (i == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 1 | j);
        }
        if (i == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3 | j);
        }
        if (i == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 0 | j);
        }
    }

    @Override
    public void onBlockPlaced(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 == 0) {
            int i = par1World.getBlockMetadata(par2, par3, par4);
            par1World.setBlockMetadataWithNotify(par2, par3, par4, i | 4);
        }
    }
}

