/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class BlockSign
extends BlockContainer {
    private Class signEntityClass;
    private boolean isFreestanding;

    protected BlockSign(int par1, Class par2Class, boolean par3) {
        super(par1, Material.wood);
        this.isFreestanding = par3;
        this.blockIndexInTexture = 4;
        this.signEntityClass = par2Class;
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState(par1World, par2, par3, par4);
        return super.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (this.isFreestanding) {
            return;
        }
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        float f = 0.28125f;
        float f1 = 0.78125f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.125f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (i == 2) {
            this.setBlockBounds(f2, f, 1.0f - f4, f3, f1, 1.0f);
        }
        if (i == 3) {
            this.setBlockBounds(f2, f, 0.0f, f3, f1, f4);
        }
        if (i == 4) {
            this.setBlockBounds(1.0f - f4, f, f2, 1.0f, f1, f3);
        }
        if (i == 5) {
            this.setBlockBounds(0.0f, f, f2, f4, f1, f3);
        }
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int i) {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public TileEntity getBlockEntity() {
        try {
            return (TileEntity)this.signEntityClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Item.sign.shiftedIndex;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        boolean flag = false;
        if (this.isFreestanding) {
            if (!par1World.getBlockMaterial(par2, par3 - 1, par4).isSolid()) {
                flag = true;
            }
        } else {
            int i = par1World.getBlockMetadata(par2, par3, par4);
            flag = true;
            if (i == 2 && par1World.getBlockMaterial(par2, par3, par4 + 1).isSolid()) {
                flag = false;
            }
            if (i == 3 && par1World.getBlockMaterial(par2, par3, par4 - 1).isSolid()) {
                flag = false;
            }
            if (i == 4 && par1World.getBlockMaterial(par2 + 1, par3, par4).isSolid()) {
                flag = false;
            }
            if (i == 5 && par1World.getBlockMaterial(par2 - 1, par3, par4).isSolid()) {
                flag = false;
            }
        }
        if (flag) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
        super.onNeighborBlockChange(par1World, par2, par3, par4, par5);
    }
}

