/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockSand
extends Block {
    public static boolean fallInstantly = false;

    public BlockSand(int par1, int par2) {
        super(par1, par2, Material.sand);
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        this.tryToFall(par1World, par2, par3, par4);
    }

    private void tryToFall(World par1World, int par2, int par3, int par4) {
        int i = par2;
        int j = par3;
        int k = par4;
        if (BlockSand.canFallBelow(par1World, i, j - 1, k) && j >= 0) {
            int byte0 = 32;
            if (fallInstantly || !par1World.checkChunksExist(par2 - byte0, par3 - byte0, par4 - byte0, par2 + byte0, par3 + byte0, par4 + byte0)) {
                par1World.setBlockWithNotify(par2, par3, par4, 0);
                while (BlockSand.canFallBelow(par1World, par2, par3 - 1, par4) && par3 > 0) {
                    --par3;
                }
                if (par3 > 0) {
                    par1World.setBlockWithNotify(par2, par3, par4, this.blockID);
                }
            } else if (!par1World.isRemote) {
                EntityFallingSand entityfallingsand = new EntityFallingSand(par1World, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, this.blockID);
                par1World.spawnEntityInWorld(entityfallingsand);
            }
        }
    }

    @Override
    public int tickRate() {
        return 3;
    }

    public static boolean canFallBelow(World par0World, int par1, int par2, int par3) {
        int i = par0World.getBlockId(par1, par2, par3);
        if (i == 0) {
            return true;
        }
        if (i == Block.fire.blockID) {
            return true;
        }
        Material material = Block.blocksList[i].blockMaterial;
        if (material == Material.water) {
            return true;
        }
        return material == Material.lava;
    }
}

