/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockReed
extends Block {
    protected BlockReed(int par1, int par2) {
        super(par1, Material.plants);
        this.blockIndexInTexture = par2;
        float f = 0.375f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.setTickRandomly(true);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.isAirBlock(par2, par3 + 1, par4)) {
            int i = 1;
            while (par1World.getBlockId(par2, par3 - i, par4) == this.blockID) {
                ++i;
            }
            if (i < 3) {
                int j = par1World.getBlockMetadata(par2, par3, par4);
                if (j == 15) {
                    par1World.setBlockWithNotify(par2, par3 + 1, par4, this.blockID);
                    par1World.setBlockMetadataWithNotify(par2, par3, par4, 0);
                } else {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4, j + 1);
                }
            }
        }
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockId(par2, par3 - 1, par4);
        if (i == this.blockID) {
            return true;
        }
        if (i != Block.grass.blockID && i != Block.dirt.blockID && i != Block.sand.blockID) {
            return false;
        }
        if (par1World.getBlockMaterial(par2 - 1, par3 - 1, par4) == Material.water) {
            return true;
        }
        if (par1World.getBlockMaterial(par2 + 1, par3 - 1, par4) == Material.water) {
            return true;
        }
        if (par1World.getBlockMaterial(par2, par3 - 1, par4 - 1) == Material.water) {
            return true;
        }
        return par1World.getBlockMaterial(par2, par3 - 1, par4 + 1) == Material.water;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        this.checkBlockCoordValid(par1World, par2, par3, par4);
    }

    protected final void checkBlockCoordValid(World par1World, int par2, int par3, int par4) {
        if (!this.canBlockStay(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
    }

    @Override
    public boolean canBlockStay(World par1World, int par2, int par3, int par4) {
        return this.canPlaceBlockAt(par1World, par2, par3, par4);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Item.reed.shiftedIndex;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 1;
    }
}

