/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMobType;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockPressurePlate
extends Block {
    private EnumMobType triggerMobType;

    protected BlockPressurePlate(int par1, int par2, EnumMobType par3EnumMobType, Material par4Material) {
        super(par1, par2, par4Material);
        this.triggerMobType = par3EnumMobType;
        this.setTickRandomly(true);
        float f = 0.0625f;
        this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int i) {
        return true;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return par1World.isBlockNormalCube(par2, par3 - 1, par4) || par1World.getBlockId(par2, par3 - 1, par4) == Block.fence.blockID;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        boolean flag = false;
        if (!par1World.isBlockNormalCube(par2, par3 - 1, par4) && par1World.getBlockId(par2, par3 - 1, par4) != Block.fence.blockID) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.isRemote) {
            return;
        }
        if (par1World.getBlockMetadata(par2, par3, par4) == 0) {
            return;
        }
        this.setStateIfMobInteractsWithPlate(par1World, par2, par3, par4);
    }

    @Override
    public void onEntityCollidedWithBlock(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (par1World.isRemote) {
            return;
        }
        if (par1World.getBlockMetadata(par2, par3, par4) == 1) {
            return;
        }
        this.setStateIfMobInteractsWithPlate(par1World, par2, par3, par4);
    }

    private void setStateIfMobInteractsWithPlate(World par1World, int par2, int par3, int par4) {
        boolean flag = par1World.getBlockMetadata(par2, par3, par4) == 1;
        boolean flag1 = false;
        float f = 0.125f;
        List list = null;
        if (this.triggerMobType == EnumMobType.everything) {
            list = par1World.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f, par3, (float)par4 + f, (float)(par2 + 1) - f, (double)par3 + 0.25, (float)(par4 + 1) - f));
        }
        if (this.triggerMobType == EnumMobType.mobs) {
            list = par1World.getEntitiesWithinAABB(EntityLiving.class, AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f, par3, (float)par4 + f, (float)(par2 + 1) - f, (double)par3 + 0.25, (float)(par4 + 1) - f));
        }
        if (this.triggerMobType == EnumMobType.players) {
            list = par1World.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBoxFromPool((float)par2 + f, par3, (float)par4 + f, (float)(par2 + 1) - f, (double)par3 + 0.25, (float)(par4 + 1) - f));
        }
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 1);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
            par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.1, (double)par4 + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!flag1 && flag) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 0);
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
            par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.1, (double)par4 + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (flag1) {
            par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
        }
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (i > 0) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        }
        super.onBlockRemoval(par1World, par2, par3, par4);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        boolean flag = par1IBlockAccess.getBlockMetadata(par2, par3, par4) == 1;
        float f = 0.0625f;
        if (flag) {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
        } else {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.0625f, 1.0f - f);
        }
    }

    @Override
    public boolean isPoweringTo(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return par1IBlockAccess.getBlockMetadata(par2, par3, par4) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.getBlockMetadata(par2, par3, par4) == 0) {
            return false;
        }
        return par5 == 1;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f = 0.5f;
        float f1 = 0.125f;
        float f2 = 0.5f;
        this.setBlockBounds(0.5f - f, 0.5f - f1, 0.5f - f2, 0.5f + f, 0.5f + f1, 0.5f + f2);
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

