/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockBreakable;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockPortal
extends BlockBreakable {
    public BlockPortal(int par1, int par2) {
        super(par1, par2, Material.portal, false);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (par1IBlockAccess.getBlockId(par2 - 1, par3, par4) == this.blockID || par1IBlockAccess.getBlockId(par2 + 1, par3, par4) == this.blockID) {
            float f = 0.5f;
            float f2 = 0.125f;
            this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f2, 0.5f + f, 1.0f, 0.5f + f2);
        } else {
            float f1 = 0.125f;
            float f3 = 0.5f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f3, 0.5f + f1, 1.0f, 0.5f + f3);
        }
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean tryToCreatePortal(World par1World, int par2, int par3, int par4) {
        int i = 0;
        int j = 0;
        if (par1World.getBlockId(par2 - 1, par3, par4) == Block.obsidian.blockID || par1World.getBlockId(par2 + 1, par3, par4) == Block.obsidian.blockID) {
            i = 1;
        }
        if (par1World.getBlockId(par2, par3, par4 - 1) == Block.obsidian.blockID || par1World.getBlockId(par2, par3, par4 + 1) == Block.obsidian.blockID) {
            j = 1;
        }
        if (i == j) {
            return false;
        }
        if (par1World.getBlockId(par2 - i, par3, par4 - j) == 0) {
            par2 -= i;
            par4 -= j;
        }
        for (int k = -1; k <= 2; ++k) {
            for (int i1 = -1; i1 <= 3; ++i1) {
                boolean flag;
                boolean bl = flag = k == -1 || k == 2 || i1 == -1 || i1 == 3;
                if (!(k != -1 && k != 2 || i1 != -1 && i1 != 3)) continue;
                int k1 = par1World.getBlockId(par2 + i * k, par3 + i1, par4 + j * k);
                if (!(flag ? k1 != Block.obsidian.blockID : k1 != 0 && k1 != Block.fire.blockID)) continue;
                return false;
            }
        }
        par1World.editingBlocks = true;
        for (int l = 0; l < 2; ++l) {
            for (int j1 = 0; j1 < 3; ++j1) {
                par1World.setBlockWithNotify(par2 + i * l, par3 + j1, par4 + j * l, Block.portal.blockID);
            }
        }
        par1World.editingBlocks = false;
        return true;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        boolean flag1;
        int l;
        int i = 0;
        int j = 1;
        if (par1World.getBlockId(par2 - 1, par3, par4) == this.blockID || par1World.getBlockId(par2 + 1, par3, par4) == this.blockID) {
            i = 1;
            j = 0;
        }
        int k = par3;
        while (par1World.getBlockId(par2, k - 1, par4) == this.blockID) {
            --k;
        }
        if (par1World.getBlockId(par2, k - 1, par4) != Block.obsidian.blockID) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return;
        }
        for (l = 1; l < 4 && par1World.getBlockId(par2, k + l, par4) == this.blockID; ++l) {
        }
        if (l != 3 || par1World.getBlockId(par2, k + l, par4) != Block.obsidian.blockID) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return;
        }
        boolean flag = par1World.getBlockId(par2 - 1, par3, par4) == this.blockID || par1World.getBlockId(par2 + 1, par3, par4) == this.blockID;
        boolean bl = flag1 = par1World.getBlockId(par2, par3, par4 - 1) == this.blockID || par1World.getBlockId(par2, par3, par4 + 1) == this.blockID;
        if (flag && flag1) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return;
        }
        if (!(par1World.getBlockId(par2 + i, par3, par4 + j) == Block.obsidian.blockID && par1World.getBlockId(par2 - i, par3, par4 - j) == this.blockID || par1World.getBlockId(par2 - i, par3, par4 - j) == Block.obsidian.blockID && par1World.getBlockId(par2 + i, par3, par4 + j) == this.blockID)) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return;
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        boolean flag5;
        if (par1IBlockAccess.getBlockId(par2, par3, par4) == this.blockID) {
            return false;
        }
        boolean flag = par1IBlockAccess.getBlockId(par2 - 1, par3, par4) == this.blockID && par1IBlockAccess.getBlockId(par2 - 2, par3, par4) != this.blockID;
        boolean flag1 = par1IBlockAccess.getBlockId(par2 + 1, par3, par4) == this.blockID && par1IBlockAccess.getBlockId(par2 + 2, par3, par4) != this.blockID;
        boolean flag2 = par1IBlockAccess.getBlockId(par2, par3, par4 - 1) == this.blockID && par1IBlockAccess.getBlockId(par2, par3, par4 - 2) != this.blockID;
        boolean flag3 = par1IBlockAccess.getBlockId(par2, par3, par4 + 1) == this.blockID && par1IBlockAccess.getBlockId(par2, par3, par4 + 2) != this.blockID;
        boolean flag4 = flag || flag1;
        boolean bl = flag5 = flag2 || flag3;
        if (flag4 && par5 == 4) {
            return true;
        }
        if (flag4 && par5 == 5) {
            return true;
        }
        if (flag5 && par5 == 2) {
            return true;
        }
        return flag5 && par5 == 3;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 0;
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public void onEntityCollidedWithBlock(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (par5Entity.ridingEntity == null && par5Entity.riddenByEntity == null) {
            par5Entity.setInPortal();
        }
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par5Random.nextInt(100) == 0) {
            par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "portal.portal", 0.5f, par5Random.nextFloat() * 0.4f + 0.8f);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (float)par2 + par5Random.nextFloat();
            double d1 = (float)par3 + par5Random.nextFloat();
            double d2 = (float)par4 + par5Random.nextFloat();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int j = par5Random.nextInt(2) * 2 - 1;
            d3 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            d4 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            d5 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            if (par1World.getBlockId(par2 - 1, par3, par4) == this.blockID || par1World.getBlockId(par2 + 1, par3, par4) == this.blockID) {
                d2 = (double)par4 + 0.5 + 0.25 * (double)j;
                d5 = par5Random.nextFloat() * 2.0f * (float)j;
            } else {
                d = (double)par2 + 0.5 + 0.25 * (double)j;
                d3 = par5Random.nextFloat() * 2.0f * (float)j;
            }
            par1World.spawnParticle("portal", d, d1, d2, d3, d4, d5);
        }
    }
}

