/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Facing;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityPiston;
import net.minecraft.src.World;

public class BlockPistonMoving
extends BlockContainer {
    public BlockPistonMoving(int par1) {
        super(par1, Material.piston);
        this.setHardness(-1.0f);
    }

    @Override
    public TileEntity getBlockEntity() {
        return null;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        TileEntity tileentity = par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            ((TileEntityPiston)tileentity).clearPistonTileEntity();
        } else {
            super.onBlockRemoval(par1World, par2, par3, par4);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int i) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int i, int j) {
        return false;
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (!par1World.isRemote && par1World.getBlockTileEntity(par2, par3, par4) == null) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return true;
        }
        return false;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return 0;
    }

    @Override
    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (par1World.isRemote) {
            return;
        }
        TileEntityPiston tileentitypiston = this.getTileEntityAtLocation(par1World, par2, par3, par4);
        if (tileentitypiston == null) {
            return;
        }
        Block.blocksList[tileentitypiston.getStoredBlockID()].dropBlockAsItem(par1World, par2, par3, par4, tileentitypiston.getBlockMetadata(), 0);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.isRemote || par1World.getBlockTileEntity(par2, par3, par4) != null) {
            // empty if block
        }
    }

    public static TileEntity getTileEntity(int par0, int par1, int par2, boolean par3, boolean par4) {
        return new TileEntityPiston(par0, par1, par2, par3, par4);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        TileEntityPiston tileentitypiston = this.getTileEntityAtLocation(par1World, par2, par3, par4);
        if (tileentitypiston == null) {
            return null;
        }
        float f = tileentitypiston.getProgress(0.0f);
        if (tileentitypiston.isExtending()) {
            f = 1.0f - f;
        }
        return this.getAxisAlignedBB(par1World, par2, par3, par4, tileentitypiston.getStoredBlockID(), f, tileentitypiston.getPistonOrientation());
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        TileEntityPiston tileentitypiston = this.getTileEntityAtLocation(par1IBlockAccess, par2, par3, par4);
        if (tileentitypiston != null) {
            Block block = Block.blocksList[tileentitypiston.getStoredBlockID()];
            if (block == null || block == this) {
                return;
            }
            block.setBlockBoundsBasedOnState(par1IBlockAccess, par2, par3, par4);
            float f = tileentitypiston.getProgress(0.0f);
            if (tileentitypiston.isExtending()) {
                f = 1.0f - f;
            }
            int i = tileentitypiston.getPistonOrientation();
            this.minX = block.minX - (double)((float)Facing.offsetsXForSide[i] * f);
            this.minY = block.minY - (double)((float)Facing.offsetsYForSide[i] * f);
            this.minZ = block.minZ - (double)((float)Facing.offsetsZForSide[i] * f);
            this.maxX = block.maxX - (double)((float)Facing.offsetsXForSide[i] * f);
            this.maxY = block.maxY - (double)((float)Facing.offsetsYForSide[i] * f);
            this.maxZ = block.maxZ - (double)((float)Facing.offsetsZForSide[i] * f);
        }
    }

    public AxisAlignedBB getAxisAlignedBB(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (par5 == 0 || par5 == this.blockID) {
            return null;
        }
        AxisAlignedBB axisalignedbb = Block.blocksList[par5].getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
        if (axisalignedbb == null) {
            return null;
        }
        if (Facing.offsetsXForSide[par7] < 0) {
            axisalignedbb.minX -= (double)((float)Facing.offsetsXForSide[par7] * par6);
        } else {
            axisalignedbb.maxX -= (double)((float)Facing.offsetsXForSide[par7] * par6);
        }
        if (Facing.offsetsYForSide[par7] < 0) {
            axisalignedbb.minY -= (double)((float)Facing.offsetsYForSide[par7] * par6);
        } else {
            axisalignedbb.maxY -= (double)((float)Facing.offsetsYForSide[par7] * par6);
        }
        if (Facing.offsetsZForSide[par7] < 0) {
            axisalignedbb.minZ -= (double)((float)Facing.offsetsZForSide[par7] * par6);
        } else {
            axisalignedbb.maxZ -= (double)((float)Facing.offsetsZForSide[par7] * par6);
        }
        return axisalignedbb;
    }

    private TileEntityPiston getTileEntityAtLocation(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        TileEntity tileentity = par1IBlockAccess.getBlockTileEntity(par2, par3, par4);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            return (TileEntityPiston)tileentity;
        }
        return null;
    }
}

