/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockPistonBase;
import net.minecraft.src.Facing;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockPistonExtension
extends Block {
    private int headTexture = -1;

    public BlockPistonExtension(int par1, int par2) {
        super(par1, par2, Material.piston);
        this.setStepSound(soundStoneFootstep);
        this.setHardness(0.5f);
    }

    public void setHeadTexture(int par1) {
        this.headTexture = par1;
    }

    public void clearHeadTexture() {
        this.headTexture = -1;
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        int j;
        super.onBlockRemoval(par1World, par2, par3, par4);
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int k = Facing.faceToSide[BlockPistonExtension.getDirectionMeta(i)];
        int l = par1World.getBlockId(par2 += Facing.offsetsXForSide[k], par3 += Facing.offsetsYForSide[k], par4 += Facing.offsetsZForSide[k]);
        if ((l == Block.pistonBase.blockID || l == Block.pistonStickyBase.blockID) && BlockPistonBase.isExtended(j = par1World.getBlockMetadata(par2, par3, par4))) {
            Block.blocksList[l].dropBlockAsItem(par1World, par2, par3, par4, j, 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        int i = BlockPistonExtension.getDirectionMeta(par2);
        if (par1 == i) {
            if (this.headTexture >= 0) {
                return this.headTexture;
            }
            if ((par2 & 8) != 0) {
                return this.blockIndexInTexture - 1;
            }
            return this.blockIndexInTexture;
        }
        return par1 != Facing.faceToSide[i] ? 108 : 107;
    }

    @Override
    public int getRenderType() {
        return 17;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int i) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int i, int j) {
        return false;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 0;
    }

    @Override
    public void getCollidingBoundingBoxes(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, ArrayList par6ArrayList) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        switch (BlockPistonExtension.getDirectionMeta(i)) {
            case 0: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                this.setBlockBounds(0.375f, 0.25f, 0.375f, 0.625f, 1.0f, 0.625f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                this.setBlockBounds(0.375f, 0.0f, 0.375f, 0.625f, 0.75f, 0.625f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                this.setBlockBounds(0.25f, 0.375f, 0.25f, 0.75f, 0.625f, 1.0f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                this.setBlockBounds(0.25f, 0.375f, 0.0f, 0.75f, 0.625f, 0.75f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                this.setBlockBounds(0.375f, 0.25f, 0.25f, 0.625f, 0.75f, 1.0f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                break;
            }
            case 5: {
                this.setBlockBounds(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
                this.setBlockBounds(0.0f, 0.375f, 0.25f, 0.75f, 0.625f, 0.75f);
                super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
            }
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        switch (BlockPistonExtension.getDirectionMeta(i)) {
            case 0: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        int i = BlockPistonExtension.getDirectionMeta(par1World.getBlockMetadata(par2, par3, par4));
        int j = par1World.getBlockId(par2 - Facing.offsetsXForSide[i], par3 - Facing.offsetsYForSide[i], par4 - Facing.offsetsZForSide[i]);
        if (j != Block.pistonBase.blockID && j != Block.pistonStickyBase.blockID) {
            par1World.setBlockWithNotify(par2, par3, par4, 0);
        } else {
            Block.blocksList[j].onNeighborBlockChange(par1World, par2 - Facing.offsetsXForSide[i], par3 - Facing.offsetsYForSide[i], par4 - Facing.offsetsZForSide[i], par5);
        }
    }

    public static int getDirectionMeta(int par0) {
        return par0 & 7;
    }
}

