/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityNote;
import net.minecraft.src.World;

public class BlockNote
extends BlockContainer {
    public BlockNote(int par1) {
        super(par1, 74, Material.wood);
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        return this.blockIndexInTexture;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 > 0) {
            boolean flag = par1World.isBlockIndirectlyGettingPowered(par2, par3, par4);
            TileEntityNote tileentitynote = (TileEntityNote)par1World.getBlockTileEntity(par2, par3, par4);
            if (tileentitynote != null && tileentitynote.previousRedstoneState != flag) {
                if (flag) {
                    tileentitynote.triggerNote(par1World, par2, par3, par4);
                }
                tileentitynote.previousRedstoneState = flag;
            }
        }
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.isRemote) {
            return true;
        }
        TileEntityNote tileentitynote = (TileEntityNote)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitynote != null) {
            tileentitynote.changePitch();
            tileentitynote.triggerNote(par1World, par2, par3, par4);
        }
        return true;
    }

    @Override
    public void onBlockClicked(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.isRemote) {
            return;
        }
        TileEntityNote tileentitynote = (TileEntityNote)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitynote != null) {
            tileentitynote.triggerNote(par1World, par2, par3, par4);
        }
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityNote();
    }

    @Override
    public void powerBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)Math.pow(2.0, (double)(par6 - 12) / 12.0);
        String s = "harp";
        if (par5 == 1) {
            s = "bd";
        }
        if (par5 == 2) {
            s = "snare";
        }
        if (par5 == 3) {
            s = "hat";
        }
        if (par5 == 4) {
            s = "bassattack";
        }
        par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "note." + s, 3.0f, f);
        par1World.spawnParticle("note", (double)par2 + 0.5, (double)par3 + 1.2, (double)par4 + 0.5, (double)par6 / 24.0, 0.0, 0.0);
    }
}

