/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.BiomeGenHell;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class BlockNetherStalk
extends BlockFlower {
    protected BlockNetherStalk(int par1) {
        super(par1, 226);
        this.setTickRandomly(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int par1) {
        return par1 == Block.slowSand.blockID;
    }

    @Override
    public boolean canBlockStay(World par1World, int par2, int par3, int par4) {
        return this.canThisPlantGrowOnThisBlockID(par1World.getBlockId(par2, par3 - 1, par4));
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        BiomeGenBase biomegenbase;
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (i < 3 && (biomegenbase = par1World.getBiomeGenForCoords(par2, par4)) instanceof BiomeGenHell && par5Random.nextInt(10) == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, ++i);
        }
        super.updateTick(par1World, par2, par3, par4, par5Random);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par2 >= 3) {
            return this.blockIndexInTexture + 2;
        }
        if (par2 > 0) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public int getRenderType() {
        return 6;
    }

    @Override
    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (par1World.isRemote) {
            return;
        }
        int i = 1;
        if (par5 >= 3) {
            i = 2 + par1World.rand.nextInt(3);
            if (par7 > 0) {
                i += par1World.rand.nextInt(par7 + 1);
            }
        }
        for (int j = 0; j < i; ++j) {
            this.dropBlockAsItem_do(par1World, par2, par3, par4, new ItemStack(Item.netherStalkSeeds));
        }
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return 0;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 0;
    }
}

