/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenBigMushroom;

public class BlockMushroom
extends BlockFlower {
    protected BlockMushroom(int par1, int par2) {
        super(par1, par2);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setTickRandomly(true);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par5Random.nextInt(25) == 0) {
            int byte0 = 4;
            int i = 5;
            for (int j = par2 - byte0; j <= par2 + byte0; ++j) {
                for (int l = par4 - byte0; l <= par4 + byte0; ++l) {
                    for (int j1 = par3 - 1; j1 <= par3 + 1; ++j1) {
                        if (par1World.getBlockId(j, j1, l) != this.blockID || --i > 0) continue;
                        return;
                    }
                }
            }
            int k = par2 + par5Random.nextInt(3) - 1;
            int i1 = par3 + par5Random.nextInt(2) - par5Random.nextInt(2);
            int k1 = par4 + par5Random.nextInt(3) - 1;
            for (int l1 = 0; l1 < 4; ++l1) {
                if (par1World.isAirBlock(k, i1, k1) && this.canBlockStay(par1World, k, i1, k1)) {
                    par2 = k;
                    par3 = i1;
                    par4 = k1;
                }
                k = par2 + par5Random.nextInt(3) - 1;
                i1 = par3 + par5Random.nextInt(2) - par5Random.nextInt(2);
                k1 = par4 + par5Random.nextInt(3) - 1;
            }
            if (par1World.isAirBlock(k, i1, k1) && this.canBlockStay(par1World, k, i1, k1)) {
                par1World.setBlockWithNotify(k, i1, k1, this.blockID);
            }
        }
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return super.canPlaceBlockAt(par1World, par2, par3, par4) && this.canBlockStay(par1World, par2, par3, par4);
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int par1) {
        return Block.opaqueCubeLookup[par1];
    }

    @Override
    public boolean canBlockStay(World par1World, int par2, int par3, int par4) {
        if (par3 < 0 || par3 >= 256) {
            return false;
        }
        int i = par1World.getBlockId(par2, par3 - 1, par4);
        return i == Block.mycelium.blockID || par1World.getFullBlockLightValue(par2, par3, par4) < 13 && this.canThisPlantGrowOnThisBlockID(i);
    }

    public boolean fertilizeMushroom(World par1World, int par2, int par3, int par4, Random par5Random) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        par1World.setBlock(par2, par3, par4, 0);
        WorldGenBigMushroom worldgenbigmushroom = null;
        if (this.blockID == Block.mushroomBrown.blockID) {
            worldgenbigmushroom = new WorldGenBigMushroom(0);
        } else if (this.blockID == Block.mushroomRed.blockID) {
            worldgenbigmushroom = new WorldGenBigMushroom(1);
        }
        if (worldgenbigmushroom == null || !worldgenbigmushroom.generate(par1World, par5Random, par2, par3, par4)) {
            par1World.setBlockAndMetadata(par2, par3, par4, this.blockID, i);
            return false;
        }
        return true;
    }
}

