/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockLever
extends Block {
    protected BlockLever(int par1, int par2) {
        super(par1, par2, Material.circuits);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 12;
    }

    @Override
    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 == 1 && par1World.isBlockNormalCube(par2, par3 - 1, par4)) {
            return true;
        }
        if (par5 == 2 && par1World.isBlockNormalCube(par2, par3, par4 + 1)) {
            return true;
        }
        if (par5 == 3 && par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            return true;
        }
        if (par5 == 4 && par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            return true;
        }
        return par5 == 5 && par1World.isBlockNormalCube(par2 - 1, par3, par4);
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (par1World.isBlockNormalCube(par2 - 1, par3, par4)) {
            return true;
        }
        if (par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            return true;
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            return true;
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 + 1)) {
            return true;
        }
        return par1World.isBlockNormalCube(par2, par3 - 1, par4);
    }

    @Override
    public void onBlockPlaced(World par1World, int par2, int par3, int par4, int par5) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = i & 8;
        i &= 7;
        i = -1;
        if (par5 == 1 && par1World.isBlockNormalCube(par2, par3 - 1, par4)) {
            i = 5 + par1World.rand.nextInt(2);
        }
        if (par5 == 2 && par1World.isBlockNormalCube(par2, par3, par4 + 1)) {
            i = 4;
        }
        if (par5 == 3 && par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            i = 3;
        }
        if (par5 == 4 && par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            i = 2;
        }
        if (par5 == 5 && par1World.isBlockNormalCube(par2 - 1, par3, par4)) {
            i = 1;
        }
        if (i == -1) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return;
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i + j);
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (this.checkIfAttachedToBlock(par1World, par2, par3, par4)) {
            int i = par1World.getBlockMetadata(par2, par3, par4) & 7;
            boolean flag = false;
            if (!par1World.isBlockNormalCube(par2 - 1, par3, par4) && i == 1) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2 + 1, par3, par4) && i == 2) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2, par3, par4 - 1) && i == 3) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2, par3, par4 + 1) && i == 4) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2, par3 - 1, par4) && i == 5) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2, par3 - 1, par4) && i == 6) {
                flag = true;
            }
            if (flag) {
                this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
                par1World.setBlockWithNotify(par2, par3, par4, 0);
            }
        }
    }

    private boolean checkIfAttachedToBlock(World par1World, int par2, int par3, int par4) {
        if (!this.canPlaceBlockAt(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return false;
        }
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 7;
        float f = 0.1875f;
        if (i == 1) {
            this.setBlockBounds(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (i == 2) {
            this.setBlockBounds(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (i == 3) {
            this.setBlockBounds(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (i == 4) {
            this.setBlockBounds(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            float f1 = 0.25f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
        }
    }

    @Override
    public void onBlockClicked(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.blockActivated(par1World, par2, par3, par4, par5EntityPlayer);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.isRemote) {
            return true;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = i & 7;
        int k = 8 - (i & 8);
        par1World.setBlockMetadataWithNotify(par2, par3, par4, j + k);
        par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
        par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "random.click", 0.3f, k <= 0 ? 0.5f : 0.6f);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
        if (j == 1) {
            par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
        } else if (j == 2) {
            par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
        } else if (j == 3) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
        } else if (j == 4) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
        } else {
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        }
        return true;
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) > 0) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
            int j = i & 7;
            if (j == 1) {
                par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
            } else if (j == 2) {
                par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
            } else if (j == 3) {
                par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
            } else if (j == 4) {
                par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
            } else {
                par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            }
        }
        super.onBlockRemoval(par1World, par2, par3, par4);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return (par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 8) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World par1World, int par2, int par3, int par4, int par5) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) == 0) {
            return false;
        }
        int j = i & 7;
        if (j == 6 && par5 == 1) {
            return true;
        }
        if (j == 5 && par5 == 1) {
            return true;
        }
        if (j == 4 && par5 == 2) {
            return true;
        }
        if (j == 3 && par5 == 3) {
            return true;
        }
        if (j == 2 && par5 == 4) {
            return true;
        }
        return j == 1 && par5 == 5;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }
}

