/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockLeaves
extends BlockLeavesBase {
    private int baseIndexInPNG;
    int[] adjacentTreeBlocks;

    protected BlockLeaves(int par1, int par2) {
        super(par1, par2, Material.leaves, false);
        this.baseIndexInPNG = par2;
        this.setTickRandomly(true);
    }

    @Override
    public int getBlockColor() {
        double d = 0.5;
        double d1 = 1.0;
        return ColorizerFoliage.getFoliageColor(d, d1);
    }

    @Override
    public int getRenderColor(int par1) {
        if ((par1 & 3) == 1) {
            return ColorizerFoliage.getFoliageColorPine();
        }
        if ((par1 & 3) == 2) {
            return ColorizerFoliage.getFoliageColorBirch();
        }
        return ColorizerFoliage.getFoliageColorBasic();
    }

    @Override
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if ((i & 3) == 1) {
            return ColorizerFoliage.getFoliageColorPine();
        }
        if ((i & 3) == 2) {
            return ColorizerFoliage.getFoliageColorBirch();
        }
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = -1; i1 <= 1; ++i1) {
            for (int j1 = -1; j1 <= 1; ++j1) {
                int k1 = par1IBlockAccess.getBiomeGenForCoords(par2 + j1, par4 + i1).getBiomeFoliageColor();
                j += (k1 & 0xFF0000) >> 16;
                k += (k1 & 0xFF00) >> 8;
                l += k1 & 0xFF;
            }
        }
        return (j / 9 & 0xFF) << 16 | (k / 9 & 0xFF) << 8 | l / 9 & 0xFF;
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        int i = 1;
        int j = i + 1;
        if (par1World.checkChunksExist(par2 - j, par3 - j, par4 - j, par2 + j, par3 + j, par4 + j)) {
            for (int k = -i; k <= i; ++k) {
                for (int l = -i; l <= i; ++l) {
                    for (int i1 = -i; i1 <= i; ++i1) {
                        int j1 = par1World.getBlockId(par2 + k, par3 + l, par4 + i1);
                        if (j1 != Block.leaves.blockID) continue;
                        int k1 = par1World.getBlockMetadata(par2 + k, par3 + l, par4 + i1);
                        par1World.setBlockMetadata(par2 + k, par3 + l, par4 + i1, k1 | 8);
                    }
                }
            }
        }
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) != 0 && (i & 4) == 0) {
            int k1;
            int byte0 = 4;
            int j = byte0 + 1;
            int byte1 = 32;
            int k = byte1 * byte1;
            int l = byte1 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[byte1 * byte1 * byte1];
            }
            if (par1World.checkChunksExist(par2 - j, par3 - j, par4 - j, par2 + j, par3 + j, par4 + j)) {
                for (int i1 = -byte0; i1 <= byte0; ++i1) {
                    for (int l1 = -byte0; l1 <= byte0; ++l1) {
                        for (int j2 = -byte0; j2 <= byte0; ++j2) {
                            int l2 = par1World.getBlockId(par2 + i1, par3 + l1, par4 + j2);
                            this.adjacentTreeBlocks[(i1 + l) * k + (l1 + l) * byte1 + (j2 + l)] = l2 == Block.wood.blockID ? 0 : (l2 == Block.leaves.blockID ? -2 : -1);
                        }
                    }
                }
                for (int j1 = 1; j1 <= 4; ++j1) {
                    for (int i2 = -byte0; i2 <= byte0; ++i2) {
                        for (int k2 = -byte0; k2 <= byte0; ++k2) {
                            for (int i3 = -byte0; i3 <= byte0; ++i3) {
                                if (this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l) * byte1 + (i3 + l)] != j1 - 1) continue;
                                if (this.adjacentTreeBlocks[(i2 + l - 1) * k + (k2 + l) * byte1 + (i3 + l)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + l - 1) * k + (k2 + l) * byte1 + (i3 + l)] = j1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + l + 1) * k + (k2 + l) * byte1 + (i3 + l)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + l + 1) * k + (k2 + l) * byte1 + (i3 + l)] = j1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l - 1) * byte1 + (i3 + l)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l - 1) * byte1 + (i3 + l)] = j1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l + 1) * byte1 + (i3 + l)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l + 1) * byte1 + (i3 + l)] = j1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l) * byte1 + (i3 + l - 1)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l) * byte1 + (i3 + l - 1)] = j1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l) * byte1 + (i3 + l + 1)] != -2) continue;
                                this.adjacentTreeBlocks[(i2 + l) * k + (k2 + l) * byte1 + (i3 + l + 1)] = j1;
                            }
                        }
                    }
                }
            }
            if ((k1 = this.adjacentTreeBlocks[l * k + l * byte1 + l]) >= 0) {
                par1World.setBlockMetadata(par2, par3, par4, i & 0xFFFFFFF7);
            } else {
                this.removeLeaves(par1World, par2, par3, par4);
            }
        }
    }

    private void removeLeaves(World par1World, int par2, int par3, int par4) {
        this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
        par1World.setBlockWithNotify(par2, par3, par4, 0);
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return par1Random.nextInt(20) != 0 ? 0 : 1;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Block.sapling.blockID;
    }

    @Override
    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (!par1World.isRemote) {
            int byte0 = 20;
            if ((par5 & 3) == 3) {
                byte0 = 40;
            }
            if (par1World.rand.nextInt(byte0) == 0) {
                int i = this.idDropped(par5, par1World.rand, par7);
                this.dropBlockAsItem_do(par1World, par2, par3, par4, new ItemStack(i, 1, this.damageDropped(par5)));
            }
            if ((par5 & 3) == 0 && par1World.rand.nextInt(200) == 0) {
                this.dropBlockAsItem_do(par1World, par2, par3, par4, new ItemStack(Item.appleRed, 1, 0));
            }
        }
    }

    @Override
    public void harvestBlock(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        if (!par1World.isRemote && par2EntityPlayer.getCurrentEquippedItem() != null && par2EntityPlayer.getCurrentEquippedItem().itemID == Item.shears.shiftedIndex) {
            par2EntityPlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(par1World, par3, par4, par5, new ItemStack(Block.leaves.blockID, 1, par6 & 3));
        } else {
            super.harvestBlock(par1World, par2EntityPlayer, par3, par4, par5, par6);
        }
    }

    @Override
    protected int damageDropped(int par1) {
        return par1 & 3;
    }

    @Override
    public boolean isOpaqueCube() {
        return !this.graphicsLevel;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if ((par2 & 3) == 1) {
            return this.blockIndexInTexture + 80;
        }
        if ((par2 & 3) == 3) {
            return this.blockIndexInTexture + 144;
        }
        return this.blockIndexInTexture;
    }

    public void setGraphicsLevel(boolean par1) {
        this.graphicsLevel = par1;
        this.blockIndexInTexture = this.baseIndexInPNG + (par1 ? 0 : 1);
    }

    @Override
    public void onEntityWalking(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        super.onEntityWalking(par1World, par2, par3, par4, par5Entity);
    }
}

