/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.World;

public class BlockFurnace
extends BlockContainer {
    private Random furnaceRand = new Random();
    private final boolean isActive;
    private static boolean keepFurnaceInventory = false;

    protected BlockFurnace(int par1, boolean par2) {
        super(par1, Material.rock);
        this.isActive = par2;
        this.blockIndexInTexture = 45;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Block.stoneOvenIdle.blockID;
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        this.setDefaultDirection(par1World, par2, par3, par4);
    }

    private void setDefaultDirection(World par1World, int par2, int par3, int par4) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockId(par2, par3, par4 - 1);
        int j = par1World.getBlockId(par2, par3, par4 + 1);
        int k = par1World.getBlockId(par2 - 1, par3, par4);
        int l = par1World.getBlockId(par2 + 1, par3, par4);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[i] && !Block.opaqueCubeLookup[j]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[j] && !Block.opaqueCubeLookup[i]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[k] && !Block.opaqueCubeLookup[l]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[k]) {
            byte0 = 4;
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
    }

    @Override
    public int getBlockTexture(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (par5 == 1) {
            return this.blockIndexInTexture + 17;
        }
        if (par5 == 0) {
            return this.blockIndexInTexture + 17;
        }
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if (par5 != i) {
            return this.blockIndexInTexture;
        }
        if (this.isActive) {
            return this.blockIndexInTexture + 16;
        }
        return this.blockIndexInTexture - 1;
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!this.isActive) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        float f = (float)par2 + 0.5f;
        float f1 = (float)par3 + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)par4 + 0.5f;
        float f3 = 0.52f;
        float f4 = par5Random.nextFloat() * 0.6f - 0.3f;
        if (i == 4) {
            par1World.spawnParticle("smoke", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (i == 5) {
            par1World.spawnParticle("smoke", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (i == 2) {
            par1World.spawnParticle("smoke", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
        } else if (i == 3) {
            par1World.spawnParticle("smoke", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
            par1World.spawnParticle("flame", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        if (par1 == 1) {
            return this.blockIndexInTexture + 17;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture + 17;
        }
        if (par1 == 3) {
            return this.blockIndexInTexture - 1;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.isRemote) {
            return true;
        }
        TileEntityFurnace tileentityfurnace = (TileEntityFurnace)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentityfurnace != null) {
            par5EntityPlayer.displayGUIFurnace(tileentityfurnace);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean par0, World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        TileEntity tileentity = par1World.getBlockTileEntity(par2, par3, par4);
        keepFurnaceInventory = true;
        if (par0) {
            par1World.setBlockWithNotify(par2, par3, par4, Block.stoneOvenActive.blockID);
        } else {
            par1World.setBlockWithNotify(par2, par3, par4, Block.stoneOvenIdle.blockID);
        }
        keepFurnaceInventory = false;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
        if (tileentity != null) {
            tileentity.validate();
            par1World.setBlockTileEntity(par2, par3, par4, tileentity);
        }
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityFurnace();
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (i == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2);
        }
        if (i == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5);
        }
        if (i == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3);
        }
        if (i == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4);
        }
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        TileEntityFurnace tileentityfurnace;
        if (!keepFurnaceInventory && (tileentityfurnace = (TileEntityFurnace)par1World.getBlockTileEntity(par2, par3, par4)) != null) {
            for (int i = 0; i < tileentityfurnace.getSizeInventory(); ++i) {
                ItemStack itemstack = tileentityfurnace.getStackInSlot(i);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int j = this.furnaceRand.nextInt(21) + 10;
                    if (j > itemstack.stackSize) {
                        j = itemstack.stackSize;
                    }
                    itemstack.stackSize -= j;
                    EntityItem entityitem = new EntityItem(par1World, (float)par2 + f, (float)par3 + f1, (float)par4 + f2, new ItemStack(itemstack.itemID, j, itemstack.getItemDamage()));
                    if (itemstack.hasTagCompound()) {
                        entityitem.item.setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                    }
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.motionY = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.furnaceRand.nextGaussian() * f3;
                    par1World.spawnEntityInWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(par1World, par2, par3, par4);
    }
}

