/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockDirectional;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class BlockFenceGate
extends BlockDirectional {
    public BlockFenceGate(int par1, int par2) {
        super(par1, par2, Material.wood);
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (!par1World.getBlockMaterial(par2, par3 - 1, par4).isSolid()) {
            return false;
        }
        return super.canPlaceBlockAt(par1World, par2, par3, par4);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (BlockFenceGate.isFenceGateOpen(i)) {
            return null;
        }
        if (i == 2 || i == 0) {
            return AxisAlignedBB.getBoundingBoxFromPool(par2, par3, (float)par4 + 0.375f, par2 + 1, (float)par3 + 1.5f, (float)par4 + 0.625f);
        }
        return AxisAlignedBB.getBoundingBoxFromPool((float)par2 + 0.375f, par3, par4, (float)par2 + 0.625f, (float)par3 + 1.5f, par4 + 1);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = BlockFenceGate.getDirection(par1IBlockAccess.getBlockMetadata(par2, par3, par4));
        if (i == 2 || i == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
        } else {
            this.setBlockBounds(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return BlockFenceGate.isFenceGateOpen(par1IBlockAccess.getBlockMetadata(par2, par3, par4));
    }

    @Override
    public int getRenderType() {
        return 21;
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = (MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) % 4;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (BlockFenceGate.isFenceGateOpen(i)) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, i & 0xFFFFFFFB);
        } else {
            int j = (MathHelper.floor_double((double)(par5EntityPlayer.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) % 4;
            int k = BlockFenceGate.getDirection(i);
            if (k == (j + 2) % 4) {
                i = j;
            }
            par1World.setBlockMetadataWithNotify(par2, par3, par4, i | 4);
        }
        par1World.playAuxSFXAtEntity(par5EntityPlayer, 1003, par2, par3, par4, 0);
        return true;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        boolean flag = par1World.isBlockIndirectlyGettingPowered(par2, par3, par4);
        if (flag || par5 > 0 && Block.blocksList[par5].canProvidePower() || par5 == 0) {
            if (flag && !BlockFenceGate.isFenceGateOpen(i)) {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, i | 4);
                par1World.playAuxSFXAtEntity(null, 1003, par2, par3, par4, 0);
            } else if (!flag && BlockFenceGate.isFenceGateOpen(i)) {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, i & 0xFFFFFFFB);
                par1World.playAuxSFXAtEntity(null, 1003, par2, par3, par4, 0);
            }
        }
    }

    public static boolean isFenceGateOpen(int par0) {
        return (par0 & 4) != 0;
    }
}

