/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class BlockEndPortalFrame
extends Block {
    public BlockEndPortalFrame(int par1) {
        super(par1, 159, Material.glass);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par1 == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture + 16;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 26;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.8125f, 1.0f);
    }

    @Override
    public void getCollidingBoundingBoxes(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, ArrayList par6ArrayList) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.8125f, 1.0f);
        super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if (BlockEndPortalFrame.isEnderEyeInserted(i)) {
            this.setBlockBounds(0.3125f, 0.8125f, 0.3125f, 0.6875f, 1.0f, 0.6875f);
            super.getCollidingBoundingBoxes(par1World, par2, par3, par4, par5AxisAlignedBB, par6ArrayList);
        }
        this.setBlockBoundsForItemRender();
    }

    public static boolean isEnderEyeInserted(int par0) {
        return (par0 & 4) != 0;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return 0;
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = ((MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i);
    }
}

