/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityEnchantmentTable;
import net.minecraft.src.World;

public class BlockEnchantmentTable
extends BlockContainer {
    protected BlockEnchantmentTable(int par1) {
        super(par1, 166, Material.rock);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
        this.setLightOpacity(0);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        super.randomDisplayTick(par1World, par2, par3, par4, par5Random);
        for (int i = par2 - 2; i <= par2 + 2; ++i) {
            block1: for (int j = par4 - 2; j <= par4 + 2; ++j) {
                if (i > par2 - 2 && i < par2 + 2 && j == par4 - 1) {
                    j = par4 + 2;
                }
                if (par5Random.nextInt(16) != 0) continue;
                for (int k = par3; k <= par3 + 1; ++k) {
                    if (par1World.getBlockId(i, k, j) != Block.bookShelf.blockID) continue;
                    if (!par1World.isAirBlock((i - par2) / 2 + par2, k, (j - par4) / 2 + par4)) continue block1;
                    par1World.spawnParticle("enchantmenttable", (double)par2 + 0.5, (double)par3 + 2.0, (double)par4 + 0.5, (double)((float)(i - par2) + par5Random.nextFloat()) - 0.5, (float)(k - par3) - par5Random.nextFloat() - 1.0f, (double)((float)(j - par4) + par5Random.nextFloat()) - 0.5);
                }
            }
        }
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        return this.getBlockTextureFromSide(par1);
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        if (par1 == 0) {
            return this.blockIndexInTexture + 17;
        }
        if (par1 == 1) {
            return this.blockIndexInTexture;
        }
        return this.blockIndexInTexture + 16;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityEnchantmentTable();
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.isRemote) {
            return true;
        }
        par5EntityPlayer.displayGUIEnchantment(par2, par3, par4);
        return true;
    }
}

