/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityEgg;
import net.minecraft.src.EntityExpBottle;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPotion;
import net.minecraft.src.EntitySmallFireball;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemMonsterPlacer;
import net.minecraft.src.ItemPotion;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.World;

public class BlockDispenser
extends BlockContainer {
    private Random random = new Random();

    protected BlockDispenser(int par1) {
        super(par1, Material.rock);
        this.blockIndexInTexture = 45;
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public int idDropped(int par1, Random par2Random, int par3) {
        return Block.dispenser.blockID;
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        this.setDispenserDefaultDirection(par1World, par2, par3, par4);
    }

    private void setDispenserDefaultDirection(World par1World, int par2, int par3, int par4) {
        if (!par1World.isRemote) {
            int i = par1World.getBlockId(par2, par3, par4 - 1);
            int j = par1World.getBlockId(par2, par3, par4 + 1);
            int k = par1World.getBlockId(par2 - 1, par3, par4);
            int l = par1World.getBlockId(par2 + 1, par3, par4);
            int byte0 = 3;
            if (Block.opaqueCubeLookup[i] && !Block.opaqueCubeLookup[j]) {
                byte0 = 3;
            }
            if (Block.opaqueCubeLookup[j] && !Block.opaqueCubeLookup[i]) {
                byte0 = 2;
            }
            if (Block.opaqueCubeLookup[k] && !Block.opaqueCubeLookup[l]) {
                byte0 = 5;
            }
            if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[k]) {
                byte0 = 4;
            }
            par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
        }
    }

    @Override
    public int getBlockTexture(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (par5 == 1) {
            return this.blockIndexInTexture + 17;
        }
        if (par5 == 0) {
            return this.blockIndexInTexture + 17;
        }
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        return par5 == i ? this.blockIndexInTexture + 1 : this.blockIndexInTexture;
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        return par1 != 1 ? (par1 != 0 ? (par1 != 3 ? this.blockIndexInTexture : this.blockIndexInTexture + 1) : this.blockIndexInTexture + 17) : this.blockIndexInTexture + 17;
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        if (par1World.isRemote) {
            return true;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitydispenser != null) {
            par5EntityPlayer.displayGUIDispenser(tileentitydispenser);
        }
        return true;
    }

    private void dispenseItem(World par1World, int par2, int par3, int par4, Random par5Random) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = 0;
        int k = 0;
        if (i == 3) {
            k = 1;
        } else if (i == 2) {
            k = -1;
        } else {
            j = i == 5 ? 1 : -1;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitydispenser != null) {
            ItemStack itemstack = tileentitydispenser.getRandomStackFromInventory();
            double d = (double)par2 + (double)j * 0.6 + 0.5;
            double d1 = (double)par3 + 0.5;
            double d2 = (double)par4 + (double)k * 0.6 + 0.5;
            if (itemstack == null) {
                par1World.playAuxSFX(1001, par2, par3, par4, 0);
            } else {
                boolean flag = ModLoader.dispenseEntity(par1World, d, d1, d2, j, k, itemstack);
                if (!flag) {
                    if (itemstack.itemID == Item.arrow.shiftedIndex) {
                        EntityArrow entityarrow = new EntityArrow(par1World, d, d1, d2);
                        entityarrow.setArrowHeading(j, 0.1f, k, 1.1f, 6.0f);
                        entityarrow.doesArrowBelongToPlayer = true;
                        par1World.spawnEntityInWorld(entityarrow);
                        par1World.playAuxSFX(1002, par2, par3, par4, 0);
                    } else if (itemstack.itemID == Item.egg.shiftedIndex) {
                        EntityEgg entityegg = new EntityEgg(par1World, d, d1, d2);
                        entityegg.setThrowableHeading(j, 0.1f, k, 1.1f, 6.0f);
                        par1World.spawnEntityInWorld(entityegg);
                        par1World.playAuxSFX(1002, par2, par3, par4, 0);
                    } else if (itemstack.itemID == Item.snowball.shiftedIndex) {
                        EntitySnowball entitysnowball = new EntitySnowball(par1World, d, d1, d2);
                        entitysnowball.setThrowableHeading(j, 0.1f, k, 1.1f, 6.0f);
                        par1World.spawnEntityInWorld(entitysnowball);
                        par1World.playAuxSFX(1002, par2, par3, par4, 0);
                    } else if (itemstack.itemID == Item.potion.shiftedIndex && ItemPotion.isSplash(itemstack.getItemDamage())) {
                        EntityPotion entitypotion = new EntityPotion(par1World, d, d1, d2, itemstack.getItemDamage());
                        entitypotion.setThrowableHeading(j, 0.1f, k, 1.375f, 3.0f);
                        par1World.spawnEntityInWorld(entitypotion);
                        par1World.playAuxSFX(1002, par2, par3, par4, 0);
                    } else if (itemstack.itemID == Item.expBottle.shiftedIndex) {
                        EntityExpBottle entityexpbottle = new EntityExpBottle(par1World, d, d1, d2);
                        entityexpbottle.setThrowableHeading(j, 0.1f, k, 1.375f, 3.0f);
                        par1World.spawnEntityInWorld(entityexpbottle);
                        par1World.playAuxSFX(1002, par2, par3, par4, 0);
                    } else if (itemstack.itemID == Item.monsterPlacer.shiftedIndex) {
                        ItemMonsterPlacer.func_48440_a(par1World, itemstack.getItemDamage(), d + (double)j * 0.3, d1 - 0.3, d2 + (double)k * 0.3);
                        par1World.playAuxSFX(1002, par2, par3, par4, 0);
                    } else if (itemstack.itemID == Item.fireballCharge.shiftedIndex) {
                        EntitySmallFireball entitysmallfireball = new EntitySmallFireball(par1World, d + (double)j * 0.3, d1, d2 + (double)k * 0.3, (double)j + par5Random.nextGaussian() * 0.05, par5Random.nextGaussian() * 0.05, (double)k + par5Random.nextGaussian() * 0.05);
                        par1World.spawnEntityInWorld(entitysmallfireball);
                        par1World.playAuxSFX(1009, par2, par3, par4, 0);
                    } else {
                        EntityItem entityitem = new EntityItem(par1World, d, d1 - 0.3, d2, itemstack);
                        double d3 = par5Random.nextDouble() * 0.1 + 0.2;
                        entityitem.motionX = (double)j * d3;
                        entityitem.motionY = 0.2f;
                        entityitem.motionZ = (double)k * d3;
                        entityitem.motionX += par5Random.nextGaussian() * (double)0.0075f * 6.0;
                        entityitem.motionY += par5Random.nextGaussian() * (double)0.0075f * 6.0;
                        entityitem.motionZ += par5Random.nextGaussian() * (double)0.0075f * 6.0;
                        par1World.spawnEntityInWorld(entityitem);
                        par1World.playAuxSFX(1000, par2, par3, par4, 0);
                    }
                }
                par1World.playAuxSFX(2000, par2, par3, par4, j + 1 + (k + 1) * 3);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 > 0 && Block.blocksList[par5].canProvidePower()) {
            boolean flag;
            boolean bl = flag = par1World.isBlockIndirectlyGettingPowered(par2, par3, par4) || par1World.isBlockIndirectlyGettingPowered(par2, par3 + 1, par4);
            if (flag) {
                par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
            }
        }
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.isRemote && (par1World.isBlockIndirectlyGettingPowered(par2, par3, par4) || par1World.isBlockIndirectlyGettingPowered(par2, par3 + 1, par4))) {
            this.dispenseItem(par1World, par2, par3, par4, par5Random);
        }
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityDispenser();
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (i == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2);
        }
        if (i == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5);
        }
        if (i == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3);
        }
        if (i == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4);
        }
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitydispenser != null) {
            for (int i = 0; i < tileentitydispenser.getSizeInventory(); ++i) {
                ItemStack itemstack = tileentitydispenser.getStackInSlot(i);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int j = this.random.nextInt(21) + 10;
                    if (j > itemstack.stackSize) {
                        j = itemstack.stackSize;
                    }
                    itemstack.stackSize -= j;
                    EntityItem entityitem = new EntityItem(par1World, (float)par2 + f, (float)par3 + f1, (float)par4 + f2, new ItemStack(itemstack.itemID, j, itemstack.getItemDamage()));
                    if (itemstack.hasTagCompound()) {
                        entityitem.item.setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                    }
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    par1World.spawnEntityInWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(par1World, par2, par3, par4);
    }
}

