/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityOcelot;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryLargeChest;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.World;

public class BlockChest
extends BlockContainer {
    private Random random = new Random();

    protected BlockChest(int par1) {
        super(par1, Material.wood);
        this.blockIndexInTexture = 26;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 22;
    }

    @Override
    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        this.unifyAdjacentChests(par1World, par2, par3, par4);
        int i = par1World.getBlockId(par2, par3, par4 - 1);
        int j = par1World.getBlockId(par2, par3, par4 + 1);
        int k = par1World.getBlockId(par2 - 1, par3, par4);
        int l = par1World.getBlockId(par2 + 1, par3, par4);
        if (i == this.blockID) {
            this.unifyAdjacentChests(par1World, par2, par3, par4 - 1);
        }
        if (j == this.blockID) {
            this.unifyAdjacentChests(par1World, par2, par3, par4 + 1);
        }
        if (k == this.blockID) {
            this.unifyAdjacentChests(par1World, par2 - 1, par3, par4);
        }
        if (l == this.blockID) {
            this.unifyAdjacentChests(par1World, par2 + 1, par3, par4);
        }
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int i = par1World.getBlockId(par2, par3, par4 - 1);
        int j = par1World.getBlockId(par2, par3, par4 + 1);
        int k = par1World.getBlockId(par2 - 1, par3, par4);
        int l = par1World.getBlockId(par2 + 1, par3, par4);
        int byte0 = 0;
        int i1 = MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (i1 == 0) {
            byte0 = 2;
        }
        if (i1 == 1) {
            byte0 = 5;
        }
        if (i1 == 2) {
            byte0 = 3;
        }
        if (i1 == 3) {
            byte0 = 4;
        }
        if (i != this.blockID && j != this.blockID && k != this.blockID && l != this.blockID) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
        } else {
            if (!(i != this.blockID && j != this.blockID || byte0 != 4 && byte0 != 5)) {
                if (i == this.blockID) {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4 - 1, byte0);
                } else {
                    par1World.setBlockMetadataWithNotify(par2, par3, par4 + 1, byte0);
                }
                par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
            }
            if (!(k != this.blockID && l != this.blockID || byte0 != 2 && byte0 != 3)) {
                if (k == this.blockID) {
                    par1World.setBlockMetadataWithNotify(par2 - 1, par3, par4, byte0);
                } else {
                    par1World.setBlockMetadataWithNotify(par2 + 1, par3, par4, byte0);
                }
                par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
            }
        }
    }

    public void unifyAdjacentChests(World par1World, int par2, int par3, int par4) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockId(par2, par3, par4 - 1);
        int j = par1World.getBlockId(par2, par3, par4 + 1);
        int k = par1World.getBlockId(par2 - 1, par3, par4);
        int l = par1World.getBlockId(par2 + 1, par3, par4);
        int byte0 = 4;
        if (i == this.blockID || j == this.blockID) {
            int i1 = par1World.getBlockId(par2 - 1, par3, i != this.blockID ? par4 + 1 : par4 - 1);
            int k1 = par1World.getBlockId(par2 + 1, par3, i != this.blockID ? par4 + 1 : par4 - 1);
            byte0 = 5;
            int i2 = -1;
            i2 = i == this.blockID ? par1World.getBlockMetadata(par2, par3, par4 - 1) : par1World.getBlockMetadata(par2, par3, par4 + 1);
            if (i2 == 4) {
                byte0 = 4;
            }
            if ((Block.opaqueCubeLookup[k] || Block.opaqueCubeLookup[i1]) && !Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[k1]) {
                byte0 = 5;
            }
            if ((Block.opaqueCubeLookup[l] || Block.opaqueCubeLookup[k1]) && !Block.opaqueCubeLookup[k] && !Block.opaqueCubeLookup[i1]) {
                byte0 = 4;
            }
        } else if (k == this.blockID || l == this.blockID) {
            int j1 = par1World.getBlockId(k != this.blockID ? par2 + 1 : par2 - 1, par3, par4 - 1);
            int l1 = par1World.getBlockId(k != this.blockID ? par2 + 1 : par2 - 1, par3, par4 + 1);
            byte0 = 3;
            int j2 = -1;
            j2 = k == this.blockID ? par1World.getBlockMetadata(par2 - 1, par3, par4) : par1World.getBlockMetadata(par2 + 1, par3, par4);
            if (j2 == 2) {
                byte0 = 2;
            }
            if ((Block.opaqueCubeLookup[i] || Block.opaqueCubeLookup[j1]) && !Block.opaqueCubeLookup[j] && !Block.opaqueCubeLookup[l1]) {
                byte0 = 3;
            }
            if ((Block.opaqueCubeLookup[j] || Block.opaqueCubeLookup[l1]) && !Block.opaqueCubeLookup[i] && !Block.opaqueCubeLookup[j1]) {
                byte0 = 2;
            }
        } else {
            byte0 = 3;
            if (Block.opaqueCubeLookup[i] && !Block.opaqueCubeLookup[j]) {
                byte0 = 3;
            }
            if (Block.opaqueCubeLookup[j] && !Block.opaqueCubeLookup[i]) {
                byte0 = 2;
            }
            if (Block.opaqueCubeLookup[k] && !Block.opaqueCubeLookup[l]) {
                byte0 = 5;
            }
            if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[k]) {
                byte0 = 4;
            }
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, byte0);
    }

    @Override
    public int getBlockTexture(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (par5 == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (par5 == 0) {
            return this.blockIndexInTexture - 1;
        }
        int i = par1IBlockAccess.getBlockId(par2, par3, par4 - 1);
        int j = par1IBlockAccess.getBlockId(par2, par3, par4 + 1);
        int k = par1IBlockAccess.getBlockId(par2 - 1, par3, par4);
        int l = par1IBlockAccess.getBlockId(par2 + 1, par3, par4);
        if (i == this.blockID || j == this.blockID) {
            if (par5 == 2 || par5 == 3) {
                return this.blockIndexInTexture;
            }
            int i1 = 0;
            if (i == this.blockID) {
                i1 = -1;
            }
            int k1 = par1IBlockAccess.getBlockId(par2 - 1, par3, i != this.blockID ? par4 + 1 : par4 - 1);
            int i2 = par1IBlockAccess.getBlockId(par2 + 1, par3, i != this.blockID ? par4 + 1 : par4 - 1);
            if (par5 == 4) {
                i1 = -1 - i1;
            }
            int byte1 = 5;
            if ((Block.opaqueCubeLookup[k] || Block.opaqueCubeLookup[k1]) && !Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[i2]) {
                byte1 = 5;
            }
            if ((Block.opaqueCubeLookup[l] || Block.opaqueCubeLookup[i2]) && !Block.opaqueCubeLookup[k] && !Block.opaqueCubeLookup[k1]) {
                byte1 = 4;
            }
            return (par5 != byte1 ? this.blockIndexInTexture + 32 : this.blockIndexInTexture + 16) + i1;
        }
        if (k == this.blockID || l == this.blockID) {
            if (par5 == 4 || par5 == 5) {
                return this.blockIndexInTexture;
            }
            int j1 = 0;
            if (k == this.blockID) {
                j1 = -1;
            }
            int l1 = par1IBlockAccess.getBlockId(k != this.blockID ? par2 + 1 : par2 - 1, par3, par4 - 1);
            int j2 = par1IBlockAccess.getBlockId(k != this.blockID ? par2 + 1 : par2 - 1, par3, par4 + 1);
            if (par5 == 3) {
                j1 = -1 - j1;
            }
            int byte2 = 3;
            if ((Block.opaqueCubeLookup[i] || Block.opaqueCubeLookup[l1]) && !Block.opaqueCubeLookup[j] && !Block.opaqueCubeLookup[j2]) {
                byte2 = 3;
            }
            if ((Block.opaqueCubeLookup[j] || Block.opaqueCubeLookup[j2]) && !Block.opaqueCubeLookup[i] && !Block.opaqueCubeLookup[l1]) {
                byte2 = 2;
            }
            return (par5 != byte2 ? this.blockIndexInTexture + 32 : this.blockIndexInTexture + 16) + j1;
        }
        int byte0 = 3;
        if (Block.opaqueCubeLookup[i] && !Block.opaqueCubeLookup[j]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[j] && !Block.opaqueCubeLookup[i]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[k] && !Block.opaqueCubeLookup[l]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[k]) {
            byte0 = 4;
        }
        return par5 != byte0 ? this.blockIndexInTexture : this.blockIndexInTexture + 1;
    }

    @Override
    public int getBlockTextureFromSide(int par1) {
        if (par1 == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (par1 == 0) {
            return this.blockIndexInTexture - 1;
        }
        if (par1 == 3) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        int i = 0;
        if (par1World.getBlockId(par2 - 1, par3, par4) == this.blockID) {
            ++i;
        }
        if (par1World.getBlockId(par2 + 1, par3, par4) == this.blockID) {
            ++i;
        }
        if (par1World.getBlockId(par2, par3, par4 - 1) == this.blockID) {
            ++i;
        }
        if (par1World.getBlockId(par2, par3, par4 + 1) == this.blockID) {
            ++i;
        }
        if (i > 1) {
            return false;
        }
        if (this.isThereANeighborChest(par1World, par2 - 1, par3, par4)) {
            return false;
        }
        if (this.isThereANeighborChest(par1World, par2 + 1, par3, par4)) {
            return false;
        }
        if (this.isThereANeighborChest(par1World, par2, par3, par4 - 1)) {
            return false;
        }
        return !this.isThereANeighborChest(par1World, par2, par3, par4 + 1);
    }

    private boolean isThereANeighborChest(World par1World, int par2, int par3, int par4) {
        if (par1World.getBlockId(par2, par3, par4) != this.blockID) {
            return false;
        }
        if (par1World.getBlockId(par2 - 1, par3, par4) == this.blockID) {
            return true;
        }
        if (par1World.getBlockId(par2 + 1, par3, par4) == this.blockID) {
            return true;
        }
        if (par1World.getBlockId(par2, par3, par4 - 1) == this.blockID) {
            return true;
        }
        return par1World.getBlockId(par2, par3, par4 + 1) == this.blockID;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        super.onNeighborBlockChange(par1World, par2, par3, par4, par5);
        TileEntityChest tileentitychest = (TileEntityChest)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitychest != null) {
            tileentitychest.updateContainingBlockInfo();
        }
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        TileEntityChest tileentitychest = (TileEntityChest)par1World.getBlockTileEntity(par2, par3, par4);
        if (tileentitychest != null) {
            for (int i = 0; i < tileentitychest.getSizeInventory(); ++i) {
                ItemStack itemstack = tileentitychest.getStackInSlot(i);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int j = this.random.nextInt(21) + 10;
                    if (j > itemstack.stackSize) {
                        j = itemstack.stackSize;
                    }
                    itemstack.stackSize -= j;
                    EntityItem entityitem = new EntityItem(par1World, (float)par2 + f, (float)par3 + f1, (float)par4 + f2, new ItemStack(itemstack.itemID, j, itemstack.getItemDamage()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    if (itemstack.hasTagCompound()) {
                        entityitem.item.setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                    }
                    par1World.spawnEntityInWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(par1World, par2, par3, par4);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        IInventory obj = (TileEntityChest)par1World.getBlockTileEntity(par2, par3, par4);
        if (obj == null) {
            return true;
        }
        if (par1World.isBlockNormalCube(par2, par3 + 1, par4)) {
            return true;
        }
        if (BlockChest.func_50075_j(par1World, par2, par3, par4)) {
            return true;
        }
        if (par1World.getBlockId(par2 - 1, par3, par4) == this.blockID && (par1World.isBlockNormalCube(par2 - 1, par3 + 1, par4) || BlockChest.func_50075_j(par1World, par2 - 1, par3, par4))) {
            return true;
        }
        if (par1World.getBlockId(par2 + 1, par3, par4) == this.blockID && (par1World.isBlockNormalCube(par2 + 1, par3 + 1, par4) || BlockChest.func_50075_j(par1World, par2 + 1, par3, par4))) {
            return true;
        }
        if (par1World.getBlockId(par2, par3, par4 - 1) == this.blockID && (par1World.isBlockNormalCube(par2, par3 + 1, par4 - 1) || BlockChest.func_50075_j(par1World, par2, par3, par4 - 1))) {
            return true;
        }
        if (par1World.getBlockId(par2, par3, par4 + 1) == this.blockID && (par1World.isBlockNormalCube(par2, par3 + 1, par4 + 1) || BlockChest.func_50075_j(par1World, par2, par3, par4 + 1))) {
            return true;
        }
        if (par1World.getBlockId(par2 - 1, par3, par4) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)par1World.getBlockTileEntity(par2 - 1, par3, par4), obj);
        }
        if (par1World.getBlockId(par2 + 1, par3, par4) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)par1World.getBlockTileEntity(par2 + 1, par3, par4));
        }
        if (par1World.getBlockId(par2, par3, par4 - 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)par1World.getBlockTileEntity(par2, par3, par4 - 1), obj);
        }
        if (par1World.getBlockId(par2, par3, par4 + 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)par1World.getBlockTileEntity(par2, par3, par4 + 1));
        }
        if (par1World.isRemote) {
            return true;
        }
        par5EntityPlayer.displayGUIChest(obj);
        return true;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new TileEntityChest();
    }

    private static boolean func_50075_j(World par0World, int par1, int par2, int par3) {
        for (Entity entity : par0World.getEntitiesWithinAABB(EntityOcelot.class, AxisAlignedBB.getBoundingBoxFromPool(par1, par2 + 1, par3, par1 + 1, par2 + 2, par3 + 1))) {
            EntityOcelot entityocelot = (EntityOcelot)entity;
            if (!entityocelot.isSitting()) continue;
            return true;
        }
        return false;
    }
}

