/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockButton
extends Block {
    protected BlockButton(int par1, int par2) {
        super(par1, par2, Material.circuits);
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int i) {
        return null;
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int par4, int par5) {
        if (par5 == 2 && par1World.isBlockNormalCube(par2, par3, par4 + 1)) {
            return true;
        }
        if (par5 == 3 && par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            return true;
        }
        if (par5 == 4 && par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            return true;
        }
        return par5 == 5 && par1World.isBlockNormalCube(par2 - 1, par3, par4);
    }

    @Override
    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (par1World.isBlockNormalCube(par2 - 1, par3, par4)) {
            return true;
        }
        if (par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            return true;
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            return true;
        }
        return par1World.isBlockNormalCube(par2, par3, par4 + 1);
    }

    @Override
    public void onBlockPlaced(World par1World, int par2, int par3, int par4, int par5) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = i & 8;
        i &= 7;
        i = par5 == 2 && par1World.isBlockNormalCube(par2, par3, par4 + 1) ? 4 : (par5 == 3 && par1World.isBlockNormalCube(par2, par3, par4 - 1) ? 3 : (par5 == 4 && par1World.isBlockNormalCube(par2 + 1, par3, par4) ? 2 : (par5 == 5 && par1World.isBlockNormalCube(par2 - 1, par3, par4) ? 1 : this.getOrientation(par1World, par2, par3, par4))));
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i + j);
    }

    private int getOrientation(World par1World, int par2, int par3, int par4) {
        if (par1World.isBlockNormalCube(par2 - 1, par3, par4)) {
            return 1;
        }
        if (par1World.isBlockNormalCube(par2 + 1, par3, par4)) {
            return 2;
        }
        if (par1World.isBlockNormalCube(par2, par3, par4 - 1)) {
            return 3;
        }
        return !par1World.isBlockNormalCube(par2, par3, par4 + 1) ? 1 : 4;
    }

    @Override
    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (this.redundantCanPlaceBlockAt(par1World, par2, par3, par4)) {
            int i = par1World.getBlockMetadata(par2, par3, par4) & 7;
            boolean flag = false;
            if (!par1World.isBlockNormalCube(par2 - 1, par3, par4) && i == 1) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2 + 1, par3, par4) && i == 2) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2, par3, par4 - 1) && i == 3) {
                flag = true;
            }
            if (!par1World.isBlockNormalCube(par2, par3, par4 + 1) && i == 4) {
                flag = true;
            }
            if (flag) {
                this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
                par1World.setBlockWithNotify(par2, par3, par4, 0);
            }
        }
    }

    private boolean redundantCanPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        if (!this.canPlaceBlockAt(par1World, par2, par3, par4)) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
            par1World.setBlockWithNotify(par2, par3, par4, 0);
            return false;
        }
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int i = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        int j = i & 7;
        boolean flag = (i & 8) > 0;
        float f = 0.375f;
        float f1 = 0.625f;
        float f2 = 0.1875f;
        float f3 = 0.125f;
        if (flag) {
            f3 = 0.0625f;
        }
        if (j == 1) {
            this.setBlockBounds(0.0f, f, 0.5f - f2, f3, f1, 0.5f + f2);
        } else if (j == 2) {
            this.setBlockBounds(1.0f - f3, f, 0.5f - f2, 1.0f, f1, 0.5f + f2);
        } else if (j == 3) {
            this.setBlockBounds(0.5f - f2, f, 0.0f, 0.5f + f2, f1, f3);
        } else if (j == 4) {
            this.setBlockBounds(0.5f - f2, f, 1.0f - f3, 0.5f + f2, f1, 1.0f);
        }
    }

    @Override
    public void onBlockClicked(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        this.blockActivated(par1World, par2, par3, par4, par5EntityPlayer);
    }

    @Override
    public boolean blockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        int j = i & 7;
        int k = 8 - (i & 8);
        if (k == 0) {
            return true;
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, j + k);
        par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
        par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "random.click", 0.3f, 0.6f);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
        if (j == 1) {
            par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
        } else if (j == 2) {
            par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
        } else if (j == 3) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
        } else if (j == 4) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
        } else {
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        }
        par1World.scheduleBlockUpdate(par2, par3, par4, this.blockID, this.tickRate());
        return true;
    }

    @Override
    public void onBlockRemoval(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) > 0) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
            int j = i & 7;
            if (j == 1) {
                par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
            } else if (j == 2) {
                par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
            } else if (j == 3) {
                par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
            } else if (j == 4) {
                par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
            } else {
                par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
            }
        }
        super.onBlockRemoval(par1World, par2, par3, par4);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return (par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 8) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World par1World, int par2, int par3, int par4, int par5) {
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) == 0) {
            return false;
        }
        int j = i & 7;
        if (j == 5 && par5 == 1) {
            return true;
        }
        if (j == 4 && par5 == 2) {
            return true;
        }
        if (j == 3 && par5 == 3) {
            return true;
        }
        if (j == 2 && par5 == 4) {
            return true;
        }
        return j == 1 && par5 == 5;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.isRemote) {
            return;
        }
        int i = par1World.getBlockMetadata(par2, par3, par4);
        if ((i & 8) == 0) {
            return;
        }
        par1World.setBlockMetadataWithNotify(par2, par3, par4, i & 7);
        par1World.notifyBlocksOfNeighborChange(par2, par3, par4, this.blockID);
        int j = i & 7;
        if (j == 1) {
            par1World.notifyBlocksOfNeighborChange(par2 - 1, par3, par4, this.blockID);
        } else if (j == 2) {
            par1World.notifyBlocksOfNeighborChange(par2 + 1, par3, par4, this.blockID);
        } else if (j == 3) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 - 1, this.blockID);
        } else if (j == 4) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4 + 1, this.blockID);
        } else {
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, this.blockID);
        }
        par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "random.click", 0.3f, 0.5f);
        par1World.markBlocksDirty(par2, par3, par4, par2, par3, par4);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f = 0.1875f;
        float f1 = 0.125f;
        float f2 = 0.125f;
        this.setBlockBounds(0.5f - f, 0.5f - f1, 0.5f - f2, 0.5f + f, 0.5f + f1, 0.5f + f2);
    }
}

