/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockBed;
import net.minecraft.src.BlockBookshelf;
import net.minecraft.src.BlockBrewingStand;
import net.minecraft.src.BlockButton;
import net.minecraft.src.BlockCactus;
import net.minecraft.src.BlockCake;
import net.minecraft.src.BlockCauldron;
import net.minecraft.src.BlockChest;
import net.minecraft.src.BlockClay;
import net.minecraft.src.BlockCloth;
import net.minecraft.src.BlockCrops;
import net.minecraft.src.BlockDeadBush;
import net.minecraft.src.BlockDetectorRail;
import net.minecraft.src.BlockDirt;
import net.minecraft.src.BlockDispenser;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.BlockDragonEgg;
import net.minecraft.src.BlockEnchantmentTable;
import net.minecraft.src.BlockEndPortal;
import net.minecraft.src.BlockEndPortalFrame;
import net.minecraft.src.BlockFarmland;
import net.minecraft.src.BlockFence;
import net.minecraft.src.BlockFenceGate;
import net.minecraft.src.BlockFire;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.BlockFlowing;
import net.minecraft.src.BlockFurnace;
import net.minecraft.src.BlockGlass;
import net.minecraft.src.BlockGlowStone;
import net.minecraft.src.BlockGrass;
import net.minecraft.src.BlockGravel;
import net.minecraft.src.BlockIce;
import net.minecraft.src.BlockJukeBox;
import net.minecraft.src.BlockLadder;
import net.minecraft.src.BlockLeaves;
import net.minecraft.src.BlockLever;
import net.minecraft.src.BlockLilyPad;
import net.minecraft.src.BlockLockedChest;
import net.minecraft.src.BlockLog;
import net.minecraft.src.BlockMelon;
import net.minecraft.src.BlockMobSpawner;
import net.minecraft.src.BlockMushroom;
import net.minecraft.src.BlockMushroomCap;
import net.minecraft.src.BlockMycelium;
import net.minecraft.src.BlockNetherStalk;
import net.minecraft.src.BlockNetherrack;
import net.minecraft.src.BlockNote;
import net.minecraft.src.BlockObsidian;
import net.minecraft.src.BlockOre;
import net.minecraft.src.BlockOreStorage;
import net.minecraft.src.BlockPane;
import net.minecraft.src.BlockPistonBase;
import net.minecraft.src.BlockPistonExtension;
import net.minecraft.src.BlockPistonMoving;
import net.minecraft.src.BlockPortal;
import net.minecraft.src.BlockPressurePlate;
import net.minecraft.src.BlockPumpkin;
import net.minecraft.src.BlockRail;
import net.minecraft.src.BlockRedstoneLight;
import net.minecraft.src.BlockRedstoneOre;
import net.minecraft.src.BlockRedstoneRepeater;
import net.minecraft.src.BlockRedstoneTorch;
import net.minecraft.src.BlockRedstoneWire;
import net.minecraft.src.BlockReed;
import net.minecraft.src.BlockSand;
import net.minecraft.src.BlockSandStone;
import net.minecraft.src.BlockSapling;
import net.minecraft.src.BlockSign;
import net.minecraft.src.BlockSilverfish;
import net.minecraft.src.BlockSnow;
import net.minecraft.src.BlockSnowBlock;
import net.minecraft.src.BlockSoulSand;
import net.minecraft.src.BlockSponge;
import net.minecraft.src.BlockStairs;
import net.minecraft.src.BlockStationary;
import net.minecraft.src.BlockStem;
import net.minecraft.src.BlockStep;
import net.minecraft.src.BlockStone;
import net.minecraft.src.BlockStoneBrick;
import net.minecraft.src.BlockTNT;
import net.minecraft.src.BlockTallGrass;
import net.minecraft.src.BlockTorch;
import net.minecraft.src.BlockTrapDoor;
import net.minecraft.src.BlockVine;
import net.minecraft.src.BlockWeb;
import net.minecraft.src.BlockWood;
import net.minecraft.src.BlockWorkbench;
import net.minecraft.src.EnchantmentHelper;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMobType;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemCloth;
import net.minecraft.src.ItemColored;
import net.minecraft.src.ItemLeaves;
import net.minecraft.src.ItemLilyPad;
import net.minecraft.src.ItemMetadata;
import net.minecraft.src.ItemPiston;
import net.minecraft.src.ItemSapling;
import net.minecraft.src.ItemSlab;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StatList;
import net.minecraft.src.StepSound;
import net.minecraft.src.StepSoundSand;
import net.minecraft.src.StepSoundStone;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class Block {
    public static final StepSound soundPowderFootstep = new StepSound("stone", 1.0f, 1.0f);
    public static final StepSound soundWoodFootstep = new StepSound("wood", 1.0f, 1.0f);
    public static final StepSound soundGravelFootstep = new StepSound("gravel", 1.0f, 1.0f);
    public static final StepSound soundGrassFootstep = new StepSound("grass", 1.0f, 1.0f);
    public static final StepSound soundStoneFootstep = new StepSound("stone", 1.0f, 1.0f);
    public static final StepSound soundMetalFootstep = new StepSound("stone", 1.0f, 1.5f);
    public static final StepSound soundGlassFootstep = new StepSoundStone("stone", 1.0f, 1.0f);
    public static final StepSound soundClothFootstep = new StepSound("cloth", 1.0f, 1.0f);
    public static final StepSound soundSandFootstep = new StepSoundSand("sand", 1.0f, 1.0f);
    public static final Block[] blocksList = new Block[4096];
    public static final boolean[] opaqueCubeLookup = new boolean[4096];
    public static final int[] lightOpacity = new int[4096];
    public static final boolean[] canBlockGrass = new boolean[4096];
    public static final int[] lightValue = new int[4096];
    public static final boolean[] requiresSelfNotify = new boolean[4096];
    public static boolean[] useNeighborBrightness = new boolean[4096];
    public static final Block stone = new BlockStone(1, 1).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stone");
    public static final BlockGrass grass = (BlockGrass)new BlockGrass(2).setHardness(0.6f).setStepSound(soundGrassFootstep).setBlockName("grass");
    public static final Block dirt = new BlockDirt(3, 2).setHardness(0.5f).setStepSound(soundGravelFootstep).setBlockName("dirt");
    public static final Block cobblestone = new Block(4, 16, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stonebrick");
    public static final Block planks = new BlockWood(5).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setBlockName("wood").setRequiresSelfNotify();
    public static final Block sapling = new BlockSapling(6, 15).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("sapling").setRequiresSelfNotify();
    public static final Block bedrock = new Block(7, 17, Material.rock).setBlockUnbreakable().setResistance(6000000.0f).setStepSound(soundStoneFootstep).setBlockName("bedrock").disableStats();
    public static final Block waterMoving = new BlockFlowing(8, Material.water).setHardness(100.0f).setLightOpacity(3).setBlockName("water").disableStats().setRequiresSelfNotify();
    public static final Block waterStill = new BlockStationary(9, Material.water).setHardness(100.0f).setLightOpacity(3).setBlockName("water").disableStats().setRequiresSelfNotify();
    public static final Block lavaMoving = new BlockFlowing(10, Material.lava).setHardness(0.0f).setLightValue(1.0f).setLightOpacity(255).setBlockName("lava").disableStats().setRequiresSelfNotify();
    public static final Block lavaStill = new BlockStationary(11, Material.lava).setHardness(100.0f).setLightValue(1.0f).setLightOpacity(255).setBlockName("lava").disableStats().setRequiresSelfNotify();
    public static final Block sand = new BlockSand(12, 18).setHardness(0.5f).setStepSound(soundSandFootstep).setBlockName("sand");
    public static final Block gravel = new BlockGravel(13, 19).setHardness(0.6f).setStepSound(soundGravelFootstep).setBlockName("gravel");
    public static final Block oreGold = new BlockOre(14, 32).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreGold");
    public static final Block oreIron = new BlockOre(15, 33).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreIron");
    public static final Block oreCoal = new BlockOre(16, 34).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreCoal");
    public static final Block wood = new BlockLog(17).setHardness(2.0f).setStepSound(soundWoodFootstep).setBlockName("log").setRequiresSelfNotify();
    public static final BlockLeaves leaves = (BlockLeaves)new BlockLeaves(18, 52).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).setBlockName("leaves").setRequiresSelfNotify();
    public static final Block sponge = new BlockSponge(19).setHardness(0.6f).setStepSound(soundGrassFootstep).setBlockName("sponge");
    public static final Block glass = new BlockGlass(20, 49, Material.glass, false).setHardness(0.3f).setStepSound(soundGlassFootstep).setBlockName("glass");
    public static final Block oreLapis = new BlockOre(21, 160).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreLapis");
    public static final Block blockLapis = new Block(22, 144, Material.rock).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("blockLapis");
    public static final Block dispenser = new BlockDispenser(23).setHardness(3.5f).setStepSound(soundStoneFootstep).setBlockName("dispenser").setRequiresSelfNotify();
    public static final Block sandStone = new BlockSandStone(24).setStepSound(soundStoneFootstep).setHardness(0.8f).setBlockName("sandStone").setRequiresSelfNotify();
    public static final Block music = new BlockNote(25).setHardness(0.8f).setBlockName("musicBlock").setRequiresSelfNotify();
    public static final Block bed = new BlockBed(26).setHardness(0.2f).setBlockName("bed").disableStats().setRequiresSelfNotify();
    public static final Block railPowered = new BlockRail(27, 179, true).setHardness(0.7f).setStepSound(soundMetalFootstep).setBlockName("goldenRail").setRequiresSelfNotify();
    public static final Block railDetector = new BlockDetectorRail(28, 195).setHardness(0.7f).setStepSound(soundMetalFootstep).setBlockName("detectorRail").setRequiresSelfNotify();
    public static final Block pistonStickyBase = new BlockPistonBase(29, 106, true).setBlockName("pistonStickyBase").setRequiresSelfNotify();
    public static final Block web = new BlockWeb(30, 11).setLightOpacity(1).setHardness(4.0f).setBlockName("web");
    public static final BlockTallGrass tallGrass = (BlockTallGrass)new BlockTallGrass(31, 39).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("tallgrass");
    public static final BlockDeadBush deadBush = (BlockDeadBush)new BlockDeadBush(32, 55).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("deadbush");
    public static final Block pistonBase = new BlockPistonBase(33, 107, false).setBlockName("pistonBase").setRequiresSelfNotify();
    public static final BlockPistonExtension pistonExtension = (BlockPistonExtension)new BlockPistonExtension(34, 107).setRequiresSelfNotify();
    public static final Block cloth = new BlockCloth().setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth").setRequiresSelfNotify();
    public static final BlockPistonMoving pistonMoving = new BlockPistonMoving(36);
    public static final BlockFlower plantYellow = (BlockFlower)new BlockFlower(37, 13).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("flower");
    public static final BlockFlower plantRed = (BlockFlower)new BlockFlower(38, 12).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("rose");
    public static final BlockFlower mushroomBrown = (BlockFlower)new BlockMushroom(39, 29).setHardness(0.0f).setStepSound(soundGrassFootstep).setLightValue(0.125f).setBlockName("mushroom");
    public static final BlockFlower mushroomRed = (BlockFlower)new BlockMushroom(40, 28).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("mushroom");
    public static final Block blockGold = new BlockOreStorage(41, 23).setHardness(3.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setBlockName("blockGold");
    public static final Block blockSteel = new BlockOreStorage(42, 22).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setBlockName("blockIron");
    public static final Block stairDouble = new BlockStep(43, true).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stoneSlab");
    public static final Block stairSingle = new BlockStep(44, false).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stoneSlab");
    public static final Block brick = new Block(45, 7, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("brick");
    public static final Block tnt = new BlockTNT(46, 8).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("tnt");
    public static final Block bookShelf = new BlockBookshelf(47, 35).setHardness(1.5f).setStepSound(soundWoodFootstep).setBlockName("bookshelf");
    public static final Block cobblestoneMossy = new Block(48, 36, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stoneMoss");
    public static final Block obsidian = new BlockObsidian(49, 37).setHardness(50.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep).setBlockName("obsidian");
    public static final Block torchWood = new BlockTorch(50, 80).setHardness(0.0f).setLightValue(0.9375f).setStepSound(soundWoodFootstep).setBlockName("torch").setRequiresSelfNotify();
    public static final BlockFire fire = (BlockFire)new BlockFire(51, 31).setHardness(0.0f).setLightValue(1.0f).setStepSound(soundWoodFootstep).setBlockName("fire").disableStats();
    public static final Block mobSpawner = new BlockMobSpawner(52, 65).setHardness(5.0f).setStepSound(soundMetalFootstep).setBlockName("mobSpawner").disableStats();
    public static final Block stairCompactPlanks = new BlockStairs(53, planks).setBlockName("stairsWood").setRequiresSelfNotify();
    public static final Block chest = new BlockChest(54).setHardness(2.5f).setStepSound(soundWoodFootstep).setBlockName("chest").setRequiresSelfNotify();
    public static final Block redstoneWire = new BlockRedstoneWire(55, 164).setHardness(0.0f).setStepSound(soundPowderFootstep).setBlockName("redstoneDust").disableStats().setRequiresSelfNotify();
    public static final Block oreDiamond = new BlockOre(56, 50).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreDiamond");
    public static final Block blockDiamond = new BlockOreStorage(57, 24).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setBlockName("blockDiamond");
    public static final Block workbench = new BlockWorkbench(58).setHardness(2.5f).setStepSound(soundWoodFootstep).setBlockName("workbench");
    public static final Block crops = new BlockCrops(59, 88).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("crops").disableStats().setRequiresSelfNotify();
    public static final Block tilledField = new BlockFarmland(60).setHardness(0.6f).setStepSound(soundGravelFootstep).setBlockName("farmland").setRequiresSelfNotify();
    public static final Block stoneOvenIdle = new BlockFurnace(61, false).setHardness(3.5f).setStepSound(soundStoneFootstep).setBlockName("furnace").setRequiresSelfNotify();
    public static final Block stoneOvenActive = new BlockFurnace(62, true).setHardness(3.5f).setStepSound(soundStoneFootstep).setLightValue(0.875f).setBlockName("furnace").setRequiresSelfNotify();
    public static final Block signPost = new BlockSign(63, TileEntitySign.class, true).setHardness(1.0f).setStepSound(soundWoodFootstep).setBlockName("sign").disableStats().setRequiresSelfNotify();
    public static final Block doorWood = new BlockDoor(64, Material.wood).setHardness(3.0f).setStepSound(soundWoodFootstep).setBlockName("doorWood").disableStats().setRequiresSelfNotify();
    public static final Block ladder = new BlockLadder(65, 83).setHardness(0.4f).setStepSound(soundWoodFootstep).setBlockName("ladder").setRequiresSelfNotify();
    public static final Block rail = new BlockRail(66, 128, false).setHardness(0.7f).setStepSound(soundMetalFootstep).setBlockName("rail").setRequiresSelfNotify();
    public static final Block stairCompactCobblestone = new BlockStairs(67, cobblestone).setBlockName("stairsStone").setRequiresSelfNotify();
    public static final Block signWall = new BlockSign(68, TileEntitySign.class, false).setHardness(1.0f).setStepSound(soundWoodFootstep).setBlockName("sign").disableStats().setRequiresSelfNotify();
    public static final Block lever = new BlockLever(69, 96).setHardness(0.5f).setStepSound(soundWoodFootstep).setBlockName("lever").setRequiresSelfNotify();
    public static final Block pressurePlateStone = new BlockPressurePlate(70, Block.stone.blockIndexInTexture, EnumMobType.mobs, Material.rock).setHardness(0.5f).setStepSound(soundStoneFootstep).setBlockName("pressurePlate").setRequiresSelfNotify();
    public static final Block doorSteel = new BlockDoor(71, Material.iron).setHardness(5.0f).setStepSound(soundMetalFootstep).setBlockName("doorIron").disableStats().setRequiresSelfNotify();
    public static final Block pressurePlatePlanks = new BlockPressurePlate(72, Block.planks.blockIndexInTexture, EnumMobType.everything, Material.wood).setHardness(0.5f).setStepSound(soundWoodFootstep).setBlockName("pressurePlate").setRequiresSelfNotify();
    public static final Block oreRedstone = new BlockRedstoneOre(73, 51, false).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreRedstone").setRequiresSelfNotify();
    public static final Block oreRedstoneGlowing = new BlockRedstoneOre(74, 51, true).setLightValue(0.625f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreRedstone").setRequiresSelfNotify();
    public static final Block torchRedstoneIdle = new BlockRedstoneTorch(75, 115, false).setHardness(0.0f).setStepSound(soundWoodFootstep).setBlockName("notGate").setRequiresSelfNotify();
    public static final Block torchRedstoneActive = new BlockRedstoneTorch(76, 99, true).setHardness(0.0f).setLightValue(0.5f).setStepSound(soundWoodFootstep).setBlockName("notGate").setRequiresSelfNotify();
    public static final Block button = new BlockButton(77, Block.stone.blockIndexInTexture).setHardness(0.5f).setStepSound(soundStoneFootstep).setBlockName("button").setRequiresSelfNotify();
    public static final Block snow = new BlockSnow(78, 66).setHardness(0.1f).setStepSound(soundClothFootstep).setBlockName("snow").setLightOpacity(0);
    public static final Block ice = new BlockIce(79, 67).setHardness(0.5f).setLightOpacity(3).setStepSound(soundGlassFootstep).setBlockName("ice");
    public static final Block blockSnow = new BlockSnowBlock(80, 66).setHardness(0.2f).setStepSound(soundClothFootstep).setBlockName("snow");
    public static final Block cactus = new BlockCactus(81, 70).setHardness(0.4f).setStepSound(soundClothFootstep).setBlockName("cactus");
    public static final Block blockClay = new BlockClay(82, 72).setHardness(0.6f).setStepSound(soundGravelFootstep).setBlockName("clay");
    public static final Block reed = new BlockReed(83, 73).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("reeds").disableStats();
    public static final Block jukebox = new BlockJukeBox(84, 74).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("jukebox").setRequiresSelfNotify();
    public static final Block fence = new BlockFence(85, 4).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setBlockName("fence");
    public static final Block pumpkin = new BlockPumpkin(86, 102, false).setHardness(1.0f).setStepSound(soundWoodFootstep).setBlockName("pumpkin").setRequiresSelfNotify();
    public static final Block netherrack = new BlockNetherrack(87, 103).setHardness(0.4f).setStepSound(soundStoneFootstep).setBlockName("hellrock");
    public static final Block slowSand = new BlockSoulSand(88, 104).setHardness(0.5f).setStepSound(soundSandFootstep).setBlockName("hellsand");
    public static final Block glowStone = new BlockGlowStone(89, 105, Material.glass).setHardness(0.3f).setStepSound(soundGlassFootstep).setLightValue(1.0f).setBlockName("lightgem");
    public static final BlockPortal portal = (BlockPortal)new BlockPortal(90, 14).setHardness(-1.0f).setStepSound(soundGlassFootstep).setLightValue(0.75f).setBlockName("portal");
    public static final Block pumpkinLantern = new BlockPumpkin(91, 102, true).setHardness(1.0f).setStepSound(soundWoodFootstep).setLightValue(1.0f).setBlockName("litpumpkin").setRequiresSelfNotify();
    public static final Block cake = new BlockCake(92, 121).setHardness(0.5f).setStepSound(soundClothFootstep).setBlockName("cake").disableStats().setRequiresSelfNotify();
    public static final Block redstoneRepeaterIdle = new BlockRedstoneRepeater(93, false).setHardness(0.0f).setStepSound(soundWoodFootstep).setBlockName("diode").disableStats().setRequiresSelfNotify();
    public static final Block redstoneRepeaterActive = new BlockRedstoneRepeater(94, true).setHardness(0.0f).setLightValue(0.625f).setStepSound(soundWoodFootstep).setBlockName("diode").disableStats().setRequiresSelfNotify();
    public static final Block lockedChest = new BlockLockedChest(95).setHardness(0.0f).setLightValue(1.0f).setStepSound(soundWoodFootstep).setBlockName("lockedchest").setTickRandomly(true).setRequiresSelfNotify();
    public static final Block trapdoor = new BlockTrapDoor(96, Material.wood).setHardness(3.0f).setStepSound(soundWoodFootstep).setBlockName("trapdoor").disableStats().setRequiresSelfNotify();
    public static final Block silverfish = new BlockSilverfish(97).setHardness(0.75f);
    public static final Block stoneBrick = new BlockStoneBrick(98).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stonebricksmooth");
    public static final Block mushroomCapBrown = new BlockMushroomCap(99, Material.wood, 142, 0).setHardness(0.2f).setStepSound(soundWoodFootstep).setBlockName("mushroom").setRequiresSelfNotify();
    public static final Block mushroomCapRed = new BlockMushroomCap(100, Material.wood, 142, 1).setHardness(0.2f).setStepSound(soundWoodFootstep).setBlockName("mushroom").setRequiresSelfNotify();
    public static final Block fenceIron = new BlockPane(101, 85, 85, Material.iron, true).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setBlockName("fenceIron");
    public static final Block thinGlass = new BlockPane(102, 49, 148, Material.glass, false).setHardness(0.3f).setStepSound(soundGlassFootstep).setBlockName("thinGlass");
    public static final Block melon = new BlockMelon(103).setHardness(1.0f).setStepSound(soundWoodFootstep).setBlockName("melon");
    public static final Block pumpkinStem = new BlockStem(104, pumpkin).setHardness(0.0f).setStepSound(soundWoodFootstep).setBlockName("pumpkinStem").setRequiresSelfNotify();
    public static final Block melonStem = new BlockStem(105, melon).setHardness(0.0f).setStepSound(soundWoodFootstep).setBlockName("pumpkinStem").setRequiresSelfNotify();
    public static final Block vine = new BlockVine(106).setHardness(0.2f).setStepSound(soundGrassFootstep).setBlockName("vine").setRequiresSelfNotify();
    public static final Block fenceGate = new BlockFenceGate(107, 4).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setBlockName("fenceGate").setRequiresSelfNotify();
    public static final Block stairsBrick = new BlockStairs(108, brick).setBlockName("stairsBrick").setRequiresSelfNotify();
    public static final Block stairsStoneBrickSmooth = new BlockStairs(109, stoneBrick).setBlockName("stairsStoneBrickSmooth").setRequiresSelfNotify();
    public static final BlockMycelium mycelium = (BlockMycelium)new BlockMycelium(110).setHardness(0.6f).setStepSound(soundGrassFootstep).setBlockName("mycel");
    public static final Block waterlily = new BlockLilyPad(111, 76).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("waterlily");
    public static final Block netherBrick = new Block(112, 224, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("netherBrick");
    public static final Block netherFence = new BlockFence(113, 224, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("netherFence");
    public static final Block stairsNetherBrick = new BlockStairs(114, netherBrick).setBlockName("stairsNetherBrick").setRequiresSelfNotify();
    public static final Block netherStalk = new BlockNetherStalk(115).setBlockName("netherStalk").setRequiresSelfNotify();
    public static final Block enchantmentTable = new BlockEnchantmentTable(116).setHardness(5.0f).setResistance(2000.0f).setBlockName("enchantmentTable");
    public static final Block brewingStand = new BlockBrewingStand(117).setHardness(0.5f).setLightValue(0.125f).setBlockName("brewingStand").setRequiresSelfNotify();
    public static final Block cauldron = new BlockCauldron(118).setHardness(2.0f).setBlockName("cauldron").setRequiresSelfNotify();
    public static final Block endPortal = new BlockEndPortal(119, Material.portal).setHardness(-1.0f).setResistance(6000000.0f);
    public static final Block endPortalFrame = new BlockEndPortalFrame(120).setStepSound(soundGlassFootstep).setLightValue(0.125f).setHardness(-1.0f).setBlockName("endPortalFrame").setRequiresSelfNotify().setResistance(6000000.0f);
    public static final Block whiteStone = new Block(121, 175, Material.rock).setHardness(3.0f).setResistance(15.0f).setStepSound(soundStoneFootstep).setBlockName("whiteStone");
    public static final Block dragonEgg = new BlockDragonEgg(122, 167).setHardness(3.0f).setResistance(15.0f).setStepSound(soundStoneFootstep).setLightValue(0.125f).setBlockName("dragonEgg");
    public static final Block redstoneLampIdle = new BlockRedstoneLight(123, false).setHardness(0.3f).setStepSound(soundGlassFootstep).setBlockName("redstoneLight");
    public static final Block redstoneLampActive = new BlockRedstoneLight(124, true).setHardness(0.3f).setStepSound(soundGlassFootstep).setBlockName("redstoneLight");
    public int blockIndexInTexture;
    public final int blockID;
    protected float blockHardness;
    protected float blockResistance;
    protected boolean blockConstructorCalled = true;
    protected boolean enableStats = true;
    protected boolean needsRandomTick;
    protected boolean isBlockContainer;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public StepSound stepSound = soundPowderFootstep;
    public float blockParticleGravity = 1.0f;
    public final Material blockMaterial;
    public float slipperiness = 0.6f;
    private String blockName;

    protected Block(int par1, Material par2Material) {
        if (blocksList[par1] != null) {
            throw new IllegalArgumentException("Slot " + par1 + " is already occupied by " + blocksList[par1] + " when adding " + this);
        }
        this.blockMaterial = par2Material;
        Block.blocksList[par1] = this;
        this.blockID = par1;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.opaqueCubeLookup[par1] = this.isOpaqueCube();
        Block.lightOpacity[par1] = this.isOpaqueCube() ? 255 : 0;
        Block.canBlockGrass[par1] = !par2Material.getCanBlockGrass();
    }

    protected Block setRequiresSelfNotify() {
        Block.requiresSelfNotify[this.blockID] = true;
        return this;
    }

    protected void initializeBlock() {
    }

    protected Block(int par1, int par2, Material par3Material) {
        this(par1, par3Material);
        this.blockIndexInTexture = par2;
    }

    protected Block setStepSound(StepSound par1StepSound) {
        this.stepSound = par1StepSound;
        return this;
    }

    protected Block setLightOpacity(int par1) {
        Block.lightOpacity[this.blockID] = par1;
        return this;
    }

    protected Block setLightValue(float par1) {
        Block.lightValue[this.blockID] = (int)(15.0f * par1);
        return this;
    }

    protected Block setResistance(float par1) {
        this.blockResistance = par1 * 3.0f;
        return this;
    }

    public static boolean isNormalCube(int par0) {
        Block block = blocksList[par0];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.isOpaque() && block.renderAsNormalBlock();
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return !this.blockMaterial.blocksMovement();
    }

    public int getRenderType() {
        return 0;
    }

    protected Block setHardness(float par1) {
        this.blockHardness = par1;
        if (this.blockResistance < par1 * 5.0f) {
            this.blockResistance = par1 * 5.0f;
        }
        return this;
    }

    protected Block setBlockUnbreakable() {
        this.setHardness(-1.0f);
        return this;
    }

    public float getHardness() {
        return this.blockHardness;
    }

    protected Block setTickRandomly(boolean par1) {
        this.needsRandomTick = par1;
        return this;
    }

    public boolean getTickRandomly() {
        return this.needsRandomTick;
    }

    public boolean hasTileEntity() {
        return this.isBlockContainer;
    }

    public void setBlockBounds(float par1, float par2, float par3, float par4, float par5, float par6) {
        this.minX = par1;
        this.minY = par2;
        this.minZ = par3;
        this.maxX = par4;
        this.maxY = par5;
        this.maxZ = par6;
    }

    public float getBlockBrightness(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.getBrightness(par2, par3, par4, lightValue[this.blockID]);
    }

    public int getMixedBrightnessForBlock(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.getLightBrightnessForSkyBlocks(par2, par3, par4, lightValue[this.blockID]);
    }

    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (par5 == 0 && this.minY > 0.0) {
            return true;
        }
        if (par5 == 1 && this.maxY < 1.0) {
            return true;
        }
        if (par5 == 2 && this.minZ > 0.0) {
            return true;
        }
        if (par5 == 3 && this.maxZ < 1.0) {
            return true;
        }
        if (par5 == 4 && this.minX > 0.0) {
            return true;
        }
        if (par5 == 5 && this.maxX < 1.0) {
            return true;
        }
        return !par1IBlockAccess.isBlockOpaqueCube(par2, par3, par4);
    }

    public boolean isBlockSolid(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return par1IBlockAccess.getBlockMaterial(par2, par3, par4).isSolid();
    }

    public int getBlockTexture(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this.getBlockTextureFromSideAndMetadata(par5, par1IBlockAccess.getBlockMetadata(par2, par3, par4));
    }

    public int getBlockTextureFromSideAndMetadata(int par1, int par2) {
        return this.getBlockTextureFromSide(par1);
    }

    public int getBlockTextureFromSide(int par1) {
        return this.blockIndexInTexture;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)par2 + this.minX, (double)par3 + this.minY, (double)par4 + this.minZ, (double)par2 + this.maxX, (double)par3 + this.maxY, (double)par4 + this.maxZ);
    }

    public void getCollidingBoundingBoxes(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, ArrayList par6ArrayList) {
        AxisAlignedBB axisalignedbb = this.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
        if (axisalignedbb != null && par5AxisAlignedBB.intersectsWith(axisalignedbb)) {
            par6ArrayList.add(axisalignedbb);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)par2 + this.minX, (double)par3 + this.minY, (double)par4 + this.minZ, (double)par2 + this.maxX, (double)par3 + this.maxY, (double)par4 + this.maxZ);
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean canCollideCheck(int par1, boolean par2) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
    }

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
    }

    public int tickRate() {
        return 10;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
    }

    public int quantityDropped(Random par1Random) {
        return 1;
    }

    public int idDropped(int par1, Random par2Random, int par3) {
        return this.blockID;
    }

    public float blockStrength(EntityPlayer par1EntityPlayer) {
        if (this.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!par1EntityPlayer.canHarvestBlock(this)) {
            return 1.0f / this.blockHardness / 100.0f;
        }
        return par1EntityPlayer.getCurrentPlayerStrVsBlock(this) / this.blockHardness / 30.0f;
    }

    public final void dropBlockAsItem(World par1World, int par2, int par3, int par4, int par5, int par6) {
        this.dropBlockAsItemWithChance(par1World, par2, par3, par4, par5, 1.0f, par6);
    }

    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (par1World.isRemote) {
            return;
        }
        int i = this.quantityDroppedWithBonus(par7, par1World.rand);
        for (int j = 0; j < i; ++j) {
            int k;
            if (par1World.rand.nextFloat() > par6 || (k = this.idDropped(par5, par1World.rand, par7)) <= 0) continue;
            this.dropBlockAsItem_do(par1World, par2, par3, par4, new ItemStack(k, 1, this.damageDropped(par5)));
        }
    }

    protected void dropBlockAsItem_do(World par1World, int par2, int par3, int par4, ItemStack par5ItemStack) {
        if (par1World.isRemote) {
            return;
        }
        float f = 0.7f;
        double d = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(par1World, (double)par2 + d, (double)par3 + d1, (double)par4 + d2, par5ItemStack);
        entityitem.delayBeforeCanPickup = 10;
        par1World.spawnEntityInWorld(entityitem);
    }

    protected int damageDropped(int par1) {
        return 0;
    }

    public float getExplosionResistance(Entity par1Entity) {
        return this.blockResistance / 5.0f;
    }

    public MovingObjectPosition collisionRayTrace(World par1World, int par2, int par3, int par4, Vec3D par5Vec3D, Vec3D par6Vec3D) {
        this.setBlockBoundsBasedOnState(par1World, par2, par3, par4);
        par5Vec3D = par5Vec3D.addVector(-par2, -par3, -par4);
        par6Vec3D = par6Vec3D.addVector(-par2, -par3, -par4);
        Vec3D vec3d = par5Vec3D.getIntermediateWithXValue(par6Vec3D, this.minX);
        Vec3D vec3d1 = par5Vec3D.getIntermediateWithXValue(par6Vec3D, this.maxX);
        Vec3D vec3d2 = par5Vec3D.getIntermediateWithYValue(par6Vec3D, this.minY);
        Vec3D vec3d3 = par5Vec3D.getIntermediateWithYValue(par6Vec3D, this.maxY);
        Vec3D vec3d4 = par5Vec3D.getIntermediateWithZValue(par6Vec3D, this.minZ);
        Vec3D vec3d5 = par5Vec3D.getIntermediateWithZValue(par6Vec3D, this.maxZ);
        if (!this.isVecInsideYZBounds(vec3d)) {
            vec3d = null;
        }
        if (!this.isVecInsideYZBounds(vec3d1)) {
            vec3d1 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d5)) {
            vec3d5 = null;
        }
        Vec3D vec3d6 = null;
        if (vec3d != null && (vec3d6 == null || par5Vec3D.distanceTo(vec3d) < par5Vec3D.distanceTo(vec3d6))) {
            vec3d6 = vec3d;
        }
        if (vec3d1 != null && (vec3d6 == null || par5Vec3D.distanceTo(vec3d1) < par5Vec3D.distanceTo(vec3d6))) {
            vec3d6 = vec3d1;
        }
        if (vec3d2 != null && (vec3d6 == null || par5Vec3D.distanceTo(vec3d2) < par5Vec3D.distanceTo(vec3d6))) {
            vec3d6 = vec3d2;
        }
        if (vec3d3 != null && (vec3d6 == null || par5Vec3D.distanceTo(vec3d3) < par5Vec3D.distanceTo(vec3d6))) {
            vec3d6 = vec3d3;
        }
        if (vec3d4 != null && (vec3d6 == null || par5Vec3D.distanceTo(vec3d4) < par5Vec3D.distanceTo(vec3d6))) {
            vec3d6 = vec3d4;
        }
        if (vec3d5 != null && (vec3d6 == null || par5Vec3D.distanceTo(vec3d5) < par5Vec3D.distanceTo(vec3d6))) {
            vec3d6 = vec3d5;
        }
        if (vec3d6 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d6 == vec3d) {
            byte0 = 4;
        }
        if (vec3d6 == vec3d1) {
            byte0 = 5;
        }
        if (vec3d6 == vec3d2) {
            byte0 = 0;
        }
        if (vec3d6 == vec3d3) {
            byte0 = 1;
        }
        if (vec3d6 == vec3d4) {
            byte0 = 2;
        }
        if (vec3d6 == vec3d5) {
            byte0 = 3;
        }
        return new MovingObjectPosition(par2, par3, par4, byte0, vec3d6.addVector(par2, par3, par4));
    }

    private boolean isVecInsideYZBounds(Vec3D par1Vec3D) {
        if (par1Vec3D == null) {
            return false;
        }
        return par1Vec3D.yCoord >= this.minY && par1Vec3D.yCoord <= this.maxY && par1Vec3D.zCoord >= this.minZ && par1Vec3D.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3D par1Vec3D) {
        if (par1Vec3D == null) {
            return false;
        }
        return par1Vec3D.xCoord >= this.minX && par1Vec3D.xCoord <= this.maxX && par1Vec3D.zCoord >= this.minZ && par1Vec3D.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3D par1Vec3D) {
        if (par1Vec3D == null) {
            return false;
        }
        return par1Vec3D.xCoord >= this.minX && par1Vec3D.xCoord <= this.maxX && par1Vec3D.yCoord >= this.minY && par1Vec3D.yCoord <= this.maxY;
    }

    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int par4, int par5) {
        return this.canPlaceBlockAt(par1World, par2, par3, par4);
    }

    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        int i = par1World.getBlockId(par2, par3, par4);
        return i == 0 || Block.blocksList[i].blockMaterial.isGroundCover();
    }

    public boolean blockActivated(World par1World, int par2, int par3, int i, EntityPlayer entityplayer) {
        return false;
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
    }

    public void onBlockPlaced(World world, int i, int j, int k, int l) {
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
    }

    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
    }

    public int getBlockColor() {
        return 0xFFFFFF;
    }

    public int getRenderColor(int par1) {
        return 0xFFFFFF;
    }

    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return 0xFFFFFF;
    }

    public boolean isPoweringTo(IBlockAccess par1IBlockAccess, int par2, int par3, int i, int j) {
        return false;
    }

    public boolean canProvidePower() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
    }

    public boolean isIndirectlyPoweringTo(World par1World, int par2, int par3, int i, int j) {
        return false;
    }

    public void setBlockBoundsForItemRender() {
    }

    public void harvestBlock(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        par2EntityPlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
        par2EntityPlayer.addExhaustion(0.025f);
        if (this.canSilkHarvest() && EnchantmentHelper.getSilkTouchModifier(par2EntityPlayer.inventory)) {
            ItemStack itemstack = this.createStackedBlock(par6);
            if (itemstack != null) {
                this.dropBlockAsItem_do(par1World, par3, par4, par5, itemstack);
            }
        } else {
            int i = EnchantmentHelper.getFortuneModifier(par2EntityPlayer.inventory);
            this.dropBlockAsItem(par1World, par3, par4, par5, par6, i);
        }
    }

    protected boolean canSilkHarvest() {
        return this.renderAsNormalBlock() && !this.isBlockContainer;
    }

    protected ItemStack createStackedBlock(int par1) {
        int i = 0;
        if (this.blockID >= 0 && this.blockID < Item.itemsList.length && Item.itemsList[this.blockID].getHasSubtypes()) {
            i = par1;
        }
        return new ItemStack(this.blockID, 1, i);
    }

    public int quantityDroppedWithBonus(int par1, Random par2Random) {
        return this.quantityDropped(par2Random);
    }

    public boolean canBlockStay(World par1World, int par2, int par3, int i) {
        return true;
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
    }

    public Block setBlockName(String par1Str) {
        this.blockName = "tile." + par1Str;
        return this;
    }

    public String translateBlockName() {
        return StatCollector.translateToLocal(this.getBlockName() + ".name");
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void powerBlock(World world, int i, int j, int k, int l, int i1) {
    }

    public boolean getEnableStats() {
        return this.enableStats;
    }

    protected Block disableStats() {
        this.enableStats = false;
        return this;
    }

    public int getMobilityFlag() {
        return this.blockMaterial.getMaterialMobility();
    }

    public float getAmbientOcclusionLightValue(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.isBlockNormalCube(par2, par3, par4) ? 0.2f : 1.0f;
    }

    public void onFallenUpon(World world, int i, int j, int k, Entity entity, float f) {
    }

    static {
        Item.itemsList[Block.cloth.blockID] = new ItemCloth(Block.cloth.blockID - 256).setItemName("cloth");
        Item.itemsList[Block.wood.blockID] = new ItemMetadata(Block.wood.blockID - 256, wood).setItemName("log");
        Item.itemsList[Block.planks.blockID] = new ItemMetadata(Block.planks.blockID - 256, planks).setItemName("wood");
        Item.itemsList[Block.stoneBrick.blockID] = new ItemMetadata(Block.stoneBrick.blockID - 256, stoneBrick).setItemName("stonebricksmooth");
        Item.itemsList[Block.sandStone.blockID] = new ItemMetadata(Block.sandStone.blockID - 256, sandStone).setItemName("sandStone");
        Item.itemsList[Block.stairSingle.blockID] = new ItemSlab(Block.stairSingle.blockID - 256).setItemName("stoneSlab");
        Item.itemsList[Block.sapling.blockID] = new ItemSapling(Block.sapling.blockID - 256).setItemName("sapling");
        Item.itemsList[Block.leaves.blockID] = new ItemLeaves(Block.leaves.blockID - 256).setItemName("leaves");
        Item.itemsList[Block.vine.blockID] = new ItemColored(Block.vine.blockID - 256, false);
        Item.itemsList[Block.tallGrass.blockID] = new ItemColored(Block.tallGrass.blockID - 256, true).setBlockNames(new String[]{"shrub", "grass", "fern"});
        Item.itemsList[Block.waterlily.blockID] = new ItemLilyPad(Block.waterlily.blockID - 256);
        Item.itemsList[Block.pistonBase.blockID] = new ItemPiston(Block.pistonBase.blockID - 256);
        Item.itemsList[Block.pistonStickyBase.blockID] = new ItemPiston(Block.pistonStickyBase.blockID - 256);
        for (int i = 0; i < 256; ++i) {
            if (blocksList[i] == null) continue;
            if (Item.itemsList[i] == null) {
                Item.itemsList[i] = new ItemBlock(i - 256);
                blocksList[i].initializeBlock();
            }
            boolean flag = false;
            if (i > 0 && blocksList[i].getRenderType() == 10) {
                flag = true;
            }
            if (i > 0 && blocksList[i] instanceof BlockStep) {
                flag = true;
            }
            if (i == Block.tilledField.blockID) {
                flag = true;
            }
            if (canBlockGrass[i]) {
                flag = true;
            }
            Block.useNeighborBrightness[i] = flag;
        }
        Block.canBlockGrass[0] = true;
        StatList.initBreakableStats();
    }
}

