/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenBigMushroom;
import net.minecraft.src.WorldGenCactus;
import net.minecraft.src.WorldGenClay;
import net.minecraft.src.WorldGenDeadBush;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenLiquids;
import net.minecraft.src.WorldGenMinable;
import net.minecraft.src.WorldGenPumpkin;
import net.minecraft.src.WorldGenReed;
import net.minecraft.src.WorldGenSand;
import net.minecraft.src.WorldGenWaterlily;
import net.minecraft.src.WorldGenerator;

public class BiomeDecorator {
    protected World currentWorld;
    protected Random randomGenerator;
    protected int chunk_X;
    protected int chunk_Z;
    protected BiomeGenBase biome;
    protected WorldGenerator clayGen = new WorldGenClay(4);
    protected WorldGenerator sandGen;
    protected WorldGenerator gravelAsSandGen;
    protected WorldGenerator dirtGen;
    protected WorldGenerator gravelGen;
    protected WorldGenerator coalGen;
    protected WorldGenerator ironGen;
    protected WorldGenerator goldGen;
    protected WorldGenerator redstoneGen;
    protected WorldGenerator diamondGen;
    protected WorldGenerator lapisGen;
    protected WorldGenerator plantYellowGen;
    protected WorldGenerator plantRedGen;
    protected WorldGenerator mushroomBrownGen;
    protected WorldGenerator mushroomRedGen;
    protected WorldGenerator bigMushroomGen;
    protected WorldGenerator reedGen;
    protected WorldGenerator cactusGen;
    protected WorldGenerator waterlilyGen;
    protected int waterlilyPerChunk;
    protected int treesPerChunk;
    protected int flowersPerChunk;
    protected int grassPerChunk;
    protected int deadBushPerChunk;
    protected int mushroomsPerChunk;
    protected int reedsPerChunk;
    protected int cactiPerChunk;
    protected int sandPerChunk;
    protected int sandPerChunk2;
    protected int clayPerChunk;
    protected int bigMushroomsPerChunk;
    public boolean generateLakes;

    public BiomeDecorator(BiomeGenBase par1BiomeGenBase) {
        this.sandGen = new WorldGenSand(7, Block.sand.blockID);
        this.gravelAsSandGen = new WorldGenSand(6, Block.gravel.blockID);
        this.dirtGen = new WorldGenMinable(Block.dirt.blockID, 32);
        this.gravelGen = new WorldGenMinable(Block.gravel.blockID, 32);
        this.coalGen = new WorldGenMinable(Block.oreCoal.blockID, 16);
        this.ironGen = new WorldGenMinable(Block.oreIron.blockID, 8);
        this.goldGen = new WorldGenMinable(Block.oreGold.blockID, 8);
        this.redstoneGen = new WorldGenMinable(Block.oreRedstone.blockID, 7);
        this.diamondGen = new WorldGenMinable(Block.oreDiamond.blockID, 7);
        this.lapisGen = new WorldGenMinable(Block.oreLapis.blockID, 6);
        this.plantYellowGen = new WorldGenFlowers(Block.plantYellow.blockID);
        this.plantRedGen = new WorldGenFlowers(Block.plantRed.blockID);
        this.mushroomBrownGen = new WorldGenFlowers(Block.mushroomBrown.blockID);
        this.mushroomRedGen = new WorldGenFlowers(Block.mushroomRed.blockID);
        this.bigMushroomGen = new WorldGenBigMushroom();
        this.reedGen = new WorldGenReed();
        this.cactusGen = new WorldGenCactus();
        this.waterlilyGen = new WorldGenWaterlily();
        this.waterlilyPerChunk = 0;
        this.treesPerChunk = 0;
        this.flowersPerChunk = 2;
        this.grassPerChunk = 1;
        this.deadBushPerChunk = 0;
        this.mushroomsPerChunk = 0;
        this.reedsPerChunk = 0;
        this.cactiPerChunk = 0;
        this.sandPerChunk = 1;
        this.sandPerChunk2 = 3;
        this.clayPerChunk = 1;
        this.bigMushroomsPerChunk = 0;
        this.generateLakes = true;
        this.biome = par1BiomeGenBase;
    }

    public void decorate(World par1World, Random par2Random, int par3, int par4) {
        if (this.currentWorld != null) {
            throw new RuntimeException("Already decorating!!");
        }
        this.currentWorld = par1World;
        this.randomGenerator = par2Random;
        this.chunk_X = par3;
        this.chunk_Z = par4;
        this.decorate();
        this.currentWorld = null;
        this.randomGenerator = null;
    }

    protected void decorate() {
        this.generateOres();
        for (int i = 0; i < this.sandPerChunk2; ++i) {
            int i1 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int k5 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.sandGen.generate(this.currentWorld, this.randomGenerator, i1, this.currentWorld.getTopSolidOrLiquidBlock(i1, k5), k5);
        }
        for (int j = 0; j < this.clayPerChunk; ++j) {
            int j1 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int l5 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.clayGen.generate(this.currentWorld, this.randomGenerator, j1, this.currentWorld.getTopSolidOrLiquidBlock(j1, l5), l5);
        }
        for (int k = 0; k < this.sandPerChunk; ++k) {
            int k1 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int i6 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.sandGen.generate(this.currentWorld, this.randomGenerator, k1, this.currentWorld.getTopSolidOrLiquidBlock(k1, i6), i6);
        }
        int l = this.treesPerChunk;
        if (this.randomGenerator.nextInt(10) == 0) {
            ++l;
        }
        for (int l1 = 0; l1 < l; ++l1) {
            int j6 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int k10 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            WorldGenerator worldgenerator = this.biome.getRandomWorldGenForTrees(this.randomGenerator);
            worldgenerator.setScale(1.0, 1.0, 1.0);
            worldgenerator.generate(this.currentWorld, this.randomGenerator, j6, this.currentWorld.getHeightValue(j6, k10), k10);
        }
        for (int i2 = 0; i2 < this.bigMushroomsPerChunk; ++i2) {
            int k6 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int l10 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.bigMushroomGen.generate(this.currentWorld, this.randomGenerator, k6, this.currentWorld.getHeightValue(k6, l10), l10);
        }
        for (int j2 = 0; j2 < this.flowersPerChunk; ++j2) {
            int l6 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int i11 = this.randomGenerator.nextInt(128);
            int l14 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.plantYellowGen.generate(this.currentWorld, this.randomGenerator, l6, i11, l14);
            if (this.randomGenerator.nextInt(4) != 0) continue;
            int i7 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int j11 = this.randomGenerator.nextInt(128);
            int i15 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.plantRedGen.generate(this.currentWorld, this.randomGenerator, i7, j11, i15);
        }
        for (int k2 = 0; k2 < this.grassPerChunk; ++k2) {
            int j7 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int k11 = this.randomGenerator.nextInt(128);
            int j15 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            WorldGenerator worldgenerator1 = this.biome.func_48410_b(this.randomGenerator);
            worldgenerator1.generate(this.currentWorld, this.randomGenerator, j7, k11, j15);
        }
        for (int l2 = 0; l2 < this.deadBushPerChunk; ++l2) {
            int k7 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int l11 = this.randomGenerator.nextInt(128);
            int k15 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            new WorldGenDeadBush(Block.deadBush.blockID).generate(this.currentWorld, this.randomGenerator, k7, l11, k15);
        }
        for (int i3 = 0; i3 < this.waterlilyPerChunk; ++i3) {
            int l15;
            int l7 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int i12 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            for (l15 = this.randomGenerator.nextInt(128); l15 > 0 && this.currentWorld.getBlockId(l7, l15 - 1, i12) == 0; --l15) {
            }
            this.waterlilyGen.generate(this.currentWorld, this.randomGenerator, l7, l15, i12);
        }
        for (int j3 = 0; j3 < this.mushroomsPerChunk; ++j3) {
            if (this.randomGenerator.nextInt(4) == 0) {
                int i8 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
                int j12 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
                int i16 = this.currentWorld.getHeightValue(i8, j12);
                this.mushroomBrownGen.generate(this.currentWorld, this.randomGenerator, i8, i16, j12);
            }
            if (this.randomGenerator.nextInt(8) != 0) continue;
            int j8 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int k12 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            int j16 = this.randomGenerator.nextInt(128);
            this.mushroomRedGen.generate(this.currentWorld, this.randomGenerator, j8, j16, k12);
        }
        if (this.randomGenerator.nextInt(4) == 0) {
            int k3 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int k8 = this.randomGenerator.nextInt(128);
            int l12 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.mushroomBrownGen.generate(this.currentWorld, this.randomGenerator, k3, k8, l12);
        }
        if (this.randomGenerator.nextInt(8) == 0) {
            int l3 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int l8 = this.randomGenerator.nextInt(128);
            int i13 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.mushroomRedGen.generate(this.currentWorld, this.randomGenerator, l3, l8, i13);
        }
        for (int i4 = 0; i4 < this.reedsPerChunk; ++i4) {
            int i9 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int j13 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            int k16 = this.randomGenerator.nextInt(128);
            this.reedGen.generate(this.currentWorld, this.randomGenerator, i9, k16, j13);
        }
        for (int j4 = 0; j4 < 10; ++j4) {
            int j9 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int k13 = this.randomGenerator.nextInt(128);
            int l16 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.reedGen.generate(this.currentWorld, this.randomGenerator, j9, k13, l16);
        }
        if (this.randomGenerator.nextInt(32) == 0) {
            int k4 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int k9 = this.randomGenerator.nextInt(128);
            int l13 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.currentWorld, this.randomGenerator, k4, k9, l13);
        }
        for (int l4 = 0; l4 < this.cactiPerChunk; ++l4) {
            int l9 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int i14 = this.randomGenerator.nextInt(128);
            int i17 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            this.cactusGen.generate(this.currentWorld, this.randomGenerator, l9, i14, i17);
        }
        if (this.generateLakes) {
            for (int i5 = 0; i5 < 50; ++i5) {
                int i10 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
                int j14 = this.randomGenerator.nextInt(this.randomGenerator.nextInt(120) + 8);
                int j17 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
                new WorldGenLiquids(Block.waterMoving.blockID).generate(this.currentWorld, this.randomGenerator, i10, j14, j17);
            }
            for (int j5 = 0; j5 < 20; ++j5) {
                int j10 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
                int k14 = this.randomGenerator.nextInt(this.randomGenerator.nextInt(this.randomGenerator.nextInt(112) + 8) + 8);
                int k17 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
                new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.currentWorld, this.randomGenerator, j10, k14, k17);
            }
        }
    }

    protected void genStandardOre1(int par1, WorldGenerator par2WorldGenerator, int par3, int par4) {
        for (int i = 0; i < par1; ++i) {
            int j = this.chunk_X + this.randomGenerator.nextInt(16);
            int k = this.randomGenerator.nextInt(par4 - par3) + par3;
            int l = this.chunk_Z + this.randomGenerator.nextInt(16);
            par2WorldGenerator.generate(this.currentWorld, this.randomGenerator, j, k, l);
        }
    }

    protected void genStandardOre2(int par1, WorldGenerator par2WorldGenerator, int par3, int par4) {
        for (int i = 0; i < par1; ++i) {
            int j = this.chunk_X + this.randomGenerator.nextInt(16);
            int k = this.randomGenerator.nextInt(par4) + this.randomGenerator.nextInt(par4) + (par3 - par4);
            int l = this.chunk_Z + this.randomGenerator.nextInt(16);
            par2WorldGenerator.generate(this.currentWorld, this.randomGenerator, j, k, l);
        }
    }

    protected void generateOres() {
        this.genStandardOre1(20, this.dirtGen, 0, 128);
        this.genStandardOre1(10, this.gravelGen, 0, 128);
        this.genStandardOre1(20, this.coalGen, 0, 128);
        this.genStandardOre1(20, this.ironGen, 0, 64);
        this.genStandardOre1(2, this.goldGen, 0, 32);
        this.genStandardOre1(8, this.redstoneGen, 0, 16);
        this.genStandardOre1(1, this.diamondGen, 0, 16);
        this.genStandardOre2(1, this.lapisGen, 16, 16);
    }
}

